/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.ByteDanceResponseRecordSegShardInfoResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationListResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationOnlineServiceEnableReq;
import code.byted.cdp.model.ByteDanceResponseSegmentationOnlineServiceEnableResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationRefreshResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationUploadResp;
import code.byted.cdp.model.CommonResponse;
import code.byted.cdp.model.LegacyManualSegCreateRequest;
import code.byted.cdp.model.LegacyUploadedSegCreateRequest;
import code.byted.cdp.model.ManualsegmentUploadBody1;
import code.byted.cdp.model.SegOpenApiFileUploadResponse;
import code.byted.cdp.model.SimplifiedSegCreateOrUpdateRequest;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SegmentationApi {
    private ApiClient apiClient;

    public SegmentationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createConditionalSegmentCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SimplifiedSegCreateOrUpdateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "createConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createConditionalSegmentValidateBeforeCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling createConditionalSegment(Async)");
        }
        Call call = this.createConditionalSegmentCall(tenantId, body, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationResp createConditionalSegment(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = this.createConditionalSegmentWithHttpInfo(tenantId, body);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationResp> createConditionalSegmentWithHttpInfo(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        Call call = this.createConditionalSegmentValidateBeforeCall(tenantId, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call createConditionalSegmentAsync(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.createConditionalSegmentValidateBeforeCall(tenantId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call downloadSegFileCall(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (formatType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("formatType", formatType));
        }
        if (needEncrypt != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("needEncrypt", needEncrypt));
        }
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "downloadSegFile"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadSegFileValidateBeforeCall(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling downloadSegFile(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling downloadSegFile(Async)");
        }
        if (formatType == null) {
            throw new ApiException("Missing the required parameter 'formatType' when calling downloadSegFile(Async)");
        }
        Call call = this.downloadSegFileCall(tenantId, segId, formatType, needEncrypt, progressListener, progressRequestListener);
        return call;
    }

    public File downloadSegFile(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt) throws ApiException {
        ApiResponse<File> resp = this.downloadSegFileWithHttpInfo(tenantId, segId, formatType, needEncrypt);
        return resp.getData();
    }

    public ApiResponse<File> downloadSegFileWithHttpInfo(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt) throws ApiException {
        Call call = this.downloadSegFileValidateBeforeCall(tenantId, segId, formatType, needEncrypt, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call downloadSegFileAsync(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        Call call = this.downloadSegFileValidateBeforeCall(tenantId, segId, formatType, needEncrypt, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call legacyCreateManualSegmentCall(Integer tenantId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LegacyManualSegCreateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyCreateManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyCreateManualSegmentValidateBeforeCall(Integer tenantId, LegacyManualSegCreateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateManualSegment(Async)");
        }
        Call call = this.legacyCreateManualSegmentCall(tenantId, body, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationResp legacyCreateManualSegment(Integer tenantId, LegacyManualSegCreateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = this.legacyCreateManualSegmentWithHttpInfo(tenantId, body);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationResp> legacyCreateManualSegmentWithHttpInfo(Integer tenantId, LegacyManualSegCreateRequest body) throws ApiException {
        Call call = this.legacyCreateManualSegmentValidateBeforeCall(tenantId, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call legacyCreateManualSegmentAsync(Integer tenantId, LegacyManualSegCreateRequest body, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.legacyCreateManualSegmentValidateBeforeCall(tenantId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call legacyCreateUploadSegmentCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LegacyUploadedSegCreateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyCreateUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyCreateUploadSegmentValidateBeforeCall(LegacyUploadedSegCreateRequest body, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateUploadSegment(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateUploadSegment(Async)");
        }
        Call call = this.legacyCreateUploadSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseRecordSegShardInfoResp legacyCreateUploadSegment(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseRecordSegShardInfoResp> resp = this.legacyCreateUploadSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseRecordSegShardInfoResp> legacyCreateUploadSegmentWithHttpInfo(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        Call call = this.legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call legacyCreateUploadSegmentAsync(LegacyUploadedSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseRecordSegShardInfoResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call legacyDeleteSegmentCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyDeleteSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyDeleteSegmentValidateBeforeCall(Integer tenantId, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyDeleteSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyDeleteSegment(Async)");
        }
        Call call = this.legacyDeleteSegmentCall(tenantId, segId, progressListener, progressRequestListener);
        return call;
    }

    public void legacyDeleteSegment(Integer tenantId, Integer segId) throws ApiException {
        this.legacyDeleteSegmentWithHttpInfo(tenantId, segId);
    }

    public ApiResponse<Void> legacyDeleteSegmentWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        Call call = this.legacyDeleteSegmentValidateBeforeCall(tenantId, segId, null, null);
        return this.apiClient.execute(call);
    }

    public Call legacyDeleteSegmentAsync(Integer tenantId, Integer segId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{};
        Call call = this.legacyDeleteSegmentValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call legacyGetSegmentCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyGetSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyGetSegmentValidateBeforeCall(Integer tenantId, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyGetSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyGetSegment(Async)");
        }
        Call call = this.legacyGetSegmentCall(tenantId, segId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationResp legacyGetSegment(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = this.legacyGetSegmentWithHttpInfo(tenantId, segId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationResp> legacyGetSegmentWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        Call call = this.legacyGetSegmentValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call legacyGetSegmentAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.legacyGetSegmentValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call legacyGetSegmentListCall(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (current != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("current", current));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        if (isSelfSee != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isSelfSee", isSelfSee));
        }
        if (isOnlySourceReady != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isOnlySourceReady", isOnlySourceReady));
        }
        if (idType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("idType", idType));
        }
        if (segTypes != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("segTypes", segTypes));
        }
        if (sourcePlatform != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourcePlatform", sourcePlatform));
        }
        if (isAbaseAvailable != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isAbaseAvailable", isAbaseAvailable));
        }
        if (isAbaseEnabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isAbaseEnabled", isAbaseEnabled));
        }
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyGetSegmentList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyGetSegmentListValidateBeforeCall(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyGetSegmentList(Async)");
        }
        Call call = this.legacyGetSegmentListCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationListResp legacyGetSegmentList(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationListResp> resp = this.legacyGetSegmentListWithHttpInfo(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationListResp> legacyGetSegmentListWithHttpInfo(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled) throws ApiException {
        Call call = this.legacyGetSegmentListValidateBeforeCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationListResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call legacyGetSegmentListAsync(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, final ApiCallback<ByteDanceResponseSegmentationListResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.legacyGetSegmentListValidateBeforeCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationListResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call legacyModifyManualSegmentCall(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LegacyManualSegCreateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyModifyManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyModifyManualSegmentValidateBeforeCall(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyModifyManualSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyModifyManualSegment(Async)");
        }
        Call call = this.legacyModifyManualSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;
    }

    public void legacyModifyManualSegment(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body) throws ApiException {
        this.legacyModifyManualSegmentWithHttpInfo(tenantId, segId, body);
    }

    public ApiResponse<Void> legacyModifyManualSegmentWithHttpInfo(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body) throws ApiException {
        Call call = this.legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call legacyModifyManualSegmentAsync(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{};
        Call call = this.legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call modifyConditionalSegmentCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SimplifiedSegCreateOrUpdateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "modifyConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call modifyConditionalSegmentValidateBeforeCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling modifyConditionalSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifyConditionalSegment(Async)");
        }
        Call call = this.modifyConditionalSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponse modifyConditionalSegment(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<CommonResponse> resp = this.modifyConditionalSegmentWithHttpInfo(tenantId, segId, body);
        return resp.getData();
    }

    public ApiResponse<CommonResponse> modifyConditionalSegmentWithHttpInfo(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        Call call = this.modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call modifyConditionalSegmentAsync(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<CommonResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call refreshSegCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "refreshSeg"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-06-20"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call refreshSegValidateBeforeCall(Integer tenantId, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling refreshSeg(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling refreshSeg(Async)");
        }
        Call call = this.refreshSegCall(tenantId, segId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationRefreshResp refreshSeg(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationRefreshResp> resp = this.refreshSegWithHttpInfo(tenantId, segId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationRefreshResp> refreshSegWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        Call call = this.refreshSegValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call refreshSegAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationRefreshResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.refreshSegValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call segmentOnlineServiceEnableCall(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ByteDanceResponseSegmentationOnlineServiceEnableReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "segmentOnlineServiceEnable"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call segmentOnlineServiceEnableValidateBeforeCall(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling segmentOnlineServiceEnable(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling segmentOnlineServiceEnable(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling segmentOnlineServiceEnable(Async)");
        }
        Call call = this.segmentOnlineServiceEnableCall(body, tenantId, segId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationOnlineServiceEnableResp segmentOnlineServiceEnable(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationOnlineServiceEnableResp> resp = this.segmentOnlineServiceEnableWithHttpInfo(body, tenantId, segId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationOnlineServiceEnableResp> segmentOnlineServiceEnableWithHttpInfo(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId) throws ApiException {
        Call call = this.segmentOnlineServiceEnableValidateBeforeCall(body, tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationOnlineServiceEnableResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call segmentOnlineServiceEnableAsync(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationOnlineServiceEnableResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.segmentOnlineServiceEnableValidateBeforeCall(body, tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationOnlineServiceEnableResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call uploadSegFileCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "uploadSegFile"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadSegFileValidateBeforeCall(File file, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadSegFile(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFile(Async)");
        }
        Call call = this.uploadSegFileCall(file, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationUploadResp uploadSegFile(File file, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationUploadResp> resp = this.uploadSegFileWithHttpInfo(file, tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationUploadResp> uploadSegFileWithHttpInfo(File file, Integer tenantId) throws ApiException {
        Call call = this.uploadSegFileValidateBeforeCall(file, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call uploadSegFileAsync(File file, Integer tenantId, final ApiCallback<ByteDanceResponseSegmentationUploadResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.uploadSegFileValidateBeforeCall(file, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call uploadSegFileToChCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "uploadSegFileToCh"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadSegFileToChValidateBeforeCall(File file, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadSegFileToCh(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFileToCh(Async)");
        }
        Call call = this.uploadSegFileToChCall(file, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public SegOpenApiFileUploadResponse uploadSegFileToCh(File file, Integer tenantId) throws ApiException {
        ApiResponse<SegOpenApiFileUploadResponse> resp = this.uploadSegFileToChWithHttpInfo(file, tenantId);
        return resp.getData();
    }

    public ApiResponse<SegOpenApiFileUploadResponse> uploadSegFileToChWithHttpInfo(File file, Integer tenantId) throws ApiException {
        Call call = this.uploadSegFileToChValidateBeforeCall(file, tenantId, null, null);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call uploadSegFileToChAsync(File file, Integer tenantId, final ApiCallback<SegOpenApiFileUploadResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.uploadSegFileToChValidateBeforeCall(file, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call uploadSegFileToChCall(ManualsegmentUploadBody1 body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManualsegmentUploadBody1 localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "uploadSegFileToCh"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadSegFileToChValidateBeforeCall(ManualsegmentUploadBody1 body, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling uploadSegFileToCh(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFileToCh(Async)");
        }
        Call call = this.uploadSegFileToChCall(body, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public SegOpenApiFileUploadResponse uploadSegFileToCh(ManualsegmentUploadBody1 body, Integer tenantId) throws ApiException {
        ApiResponse<SegOpenApiFileUploadResponse> resp = this.uploadSegFileToChWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ApiResponse<SegOpenApiFileUploadResponse> uploadSegFileToChWithHttpInfo(ManualsegmentUploadBody1 body, Integer tenantId) throws ApiException {
        Call call = this.uploadSegFileToChValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call uploadSegFileToChAsync(ManualsegmentUploadBody1 body, Integer tenantId, final ApiCallback<SegOpenApiFileUploadResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.uploadSegFileToChValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

