/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.ListCdpEventPropertyVo;
import code.byted.cdp.model.ListCdpEventVo;
import code.byted.cdp.model.ListCdpPropertyVo;
import code.byted.cdp.model.ListDataSourceListItemVo;
import code.byted.cdp.model.ListString;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasourceApi {
    private ApiClient apiClient;

    public DatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for queryDataSourceList
     * @param xTenant  (required)
     * @param sourceName 数据源名称 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryDataSourceListCall(Long xTenant, String sourceName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourceName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sourceName", sourceName));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryDataSourceList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryDataSourceListValidateBeforeCall(Long xTenant, String sourceName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryDataSourceList(Async)");
        }

        com.squareup.okhttp.Call call = queryDataSourceListCall(xTenant, sourceName, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询数据源列表openapi
     * 
     * @param xTenant  (required)
     * @param sourceName 数据源名称 (optional)
     * @return ListDataSourceListItemVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListDataSourceListItemVo queryDataSourceList(Long xTenant, String sourceName) throws ApiException {
        ApiResponse<ListDataSourceListItemVo> resp = queryDataSourceListWithHttpInfo(xTenant, sourceName);
        return resp.getData();
    }

    /**
     * 查询数据源列表openapi
     * 
     * @param xTenant  (required)
     * @param sourceName 数据源名称 (optional)
     * @return ApiResponse&lt;ListDataSourceListItemVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListDataSourceListItemVo> queryDataSourceListWithHttpInfo(Long xTenant, String sourceName) throws ApiException {
        com.squareup.okhttp.Call call = queryDataSourceListValidateBeforeCall(xTenant, sourceName, null, null);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询数据源列表openapi (asynchronously)
     * 
     * @param xTenant  (required)
     * @param sourceName 数据源名称 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryDataSourceListAsync(Long xTenant, String sourceName, final ApiCallback<ListDataSourceListItemVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryDataSourceListValidateBeforeCall(xTenant, sourceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for queryeventList
     * @param dataSourceId 数据源id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryeventListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryeventList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryeventListValidateBeforeCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling queryeventList(Async)");
        }

        com.squareup.okhttp.Call call = queryeventListCall(dataSourceId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询事件列表
     * 
     * @param dataSourceId 数据源id (required)
     * @return ListCdpEventVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpEventVo queryeventList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpEventVo> resp = queryeventListWithHttpInfo(dataSourceId);
        return resp.getData();
    }

    /**
     * 查询事件列表
     * 
     * @param dataSourceId 数据源id (required)
     * @return ApiResponse&lt;ListCdpEventVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpEventVo> queryeventListWithHttpInfo(Integer dataSourceId) throws ApiException {
        com.squareup.okhttp.Call call = queryeventListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询事件列表 (asynchronously)
     * 
     * @param dataSourceId 数据源id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryeventListAsync(Integer dataSourceId, final ApiCallback<ListCdpEventVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryeventListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for queryeventPropertyList
     * @param xTenant  (required)
     * @param eventId 事件id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryeventPropertyListCall(Long xTenant, Integer eventId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (eventId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("eventId", eventId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryeventPropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryeventPropertyListValidateBeforeCall(Long xTenant, Integer eventId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryeventPropertyList(Async)");
        }
        // verify the required parameter 'eventId' is set
        if (eventId == null) {
            throw new ApiException("Missing the required parameter 'eventId' when calling queryeventPropertyList(Async)");
        }

        com.squareup.okhttp.Call call = queryeventPropertyListCall(xTenant, eventId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询事件属性列表
     * 
     * @param xTenant  (required)
     * @param eventId 事件id (required)
     * @return ListCdpEventPropertyVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpEventPropertyVo queryeventPropertyList(Long xTenant, Integer eventId) throws ApiException {
        ApiResponse<ListCdpEventPropertyVo> resp = queryeventPropertyListWithHttpInfo(xTenant, eventId);
        return resp.getData();
    }

    /**
     * 查询事件属性列表
     * 
     * @param xTenant  (required)
     * @param eventId 事件id (required)
     * @return ApiResponse&lt;ListCdpEventPropertyVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpEventPropertyVo> queryeventPropertyListWithHttpInfo(Long xTenant, Integer eventId) throws ApiException {
        com.squareup.okhttp.Call call = queryeventPropertyListValidateBeforeCall(xTenant, eventId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询事件属性列表 (asynchronously)
     * 
     * @param xTenant  (required)
     * @param eventId 事件id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryeventPropertyListAsync(Long xTenant, Integer eventId, final ApiCallback<ListCdpEventPropertyVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryeventPropertyListValidateBeforeCall(xTenant, eventId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for querypropertyList
     * @param dataSourceId 数据源id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call querypropertyListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","querypropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call querypropertyListValidateBeforeCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyList(Async)");
        }

        com.squareup.okhttp.Call call = querypropertyListCall(dataSourceId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询单个数据源的表属性字段列表openapi
     * 
     * @param dataSourceId 数据源id (required)
     * @return ListCdpPropertyVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpPropertyVo querypropertyList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpPropertyVo> resp = querypropertyListWithHttpInfo(dataSourceId);
        return resp.getData();
    }

    /**
     * 查询单个数据源的表属性字段列表openapi
     * 
     * @param dataSourceId 数据源id (required)
     * @return ApiResponse&lt;ListCdpPropertyVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpPropertyVo> querypropertyListWithHttpInfo(Integer dataSourceId) throws ApiException {
        com.squareup.okhttp.Call call = querypropertyListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询单个数据源的表属性字段列表openapi (asynchronously)
     * 
     * @param dataSourceId 数据源id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call querypropertyListAsync(Integer dataSourceId, final ApiCallback<ListCdpPropertyVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = querypropertyListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for querypropertyValues
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call querypropertyValuesCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","querypropertyValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call querypropertyValuesValidateBeforeCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling querypropertyValues(Async)");
        }
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyValues(Async)");
        }

        com.squareup.okhttp.Call call = querypropertyValuesCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询属性枚举值
     * 
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @return ListString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListString querypropertyValues(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        ApiResponse<ListString> resp = querypropertyValuesWithHttpInfo(id, dataSourceId, page, pageSize, keyword);
        return resp.getData();
    }

    /**
     * 查询属性枚举值
     * 
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @return ApiResponse&lt;ListString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListString> querypropertyValuesWithHttpInfo(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        com.squareup.okhttp.Call call = querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, null, null);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询属性枚举值 (asynchronously)
     * 
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call querypropertyValuesAsync(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ApiCallback<ListString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
