/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp;

import code.byted.cdp.Pair;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

class SignerV4Impl {
    private static final TimeZone tz;
    private static final Set<String> H_INCLUDE;
    private static final BitSet URLENCODER;
    private static final String CONST_ENCODE = "0123456789ABCDEF";

    SignerV4Impl() {
    }

    public void sign(Request.Builder request, Credentials credentials, RequestBody body, String host, int port, String path, String method, List<Pair> queryList, List<Pair> headers) throws Exception {
        if (port > 0 && port != 80 && port != 443) {
            host = host + ":" + port;
        }
        path = "/open_platform/openapi";
        RequestParam requestParam = RequestParam.builder().isSignUrl(false).body(SignerV4Impl.body2Bytes(body)).host(host).path(path).method(method).date(new Date()).queryList(queryList).headers(headers).build();
        SignRequest signRequest = this.getSignRequest(requestParam, credentials);
        request.addHeader("Host", signRequest.getHost());
        request.addHeader("Content-Type", signRequest.getContentType());
        request.addHeader("X-Date", signRequest.getXDate());
        request.addHeader("X-Content-Sha256", signRequest.getXContentSha256());
        request.addHeader("Authorization", signRequest.getAuthorization());
        if (StringUtils.isNotEmpty((CharSequence)signRequest.getXSecurityToken())) {
            request.header("X-Cdp-Security-Token", signRequest.getXSecurityToken());
        }
    }

    public SignRequest getSignRequest(RequestParam requestParam, Credentials credentials) throws Exception {
        String bodyHash;
        if (requestParam == null || credentials == null) {
            throw new Exception("requestParam and credentials is null");
        }
        if (requestParam.getIsSignUrl() == null || requestParam.getDate() == null || requestParam.getQueryList() == null) {
            throw new Exception("requestParam's isSignUrl or date or queryList is null");
        }
        String formatDate = this.getAppointFormatDate(requestParam.getDate());
        MetaData meta = this.getMetaDate(credentials, this.toDate(formatDate));
        HashMap<String, String> requestSignMap = new HashMap<String, String>();
        SignRequest signRequest = SignRequest.builder().xDate(formatDate).xSecurityToken(credentials.getSessionToken()).build();
        if (StringUtils.isNotEmpty((CharSequence)credentials.getSessionToken())) {
            requestSignMap.put("X-Cdp-Security-Token", credentials.getSessionToken());
        }
        if (requestParam.getIsSignUrl().booleanValue()) {
            for (Pair nv : requestParam.getQueryList()) {
                requestSignMap.put(nv.getName(), nv.getValue());
            }
            requestSignMap.put("X-Date", formatDate);
            requestSignMap.put("X-NotSignBody", "");
            requestSignMap.put("X-Credential", credentials.getAccessKeyID() + "/" + meta.getCredentialScope());
            requestSignMap.put("X-Algorithm", meta.getAlgorithm());
            requestSignMap.put("X-SignedHeaders", meta.getSignedHeaders());
            requestSignMap.put("X-SignedQueries", "");
            ArrayList keys = new ArrayList(requestSignMap.keySet());
            Collections.sort(keys);
            requestSignMap.put("X-SignedQueries", StringUtils.join((Iterable)keys, (String)";"));
            signRequest.setXNotSignBody("");
            signRequest.setXCredential(credentials.getAccessKeyID() + "/" + meta.getCredentialScope());
            signRequest.setXAlgorithm(meta.getAlgorithm());
            signRequest.setXSignedHeaders(meta.getSignedHeaders());
            signRequest.setXSignedQueries(StringUtils.join((Iterable)keys, (String)";"));
            bodyHash = SignerV4Impl.hashSHA256(new byte[0]);
        } else {
            for (Pair header : requestParam.getHeaders()) {
                requestSignMap.put(header.getName(), header.getValue());
            }
            if (requestSignMap.get("Content-Type") == null) {
                signRequest.setContentType("application/x-www-form-urlencoded; charset=utf-8");
            } else {
                signRequest.setContentType((String)requestSignMap.get("Content-Type"));
            }
            requestSignMap.put("X-Date", formatDate);
            requestSignMap.put("Host", requestParam.getHost());
            requestSignMap.remove("Content-Type");
            bodyHash = SignerV4Impl.hashSHA256(requestParam.getBody() == null ? new byte[]{} : requestParam.getBody());
            requestSignMap.put("X-Content-Sha256", bodyHash);
            signRequest.setHost(requestParam.getHost());
            signRequest.setXContentSha256(bodyHash);
        }
        String signature = this.getSignatureStr(requestParam, meta, credentials.getSecretAccessKey(), formatDate, requestSignMap, bodyHash);
        if (requestParam.getIsSignUrl().booleanValue()) {
            signRequest.setXSignature(signature);
        } else {
            signRequest.setAuthorization(this.buildAuthHeaderV4(signature, meta, credentials));
        }
        return signRequest;
    }

    private String getSignatureStr(RequestParam requestParam, MetaData meta, String secreteAccessKey, String formatDate, Map<String, String> requestSignMap, String bodyHash) throws Exception {
        String hashedCanonReq = this.hashedCanonicalRequestV4(requestParam, meta, requestSignMap, bodyHash);
        String stringToSign = StringUtils.join((Object[])new String[]{meta.getAlgorithm(), formatDate, meta.getCredentialScope(), hashedCanonReq}, (String)"\n");
        byte[] signingKey = this.genSigningSecretKeyV4(secreteAccessKey, meta.getDate(), meta.getRegion(), meta.getService());
        return this.signatureV4(signingKey, stringToSign);
    }

    private MetaData getMetaDate(Credentials credentials, String date) {
        MetaData meta = new MetaData();
        meta.setDate(date);
        meta.setService(credentials.getService());
        meta.setRegion(credentials.getRegion());
        meta.setAlgorithm("HMAC-SHA256");
        meta.setSignedHeaders("");
        meta.setCredentialScope(StringUtils.join((Object[])new String[]{meta.getDate(), meta.getRegion(), meta.getService(), "request"}, (String)"/"));
        return meta;
    }

    private String hashedCanonicalRequestV4(RequestParam requestParam, MetaData meta, Map<String, String> requestSignMap, String bodyHash) throws Exception {
        String canonicalRequest;
        ArrayList<Pair> queryList = new ArrayList<Pair>();
        if (requestParam.getIsSignUrl().booleanValue()) {
            for (String key : requestSignMap.keySet()) {
                queryList.add(new Pair(key, requestSignMap.get(key)));
            }
            canonicalRequest = StringUtils.join((Object[])new String[]{requestParam.getMethod(), this.normUri(requestParam.getPath()), this.normQuery(queryList), "\n", meta.getSignedHeaders(), bodyHash}, (String)"\n");
        } else {
            String canonicalHeaders = this.getCanonicalHeaders(requestParam, meta, requestSignMap);
            canonicalRequest = StringUtils.join((Object[])new String[]{requestParam.getMethod(), this.normUri(requestParam.getPath()), this.normQuery(requestParam.getQueryList()), canonicalHeaders, meta.getSignedHeaders(), bodyHash}, (String)"\n");
        }
        return SignerV4Impl.hashSHA256(canonicalRequest.getBytes());
    }

    private String getCanonicalHeaders(RequestParam requestParam, MetaData meta, Map<String, String> requestSignMap) {
        HashMap<String, String> signMap = new HashMap<String, String>();
        List<String> signedHeaders = this.sortHeaders(requestSignMap, signMap);
        if (!requestParam.getIsSignUrl().booleanValue()) {
            meta.setSignedHeaders(StringUtils.join(signedHeaders, (String)";"));
        }
        if (StringUtils.isEmpty((CharSequence)requestParam.getPath())) {
            requestParam.setPath("/");
        }
        StringBuilder signedHeadersToSignStr = new StringBuilder();
        for (String h : signedHeaders) {
            String[] split;
            String port;
            String value = ((String)signMap.get(h)).trim();
            if (h.equals("host") && value.contains(":") && ((port = (split = value.split(":"))[1]).equals("80") || port.equals("443"))) {
                value = split[0];
            }
            signedHeadersToSignStr.append(h).append(":").append(value).append("\n");
        }
        return signedHeadersToSignStr.toString();
    }

    private List<String> sortHeaders(Map<String, String> requestSignMap, Map<String, String> signMap) {
        ArrayList<String> signedHeaders = new ArrayList<String>();
        for (Map.Entry<String, String> entry : requestSignMap.entrySet()) {
            signMap.put(entry.getKey().toLowerCase(), entry.getValue());
            if (!H_INCLUDE.contains(entry.getKey()) && !entry.getKey().startsWith("X-")) continue;
            signedHeaders.add(entry.getKey().toLowerCase());
        }
        Collections.sort(signedHeaders);
        return signedHeaders;
    }

    private String signatureV4(byte[] signingKey, String stringToSign) throws Exception {
        return Hex.encodeHexString((byte[])SignerV4Impl.hmacSHA256(signingKey, stringToSign));
    }

    private byte[] genSigningSecretKeyV4(String secretKey, String date, String region, String service) throws Exception {
        byte[] kDate = SignerV4Impl.hmacSHA256(secretKey.getBytes(), date);
        byte[] kRegion = SignerV4Impl.hmacSHA256(kDate, region);
        byte[] kService = SignerV4Impl.hmacSHA256(kRegion, service);
        return SignerV4Impl.hmacSHA256(kService, "request");
    }

    private String buildAuthHeaderV4(String signature, MetaData meta, Credentials credentials) {
        String credential = credentials.getAccessKeyID() + "/" + meta.getCredentialScope();
        return meta.getAlgorithm() + " Credential=" + credential + ", SignedHeaders=" + meta.getSignedHeaders() + ", Signature=" + signature;
    }

    private String getCurrentFormatDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private String getAppointFormatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(date);
    }

    private String toDate(String timestamp) {
        return timestamp.substring(0, 8);
    }

    private String normUri(String path) {
        Object[] parts = path.split("/", -1);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.signStringEncoder((String)parts[i]);
        }
        return StringUtils.join((Object[])parts, (String)"/");
    }

    private String normQuery(List<Pair> params) {
        params.sort(new Comparator<Pair>(){
            private static final boolean NULL_FIRST = false;

            @Override
            public int compare(Pair o1, Pair o2) {
                if (o1.getName() == null) {
                    return o2.getName() == null ? 0 : 1;
                }
                if (o2.getName() == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return this.signQueryEncoder(params);
    }

    private String signQueryEncoder(List<Pair> params) {
        StringBuilder result = new StringBuilder();
        for (Pair pair : params) {
            String encodedName = this.signStringEncoder(pair.getName());
            String encodedValue = this.signStringEncoder(pair.getValue());
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private String signStringEncoder(String source) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length());
        ByteBuffer bb = Charset.forName("UTF-8").encode(source);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URLENCODER.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (b == 32) {
                buf.append("%20");
                continue;
            }
            buf.append("%");
            char hex1 = CONST_ENCODE.charAt(b >> 4);
            char hex2 = CONST_ENCODE.charAt(b & 0xF);
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    public static String hashSHA256(byte[] content) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Hex.encodeHexString((byte[])md.digest(content));
        }
        catch (Exception e) {
            throw new Exception("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    public static byte[] hmacSHA256(byte[] key, String content) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(content.getBytes());
        }
        catch (Exception e) {
            throw new Exception("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public static byte[] body2Bytes(RequestBody body) {
        if (body == null) {
            return new byte[0];
        }
        try {
            Buffer buffer = new Buffer();
            body.writeTo((BufferedSink)buffer);
            return buffer.readByteArray();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    static {
        int i;
        tz = TimeZone.getTimeZone("UTC");
        H_INCLUDE = new HashSet<String>();
        URLENCODER = new BitSet(256);
        H_INCLUDE.add("Content-Type");
        H_INCLUDE.add("Content-Md5");
        H_INCLUDE.add("Host");
        for (i = 97; i <= 122; ++i) {
            URLENCODER.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URLENCODER.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URLENCODER.set(i);
        }
        URLENCODER.set(45);
        URLENCODER.set(95);
        URLENCODER.set(46);
        URLENCODER.set(126);
    }

    public static class MetaData {
        private String algorithm;
        private String credentialScope;
        private String signedHeaders;
        private String date;
        private String region;
        private String service;

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getCredentialScope() {
            return this.credentialScope;
        }

        public String getSignedHeaders() {
            return this.signedHeaders;
        }

        public String getDate() {
            return this.date;
        }

        public String getRegion() {
            return this.region;
        }

        public String getService() {
            return this.service;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public void setCredentialScope(String credentialScope) {
            this.credentialScope = credentialScope;
        }

        public void setSignedHeaders(String signedHeaders) {
            this.signedHeaders = signedHeaders;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setService(String service) {
            this.service = service;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaData)) {
                return false;
            }
            MetaData other = (MetaData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$algorithm = this.getAlgorithm();
            String other$algorithm = other.getAlgorithm();
            if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
                return false;
            }
            String this$credentialScope = this.getCredentialScope();
            String other$credentialScope = other.getCredentialScope();
            if (this$credentialScope == null ? other$credentialScope != null : !this$credentialScope.equals(other$credentialScope)) {
                return false;
            }
            String this$signedHeaders = this.getSignedHeaders();
            String other$signedHeaders = other.getSignedHeaders();
            if (this$signedHeaders == null ? other$signedHeaders != null : !this$signedHeaders.equals(other$signedHeaders)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$service = this.getService();
            String other$service = other.getService();
            return !(this$service == null ? other$service != null : !this$service.equals(other$service));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $algorithm = this.getAlgorithm();
            result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
            String $credentialScope = this.getCredentialScope();
            result = result * 59 + ($credentialScope == null ? 43 : $credentialScope.hashCode());
            String $signedHeaders = this.getSignedHeaders();
            result = result * 59 + ($signedHeaders == null ? 43 : $signedHeaders.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $service = this.getService();
            result = result * 59 + ($service == null ? 43 : $service.hashCode());
            return result;
        }

        public String toString() {
            return "SignerV4Impl.MetaData(algorithm=" + this.getAlgorithm() + ", credentialScope=" + this.getCredentialScope() + ", signedHeaders=" + this.getSignedHeaders() + ", date=" + this.getDate() + ", region=" + this.getRegion() + ", service=" + this.getService() + ")";
        }
    }

    public static class RequestParam {
        private Boolean isSignUrl;
        private byte[] body;
        private String method;
        private Date date;
        private String path;
        private String host;
        private List<Pair> queryList;
        private List<Pair> headers;

        RequestParam(Boolean isSignUrl, byte[] body, String method, Date date, String path, String host, List<Pair> queryList, List<Pair> headers) {
            this.isSignUrl = isSignUrl;
            this.body = body;
            this.method = method;
            this.date = date;
            this.path = path;
            this.host = host;
            this.queryList = queryList;
            this.headers = headers;
        }

        public static RequestParamBuilder builder() {
            return new RequestParamBuilder();
        }

        public void setIsSignUrl(Boolean isSignUrl) {
            this.isSignUrl = isSignUrl;
        }

        public void setBody(byte[] body) {
            this.body = body;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setQueryList(List<Pair> queryList) {
            this.queryList = queryList;
        }

        public void setHeaders(List<Pair> headers) {
            this.headers = headers;
        }

        public Boolean getIsSignUrl() {
            return this.isSignUrl;
        }

        public byte[] getBody() {
            return this.body;
        }

        public String getMethod() {
            return this.method;
        }

        public Date getDate() {
            return this.date;
        }

        public String getPath() {
            return this.path;
        }

        public String getHost() {
            return this.host;
        }

        public List<Pair> getQueryList() {
            return this.queryList;
        }

        public List<Pair> getHeaders() {
            return this.headers;
        }

        public static class RequestParamBuilder {
            private Boolean isSignUrl;
            private byte[] body;
            private String method;
            private Date date;
            private String path;
            private String host;
            private List<Pair> queryList;
            private List<Pair> headers;

            RequestParamBuilder() {
            }

            public RequestParamBuilder isSignUrl(Boolean isSignUrl) {
                this.isSignUrl = isSignUrl;
                return this;
            }

            public RequestParamBuilder body(byte[] body) {
                this.body = body;
                return this;
            }

            public RequestParamBuilder method(String method) {
                this.method = method;
                return this;
            }

            public RequestParamBuilder date(Date date) {
                this.date = date;
                return this;
            }

            public RequestParamBuilder path(String path) {
                this.path = path;
                return this;
            }

            public RequestParamBuilder host(String host) {
                this.host = host;
                return this;
            }

            public RequestParamBuilder queryList(List<Pair> queryList) {
                this.queryList = queryList;
                return this;
            }

            public RequestParamBuilder headers(List<Pair> headers) {
                this.headers = headers;
                return this;
            }

            public RequestParam build() {
                return new RequestParam(this.isSignUrl, this.body, this.method, this.date, this.path, this.host, this.queryList, this.headers);
            }

            public String toString() {
                return "SignerV4Impl.RequestParam.RequestParamBuilder(isSignUrl=" + this.isSignUrl + ", body=" + Arrays.toString(this.body) + ", method=" + this.method + ", date=" + this.date + ", path=" + this.path + ", host=" + this.host + ", queryList=" + this.queryList + ", headers=" + this.headers + ")";
            }
        }
    }

    public static class SignRequest {
        private String xDate;
        private String xNotSignBody;
        private String xCredential;
        private String xAlgorithm;
        private String xSignedHeaders;
        private String xSignedQueries;
        private String xSignature;
        private String xSecurityToken;
        private String host;
        private String contentType;
        private String xContentSha256;
        private String authorization;

        SignRequest(String xDate, String xNotSignBody, String xCredential, String xAlgorithm, String xSignedHeaders, String xSignedQueries, String xSignature, String xSecurityToken, String host, String contentType, String xContentSha256, String authorization) {
            this.xDate = xDate;
            this.xNotSignBody = xNotSignBody;
            this.xCredential = xCredential;
            this.xAlgorithm = xAlgorithm;
            this.xSignedHeaders = xSignedHeaders;
            this.xSignedQueries = xSignedQueries;
            this.xSignature = xSignature;
            this.xSecurityToken = xSecurityToken;
            this.host = host;
            this.contentType = contentType;
            this.xContentSha256 = xContentSha256;
            this.authorization = authorization;
        }

        public static SignRequestBuilder builder() {
            return new SignRequestBuilder();
        }

        public String getXDate() {
            return this.xDate;
        }

        public String getXNotSignBody() {
            return this.xNotSignBody;
        }

        public String getXCredential() {
            return this.xCredential;
        }

        public String getXAlgorithm() {
            return this.xAlgorithm;
        }

        public String getXSignedHeaders() {
            return this.xSignedHeaders;
        }

        public String getXSignedQueries() {
            return this.xSignedQueries;
        }

        public String getXSignature() {
            return this.xSignature;
        }

        public String getXSecurityToken() {
            return this.xSecurityToken;
        }

        public String getHost() {
            return this.host;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getXContentSha256() {
            return this.xContentSha256;
        }

        public String getAuthorization() {
            return this.authorization;
        }

        public void setXDate(String xDate) {
            this.xDate = xDate;
        }

        public void setXNotSignBody(String xNotSignBody) {
            this.xNotSignBody = xNotSignBody;
        }

        public void setXCredential(String xCredential) {
            this.xCredential = xCredential;
        }

        public void setXAlgorithm(String xAlgorithm) {
            this.xAlgorithm = xAlgorithm;
        }

        public void setXSignedHeaders(String xSignedHeaders) {
            this.xSignedHeaders = xSignedHeaders;
        }

        public void setXSignedQueries(String xSignedQueries) {
            this.xSignedQueries = xSignedQueries;
        }

        public void setXSignature(String xSignature) {
            this.xSignature = xSignature;
        }

        public void setXSecurityToken(String xSecurityToken) {
            this.xSecurityToken = xSecurityToken;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setXContentSha256(String xContentSha256) {
            this.xContentSha256 = xContentSha256;
        }

        public void setAuthorization(String authorization) {
            this.authorization = authorization;
        }

        public static class SignRequestBuilder {
            private String xDate;
            private String xNotSignBody;
            private String xCredential;
            private String xAlgorithm;
            private String xSignedHeaders;
            private String xSignedQueries;
            private String xSignature;
            private String xSecurityToken;
            private String host;
            private String contentType;
            private String xContentSha256;
            private String authorization;

            SignRequestBuilder() {
            }

            public SignRequestBuilder xDate(String xDate) {
                this.xDate = xDate;
                return this;
            }

            public SignRequestBuilder xNotSignBody(String xNotSignBody) {
                this.xNotSignBody = xNotSignBody;
                return this;
            }

            public SignRequestBuilder xCredential(String xCredential) {
                this.xCredential = xCredential;
                return this;
            }

            public SignRequestBuilder xAlgorithm(String xAlgorithm) {
                this.xAlgorithm = xAlgorithm;
                return this;
            }

            public SignRequestBuilder xSignedHeaders(String xSignedHeaders) {
                this.xSignedHeaders = xSignedHeaders;
                return this;
            }

            public SignRequestBuilder xSignedQueries(String xSignedQueries) {
                this.xSignedQueries = xSignedQueries;
                return this;
            }

            public SignRequestBuilder xSignature(String xSignature) {
                this.xSignature = xSignature;
                return this;
            }

            public SignRequestBuilder xSecurityToken(String xSecurityToken) {
                this.xSecurityToken = xSecurityToken;
                return this;
            }

            public SignRequestBuilder host(String host) {
                this.host = host;
                return this;
            }

            public SignRequestBuilder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public SignRequestBuilder xContentSha256(String xContentSha256) {
                this.xContentSha256 = xContentSha256;
                return this;
            }

            public SignRequestBuilder authorization(String authorization) {
                this.authorization = authorization;
                return this;
            }

            public SignRequest build() {
                return new SignRequest(this.xDate, this.xNotSignBody, this.xCredential, this.xAlgorithm, this.xSignedHeaders, this.xSignedQueries, this.xSignature, this.xSecurityToken, this.host, this.contentType, this.xContentSha256, this.authorization);
            }

            public String toString() {
                return "SignerV4Impl.SignRequest.SignRequestBuilder(xDate=" + this.xDate + ", xNotSignBody=" + this.xNotSignBody + ", xCredential=" + this.xCredential + ", xAlgorithm=" + this.xAlgorithm + ", xSignedHeaders=" + this.xSignedHeaders + ", xSignedQueries=" + this.xSignedQueries + ", xSignature=" + this.xSignature + ", xSecurityToken=" + this.xSecurityToken + ", host=" + this.host + ", contentType=" + this.contentType + ", xContentSha256=" + this.xContentSha256 + ", authorization=" + this.authorization + ")";
            }
        }
    }

    public static class Credentials {
        private String accessKeyID;
        private String secretAccessKey;
        private String service;
        private String region;
        private String sessionToken;

        public String getAccessKeyID() {
            return this.accessKeyID;
        }

        public String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public String getService() {
            return this.service;
        }

        public String getRegion() {
            return this.region;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public void setAccessKeyID(String accessKeyID) {
            this.accessKeyID = accessKeyID;
        }

        public void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public void setService(String service) {
            this.service = service;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessKeyID = this.getAccessKeyID();
            String other$accessKeyID = other.getAccessKeyID();
            if (this$accessKeyID == null ? other$accessKeyID != null : !this$accessKeyID.equals(other$accessKeyID)) {
                return false;
            }
            String this$secretAccessKey = this.getSecretAccessKey();
            String other$secretAccessKey = other.getSecretAccessKey();
            if (this$secretAccessKey == null ? other$secretAccessKey != null : !this$secretAccessKey.equals(other$secretAccessKey)) {
                return false;
            }
            String this$service = this.getService();
            String other$service = other.getService();
            if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$sessionToken = this.getSessionToken();
            String other$sessionToken = other.getSessionToken();
            return !(this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessKeyID = this.getAccessKeyID();
            result = result * 59 + ($accessKeyID == null ? 43 : $accessKeyID.hashCode());
            String $secretAccessKey = this.getSecretAccessKey();
            result = result * 59 + ($secretAccessKey == null ? 43 : $secretAccessKey.hashCode());
            String $service = this.getService();
            result = result * 59 + ($service == null ? 43 : $service.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $sessionToken = this.getSessionToken();
            result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
            return result;
        }

        public String toString() {
            return "SignerV4Impl.Credentials(accessKeyID=" + this.getAccessKeyID() + ", secretAccessKey=" + this.getSecretAccessKey() + ", service=" + this.getService() + ", region=" + this.getRegion() + ", sessionToken=" + this.getSessionToken() + ")";
        }
    }

    public static class Const {
        public static final String Host = "Host";
        public static final String TIME_FORMAT_V4 = "yyyyMMdd'T'HHmmss'Z'";
        public static final String XDate = "X-Date";
        public static final String XNotSignBody = "X-NotSignBody";
        public static final String XCredential = "X-Credential";
        public static final String XAlgorithm = "X-Algorithm";
        public static final String XSignedHeaders = "X-SignedHeaders";
        public static final String XSignedQueries = "X-SignedQueries";
        public static final String XSignature = "X-Signature";
        public static final String ContentType = "Content-Type";
        public static final String ContentTypeValue = "application/x-www-form-urlencoded; charset=utf-8";
        public static final String XContentSha256 = "X-Content-Sha256";
        public static final String Authorization = "Authorization";
        public static final String XSecurityToken = "X-Cdp-Security-Token";
        public static final String ContentMd5 = "Content-Md5";
        public static final String ListRooms = "ListRooms";
        public static final String ListIndicators = "ListIndicators";
    }
}

