/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.ListCdpEventPropertyVo;
import code.byted.cdp.model.ListCdpEventVo;
import code.byted.cdp.model.ListCdpPropertyVo;
import code.byted.cdp.model.ListDataSourceListItemVo;
import code.byted.cdp.model.ListString;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DatasourceApi {
    private ApiClient apiClient;

    public DatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call queryDataSourceListCall(Long xTenant, String sourceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourceName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceName", sourceName));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryDataSourceList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryDataSourceListValidateBeforeCall(Long xTenant, String sourceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryDataSourceList(Async)");
        }
        Call call = this.queryDataSourceListCall(xTenant, sourceName, progressListener, progressRequestListener);
        return call;
    }

    public ListDataSourceListItemVo queryDataSourceList(Long xTenant, String sourceName) throws ApiException {
        ApiResponse<ListDataSourceListItemVo> resp = this.queryDataSourceListWithHttpInfo(xTenant, sourceName);
        return resp.getData();
    }

    public ApiResponse<ListDataSourceListItemVo> queryDataSourceListWithHttpInfo(Long xTenant, String sourceName) throws ApiException {
        Call call = this.queryDataSourceListValidateBeforeCall(xTenant, sourceName, null, null);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryDataSourceListAsync(Long xTenant, String sourceName, final ApiCallback<ListDataSourceListItemVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.queryDataSourceListValidateBeforeCall(xTenant, sourceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryeventListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryeventList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryeventListValidateBeforeCall(Integer dataSourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling queryeventList(Async)");
        }
        Call call = this.queryeventListCall(dataSourceId, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpEventVo queryeventList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpEventVo> resp = this.queryeventListWithHttpInfo(dataSourceId);
        return resp.getData();
    }

    public ApiResponse<ListCdpEventVo> queryeventListWithHttpInfo(Integer dataSourceId) throws ApiException {
        Call call = this.queryeventListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryeventListAsync(Integer dataSourceId, final ApiCallback<ListCdpEventVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.queryeventListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryeventPropertyListCall(Long xTenant, Integer eventId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (eventId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("eventId", eventId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryeventPropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryeventPropertyListValidateBeforeCall(Long xTenant, Integer eventId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryeventPropertyList(Async)");
        }
        if (eventId == null) {
            throw new ApiException("Missing the required parameter 'eventId' when calling queryeventPropertyList(Async)");
        }
        Call call = this.queryeventPropertyListCall(xTenant, eventId, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpEventPropertyVo queryeventPropertyList(Long xTenant, Integer eventId) throws ApiException {
        ApiResponse<ListCdpEventPropertyVo> resp = this.queryeventPropertyListWithHttpInfo(xTenant, eventId);
        return resp.getData();
    }

    public ApiResponse<ListCdpEventPropertyVo> queryeventPropertyListWithHttpInfo(Long xTenant, Integer eventId) throws ApiException {
        Call call = this.queryeventPropertyListValidateBeforeCall(xTenant, eventId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryeventPropertyListAsync(Long xTenant, Integer eventId, final ApiCallback<ListCdpEventPropertyVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.queryeventPropertyListValidateBeforeCall(xTenant, eventId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call querypropertyListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "querypropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call querypropertyListValidateBeforeCall(Integer dataSourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyList(Async)");
        }
        Call call = this.querypropertyListCall(dataSourceId, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpPropertyVo querypropertyList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpPropertyVo> resp = this.querypropertyListWithHttpInfo(dataSourceId);
        return resp.getData();
    }

    public ApiResponse<ListCdpPropertyVo> querypropertyListWithHttpInfo(Integer dataSourceId) throws ApiException {
        Call call = this.querypropertyListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call querypropertyListAsync(Integer dataSourceId, final ApiCallback<ListCdpPropertyVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.querypropertyListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call querypropertyValuesCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("id", id));
        }
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "querypropertyValues"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call querypropertyValuesValidateBeforeCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling querypropertyValues(Async)");
        }
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyValues(Async)");
        }
        Call call = this.querypropertyValuesCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        return call;
    }

    public ListString querypropertyValues(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        ApiResponse<ListString> resp = this.querypropertyValuesWithHttpInfo(id, dataSourceId, page, pageSize, keyword);
        return resp.getData();
    }

    public ApiResponse<ListString> querypropertyValuesWithHttpInfo(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        Call call = this.querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, null, null);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call querypropertyValuesAsync(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ApiCallback<ListString> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

