/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * SimplifiedSegCreateOrUpdateRequest
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2023-12-07T11:50:37.641+08:00[Asia/Shanghai]")
public class SimplifiedSegCreateOrUpdateRequest {
  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("targetIdTypeId")
  private Integer targetIdTypeId = null;

  @SerializedName("filter")
  private Object filter = null;

  /**
   * 更新方式，默认一次性
   */
  @JsonAdapter(ScheduleTypeEnum.Adapter.class)
  public enum ScheduleTypeEnum {
    UNKNOWN("Unknown"),
    ONCE("Once"),
    DAILY("Daily"),
    TRIGGER("Trigger"),
    REALTIME("Realtime");

    private String value;

    ScheduleTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ScheduleTypeEnum fromValue(String input) {
      for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ScheduleTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScheduleTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ScheduleTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ScheduleTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("scheduleType")
  private ScheduleTypeEnum scheduleType = null;

  @SerializedName("scheduleTime")
  private String scheduleTime = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  public SimplifiedSegCreateOrUpdateRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 分群名称
   * @return name
  **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SimplifiedSegCreateOrUpdateRequest desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 分群描述
   * @return desc
  **/
  @Schema(description = "分群描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public SimplifiedSegCreateOrUpdateRequest targetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
    return this;
  }

   /**
   * 导出实体id，公域写死0
   * @return targetIdTypeId
  **/
  @Schema(required = true, description = "导出实体id，公域写死0")
  public Integer getTargetIdTypeId() {
    return targetIdTypeId;
  }

  public void setTargetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
  }

  public SimplifiedSegCreateOrUpdateRequest filter(Object filter) {
    this.filter = filter;
    return this;
  }

   /**
   * 圈人条件
   * @return filter
  **/
  @Schema(required = true, description = "圈人条件")
  public Object getFilter() {
    return filter;
  }

  public void setFilter(Object filter) {
    this.filter = filter;
  }

  public SimplifiedSegCreateOrUpdateRequest scheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
    return this;
  }

   /**
   * 更新方式，默认一次性
   * @return scheduleType
  **/
  @Schema(description = "更新方式，默认一次性")
  public ScheduleTypeEnum getScheduleType() {
    return scheduleType;
  }

  public void setScheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
  }

  public SimplifiedSegCreateOrUpdateRequest scheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
    return this;
  }

   /**
   * 任务执行时间，00:00格式
   * @return scheduleTime
  **/
  @Schema(description = "任务执行时间，00:00格式")
  public String getScheduleTime() {
    return scheduleTime;
  }

  public void setScheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
  }

  public SimplifiedSegCreateOrUpdateRequest sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

   /**
   * 来源平台
   * @return sourcePlatform
  **/
  @Schema(description = "来源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimplifiedSegCreateOrUpdateRequest simplifiedSegCreateOrUpdateRequest = (SimplifiedSegCreateOrUpdateRequest) o;
    return Objects.equals(this.name, simplifiedSegCreateOrUpdateRequest.name) &&
        Objects.equals(this.desc, simplifiedSegCreateOrUpdateRequest.desc) &&
        Objects.equals(this.targetIdTypeId, simplifiedSegCreateOrUpdateRequest.targetIdTypeId) &&
        Objects.equals(this.filter, simplifiedSegCreateOrUpdateRequest.filter) &&
        Objects.equals(this.scheduleType, simplifiedSegCreateOrUpdateRequest.scheduleType) &&
        Objects.equals(this.scheduleTime, simplifiedSegCreateOrUpdateRequest.scheduleTime) &&
        Objects.equals(this.sourcePlatform, simplifiedSegCreateOrUpdateRequest.sourcePlatform);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, desc, targetIdTypeId, filter, scheduleType, scheduleTime, sourcePlatform);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimplifiedSegCreateOrUpdateRequest {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    targetIdTypeId: ").append(toIndentedString(targetIdTypeId)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    scheduleType: ").append(toIndentedString(scheduleType)).append("\n");
    sb.append("    scheduleTime: ").append(toIndentedString(scheduleTime)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
