/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.DetailAttributesReq;
import code.byted.cdp.model.DetailAttributesResp;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetailDatasourceApi {
    private ApiClient apiClient;

    public DetailDatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DetailDatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getDetailAttributes
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDetailAttributesCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
        if (current != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("current", current));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("attributeId", attributeId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getDetailAttributes"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDetailAttributesValidateBeforeCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getDetailAttributes(Async)");
        }
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getDetailAttributes(Async)");
        }
        // verify the required parameter 'attributeId' is set
        if (attributeId == null) {
            throw new ApiException("Missing the required parameter 'attributeId' when calling getDetailAttributes(Async)");
        }

        com.squareup.okhttp.Call call = getDetailAttributesCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取明细数据源的枚举值
     * 
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @return DetailAttributesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DetailAttributesResp getDetailAttributes(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        ApiResponse<DetailAttributesResp> resp = getDetailAttributesWithHttpInfo(body, tenantCode, attributeId, keyword, current, pageSize);
        return resp.getData();
    }

    /**
     * 获取明细数据源的枚举值
     * 
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @return ApiResponse&lt;DetailAttributesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DetailAttributesResp> getDetailAttributesWithHttpInfo(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        com.squareup.okhttp.Call call = getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, null, null);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取明细数据源的枚举值 (asynchronously)
     * 
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDetailAttributesAsync(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ApiCallback<DetailAttributesResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
