/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.JSON;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.SignerV4Impl;
import code.byted.cdp.StringUtil;
import code.byted.cdp.auth.ApiKeyAuth;
import code.byted.cdp.auth.Authentication;
import code.byted.cdp.auth.HttpBasicAuth;
import code.byted.cdp.auth.OAuth;
import code.byted.cdp.model.ResponseSts;
import code.byted.cdp.model.Sts;
import code.byted.cdp.openapi.CdpApi;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public class ApiClient {
    private String basePath = "/";
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private DateFormat dateFormat;
    private DateFormat datetimeFormat;
    private boolean lenientDatetimeFormat;
    private int dateLength;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private OkHttpClient httpClient;
    private JSON json;
    private HttpLoggingInterceptor loggingInterceptor;
    private SignerV4Impl sign = new SignerV4Impl();
    private SignerV4Impl.Credentials credentials = new SignerV4Impl.Credentials();
    private String appAK;
    private String appSK;
    private String account;
    private Sts stsToken;
    private Integer retryTime = 3;
    private Interceptor interceptor = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Response response = null;
            boolean responseOK = false;
            int tryCount = 0;
            int maxLimit = ApiClient.this.retryTime;
            while (!responseOK && tryCount < maxLimit) {
                try {
                    response = chain.proceed(request);
                    responseOK = response.isSuccessful();
                    if (responseOK) continue;
                    return response;
                }
                catch (Exception e) {
                    System.out.println("Retrying after " + ++tryCount + " attempts");
                    if (tryCount < maxLimit) continue;
                    throw e;
                }
            }
            return response;
        }
    };

    @Deprecated
    public ApiClient(String accessKeyID, String secretAccessKey, String basePath) {
        this.httpClient = new OkHttpClient();
        this.httpClient.interceptors().add(this.interceptor);
        this.appAK = accessKeyID;
        this.appSK = secretAccessKey;
        this.credentials.setAccessKeyID(accessKeyID);
        this.credentials.setSecretAccessKey(secretAccessKey);
        this.credentials.setService("openPlatform");
        this.credentials.setRegion("cn");
        this.setBasePath(basePath);
        this.setReadTimeout(60000);
        this.setConnectTimeout(60000);
        this.verifyingSsl = true;
        this.json = new JSON();
        this.setUserAgent("Swagger-Codegen/1.23.13-SNAPSHOT/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public ApiClient(String appAK, String appSK, String account, String basePath) {
        if (StringUtils.isEmpty((CharSequence)account)) {
            throw new RuntimeException("\u57fa\u4e8e STS \u7684\u8bbf\u95ee\u65b9\u5f0f\u9700\u8981\u4f20\u5165\u7528\u6237\u540d");
        }
        this.httpClient = new OkHttpClient();
        this.appAK = appAK;
        this.appSK = appSK;
        this.account = account;
        this.credentials.setService("openPlatform");
        this.credentials.setRegion("cn");
        this.setBasePath(basePath);
        this.setReadTimeout(60000);
        this.setConnectTimeout(60000);
        this.verifyingSsl = true;
        this.json = new JSON();
        this.setUserAgent("Swagger-Codegen/1.23.13-SNAPSHOT/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.refreshSTSToken();
    }

    public Sts getStsToken(boolean forceRefresh) {
        if (StringUtils.isEmpty((CharSequence)this.account)) {
            throw new RuntimeException("\u83b7\u53d6 STS \u4e34\u65f6\u51ed\u8bc1\u9700\u8981\u4f7f\u7528\u57fa\u4e8e STS \u7684\u8bbf\u95ee\u65b9\u5f0f");
        }
        if (forceRefresh || !this.isTokenValid()) {
            this.refreshSTSToken();
        }
        return this.stsToken;
    }

    private synchronized void updateCredentials() {
        this.credentials.setAccessKeyID(this.stsToken.getAccessKey());
        this.credentials.setSecretAccessKey(this.stsToken.getSecretKey());
        this.credentials.setSessionToken(this.stsToken.getSessionToken());
    }

    private boolean isTokenValid() {
        return this.stsToken != null && !this.stsToken.getExpiredTime().isBefore(OffsetDateTime.now().plusSeconds(20L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isTokenValidOrRefresh() {
        if (!this.isTokenValid()) {
            ApiClient apiClient = this;
            synchronized (apiClient) {
                if (!this.isTokenValid()) {
                    this.refreshSTSToken();
                }
            }
        }
    }

    private void refreshSTSToken() {
        if (StringUtils.isEmpty((CharSequence)this.account)) {
            throw new RuntimeException("\u5237\u65b0\u4e34\u65f6\u51ed\u8bc1\u8bf7\u4f7f\u7528\u57fa\u4e8e STS \u7684\u8bbf\u95ee\u65b9\u5f0f");
        }
        ApiClient apiClient = new ApiClient(this.appAK, this.appSK, this.basePath);
        CdpApi api = new CdpApi(apiClient);
        try {
            ResponseSts resp = api.getUserToken(this.account, 43200);
            if (!resp.getCode().equals(0L)) {
                throw new Exception(Optional.ofNullable(resp.getMessage()).orElse(resp.getMsg()));
            }
            this.stsToken = resp.getData();
            this.updateCredentials();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5237\u65b0 STS Token \u5931\u8d25: " + e.getMessage());
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] managers) {
        this.keyManagers = managers;
        this.applySslSettings();
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.json.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setLenientOnJson(boolean lenientOnJson) {
        this.json.setLenientOnJson(lenientOnJson);
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient.interceptors().add(this.loggingInterceptor);
            } else {
                this.httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.getReadTimeout();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient.setReadTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public ApiClient setRetryCount(int retryCount) {
        this.retryTime = retryCount;
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.getWriteTimeout();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient.setWriteTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = this.json.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public String sanitizeFilename(String filename) {
        String name = filename.replaceAll(".*[/\\\\]", "").replaceAll("[^a-zA-Z0-9.-]", "_");
        return name.substring(0, Math.min(name.length(), 30));
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            return this.json.deserialize(respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])((byte[])obj));
        }
        if (obj instanceof File) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)((File)obj));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? this.json.serialize(obj) : null;
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(Paths.get(this.tempFolderPath, new String[0]), prefix, suffix, new FileAttribute[0]).toFile();
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType, String[] accept) throws ApiException {
        try {
            Response response = call.execute();
            T data = this.handleResponse(response, returnType, accept);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> void executeAsync(Call call, ApiCallback<T> callback) {
        this.executeAsync(call, null, null, callback);
    }

    public <T> void executeAsync(Call call, final Type returnType, final String[] accept, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType, accept);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(Response response, Type returnType, String[] accept) throws ApiException {
        if (response.isSuccessful()) {
            if (returnType == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (IOException e) {
                        throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                    }
                }
                return null;
            }
            if (accept != null && accept.length > 0) {
                boolean typeOk = false;
                block6: for (String type : response.headers().values("Content-Type")) {
                    for (String a : accept) {
                        if (!a.equals(type)) continue;
                        typeOk = true;
                        break block6;
                    }
                }
                if (!typeOk && StringUtils.equalsIgnoreCase((CharSequence)"chunked", (CharSequence)response.header("Transfer-Encoding"))) {
                    typeOk = true;
                }
                if (!typeOk) {
                    String respBody = null;
                    if (response.body() != null) {
                        try {
                            respBody = response.body().string();
                        }
                        catch (IOException e) {
                            throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                        }
                    }
                    throw new ApiException("Content-Type not accept, " + response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
                }
            }
            return this.deserialize(response, returnType);
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public Call buildCall(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Request request = this.buildRequest(path, method, queryParams, collectionQueryParams, body, headerParams, formParams, authNames, progressRequestListener);
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SignerV4Impl.Credentials credentials = this.credentials;
        if (queryParams.stream().anyMatch(it -> StringUtils.equals((CharSequence)it.getName(), (CharSequence)"ApiAction") && StringUtils.equalsIgnoreCase((CharSequence)it.getValue(), (CharSequence)"getUserToken"))) {
            credentials = SignerV4Impl.Credentials.builder().accessKeyID(this.appAK).secretAccessKey(this.appSK).service(this.credentials.getService()).region(this.credentials.getRegion()).build();
        } else if (this.account != null) {
            this.isTokenValidOrRefresh();
        }
        this.addDefaultHeader("X-Trace-Id", "OPENAPI-SDK-JAVA-1.23.13-SNAPSHOT-" + LocalDateTime.now());
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        String url = this.buildUrl(path, queryParams, collectionQueryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder);
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        Object reqBody = !HttpMethod.permitsRequestBody((String)method) ? null : ("application/x-www-form-urlencoded".equals(contentType) ? this.buildRequestBodyFormEncoding(formParams) : ("multipart/form-data".equals(contentType) ? this.buildRequestBodyMultipart(formParams) : (body == null ? ("DELETE".equals(method) ? null : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)"")) : this.serialize(body, contentType))));
        ArrayList<Pair> queryList = new ArrayList<Pair>();
        final ArrayList<Pair> headers = new ArrayList<Pair>();
        queryList.addAll(queryParams);
        queryList.addAll(collectionQueryParams);
        headerParams.forEach(new BiConsumer<String, String>(){

            @Override
            public void accept(String n, String v) {
                headers.add(new Pair(n, v));
            }
        });
        try {
            URI uri = new URI(url);
            this.sign.sign(reqBuilder, credentials, (RequestBody)reqBody, uri.getHost(), uri.getPort(), uri.getPath(), method, (List<Pair>)queryList, (List<Pair>)headers);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        String value;
        String prefix;
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBuilder mpBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (File)file));
                continue;
            }
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
            mpBuilder.addPart(partHeaders, RequestBody.create(null, (String)this.parameterToString(param.getValue())));
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    private void applySslSettings() {
        try {
            TrustManager[] trustManagers = null;
            HostnameVerifier hostnameVerifier = null;
            if (!this.verifyingSsl) {
                X509TrustManager trustAll = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                SSLContext sslContext = SSLContext.getInstance("TLS");
                trustManagers = new TrustManager[]{trustAll};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else if (this.sslCaCert != null) {
                char[] password = null;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                if (certificates.isEmpty()) {
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore caKeyStore = this.newEmptyKeyStore(password);
                int index = 0;
                for (Certificate certificate : certificates) {
                    String certificateAlias = "ca" + Integer.toString(index++);
                    caKeyStore.setCertificateEntry(certificateAlias, certificate);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(caKeyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            if (this.keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(this.keyManagers, trustManagers, new SecureRandom());
                this.httpClient.setSslSocketFactory(sslContext.getSocketFactory());
            } else {
                this.httpClient.setSslSocketFactory(null);
            }
            this.httpClient.setHostnameVerifier(hostnameVerifier);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

