/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.AnalysisAttributionObj;
import code.byted.cdp.model.AttributionObj;
import code.byted.cdp.model.BasePeriod;
import code.byted.cdp.model.EventAttributionObjCondition;
import code.byted.cdp.model.JsonNode;
import code.byted.cdp.model.PathObj;
import code.byted.cdp.model.RangeValueObj;
import code.byted.cdp.model.SegRuleObj;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * 分析对象
 */
@Schema(description = "分析对象")
@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class AnalysisAttributionObj {
  @SerializedName("index")
  private Integer index = null;

  @SerializedName("name")
  private String name = null;

  /**
   * 维度信息类型
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    TAG("TAG"),
    EVENT("EVENT"),
    DETAIL("DETAIL"),
    SEG("SEG"),
    SEG_RULE("SEG_RULE"),
    DATE("DATE"),
    PROPERTY("PROPERTY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("tagId")
  private Integer tagId = null;

  @SerializedName("attrId")
  private Integer attrId = null;

  @SerializedName("eventDatasourceId")
  private Integer eventDatasourceId = null;

  @SerializedName("eventId")
  private Integer eventId = null;

  @SerializedName("eventName")
  private String eventName = null;

  @SerializedName("eventType")
  private Integer eventType = null;

  @SerializedName("eventAttributeName")
  private String eventAttributeName = null;

  @SerializedName("dimDataSourceId")
  private Integer dimDataSourceId = null;

  @SerializedName("dimColumnName")
  private String dimColumnName = null;

  @SerializedName("eventAttributeId")
  private Integer eventAttributeId = null;

  @SerializedName("attributeValueMapping")
  private Map<String, String> attributeValueMapping = null;

  @SerializedName("attr")
  private AttributionObj attr = null;

  @SerializedName("dataSourceId")
  private Integer dataSourceId = null;

  @SerializedName("columnId")
  private Integer columnId = null;

  @SerializedName("columnName")
  private String columnName = null;

  @SerializedName("propertyType")
  private Integer propertyType = null;

  @SerializedName("limit")
  private Integer limit = null;

  @SerializedName("values")
  private List<String> values = null;

  @SerializedName("rangeValues")
  private List<RangeValueObj> rangeValues = null;

  @SerializedName("include")
  private JsonNode include = null;

  @SerializedName("exclude")
  private JsonNode exclude = null;

  @SerializedName("windowPeriod")
  private BasePeriod windowPeriod = null;

  @SerializedName("analysisAttributionObjs")
  private List<AnalysisAttributionObj> analysisAttributionObjs = null;

  @SerializedName("startObj")
  private PathObj startObj = null;

  @SerializedName("endObj")
  private PathObj endObj = null;

  @SerializedName("condition")
  private EventAttributionObjCondition condition = null;

  @SerializedName("filterCondition")
  private JsonNode filterCondition = null;

  @SerializedName("distinct")
  private Boolean distinct = null;

  @SerializedName("nodes")
  private List<AnalysisAttributionObj> nodes = null;

  @SerializedName("breakUp")
  private Boolean breakUp = null;

  /**
   * 计算方式
   */
  @JsonAdapter(MethodEnum.Adapter.class)
  public enum MethodEnum {
    UNKNOWN("Unknown"),
    SUM("SUM"),
    AVG("AVG"),
    MAX("MAX"),
    MIN("MIN"),
    COUNT("COUNT"),
    DISTINCT_COUNT("DISTINCT_COUNT"),
    COUNT_WITH_ATTR("COUNT_WITH_ATTR"),
    DISTINCT_COUNT_WITH_ATTR("DISTINCT_COUNT_WITH_ATTR"),
    ATTRIBUTION("ATTRIBUTION"),
    TRANS("TRANS"),
    FUNCTION("FUNCTION"),
    SINGLE("SINGLE"),
    ID("ID"),
    MULTI_METRICS("MULTI_METRICS"),
    USER_TENDENCY("USER_TENDENCY");

    private String value;

    MethodEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static MethodEnum fromValue(String input) {
      for (MethodEnum b : MethodEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<MethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final MethodEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public MethodEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return MethodEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("method")
  private MethodEnum method = null;

  @SerializedName("segIds")
  private List<Integer> segIds = null;

  @SerializedName("segRules")
  private List<SegRuleObj> segRules = null;

  /**
   * 日期维度聚合类型
   */
  @JsonAdapter(DateGroupRangeEnum.Adapter.class)
  public enum DateGroupRangeEnum {
    UNKNOWN("Unknown"),
    YEAR("YEAR"),
    MONTH("MONTH"),
    WEEK("WEEK"),
    DAY("DAY"),
    HOUR("HOUR"),
    MINUTE("MINUTE");

    private String value;

    DateGroupRangeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static DateGroupRangeEnum fromValue(String input) {
      for (DateGroupRangeEnum b : DateGroupRangeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<DateGroupRangeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DateGroupRangeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public DateGroupRangeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return DateGroupRangeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("dateGroupRange")
  private DateGroupRangeEnum dateGroupRange = null;

  @SerializedName("dateSplitIndex")
  private Integer dateSplitIndex = null;

  @SerializedName("dateBasePeriods")
  private List<BasePeriod> dateBasePeriods = null;

  @SerializedName("objDataPeriod")
  private BasePeriod objDataPeriod = null;

  public AnalysisAttributionObj index(Integer index) {
    this.index = index;
    return this;
  }

   /**
   * id
   * @return index
  **/
  @Schema(description = "id")
  public Integer getIndex() {
    return index;
  }

  public void setIndex(Integer index) {
    this.index = index;
  }

  public AnalysisAttributionObj name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 维度统一名称，用于行为圈选时展示
   * @return name
  **/
  @Schema(description = "维度统一名称，用于行为圈选时展示")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AnalysisAttributionObj type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * 维度信息类型
   * @return type
  **/
  @Schema(description = "维度信息类型")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public AnalysisAttributionObj tagId(Integer tagId) {
    this.tagId = tagId;
    return this;
  }

   /**
   * 标签id,只有type为TAG时有效
   * @return tagId
  **/
  @Schema(description = "标签id,只有type为TAG时有效")
  public Integer getTagId() {
    return tagId;
  }

  public void setTagId(Integer tagId) {
    this.tagId = tagId;
  }

  public AnalysisAttributionObj attrId(Integer attrId) {
    this.attrId = attrId;
    return this;
  }

   /**
   * 预定义维度id，只有type为ATTR时有效
   * @return attrId
  **/
  @Schema(description = "预定义维度id，只有type为ATTR时有效")
  public Integer getAttrId() {
    return attrId;
  }

  public void setAttrId(Integer attrId) {
    this.attrId = attrId;
  }

  public AnalysisAttributionObj eventDatasourceId(Integer eventDatasourceId) {
    this.eventDatasourceId = eventDatasourceId;
    return this;
  }

   /**
   * 行为表id，只有type为EVENT时有效
   * @return eventDatasourceId
  **/
  @Schema(description = "行为表id，只有type为EVENT时有效")
  public Integer getEventDatasourceId() {
    return eventDatasourceId;
  }

  public void setEventDatasourceId(Integer eventDatasourceId) {
    this.eventDatasourceId = eventDatasourceId;
  }

  public AnalysisAttributionObj eventId(Integer eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * 行为id，只有type为EVENT时有效
   * @return eventId
  **/
  @Schema(description = "行为id，只有type为EVENT时有效")
  public Integer getEventId() {
    return eventId;
  }

  public void setEventId(Integer eventId) {
    this.eventId = eventId;
  }

  public AnalysisAttributionObj eventName(String eventName) {
    this.eventName = eventName;
    return this;
  }

   /**
   * 行为查询值，只有type为EVENT时有效
   * @return eventName
  **/
  @Schema(description = "行为查询值，只有type为EVENT时有效")
  public String getEventName() {
    return eventName;
  }

  public void setEventName(String eventName) {
    this.eventName = eventName;
  }

  public AnalysisAttributionObj eventType(Integer eventType) {
    this.eventType = eventType;
    return this;
  }

   /**
   * 行为事件类型，0：普通事件；1:虚拟事件，可选，默认0
   * @return eventType
  **/
  @Schema(description = "行为事件类型，0：普通事件；1:虚拟事件，可选，默认0")
  public Integer getEventType() {
    return eventType;
  }

  public void setEventType(Integer eventType) {
    this.eventType = eventType;
  }

  public AnalysisAttributionObj eventAttributeName(String eventAttributeName) {
    this.eventAttributeName = eventAttributeName;
    return this;
  }

   /**
   * 行为属性名称，只有type为EVENT时有效
   * @return eventAttributeName
  **/
  @Schema(description = "行为属性名称，只有type为EVENT时有效")
  public String getEventAttributeName() {
    return eventAttributeName;
  }

  public void setEventAttributeName(String eventAttributeName) {
    this.eventAttributeName = eventAttributeName;
  }

  public AnalysisAttributionObj dimDataSourceId(Integer dimDataSourceId) {
    this.dimDataSourceId = dimDataSourceId;
    return this;
  }

   /**
   * 维度属性数据源id
   * @return dimDataSourceId
  **/
  @Schema(description = "维度属性数据源id")
  public Integer getDimDataSourceId() {
    return dimDataSourceId;
  }

  public void setDimDataSourceId(Integer dimDataSourceId) {
    this.dimDataSourceId = dimDataSourceId;
  }

  public AnalysisAttributionObj dimColumnName(String dimColumnName) {
    this.dimColumnName = dimColumnName;
    return this;
  }

   /**
   * 维度属性名称
   * @return dimColumnName
  **/
  @Schema(description = "维度属性名称")
  public String getDimColumnName() {
    return dimColumnName;
  }

  public void setDimColumnName(String dimColumnName) {
    this.dimColumnName = dimColumnName;
  }

  public AnalysisAttributionObj eventAttributeId(Integer eventAttributeId) {
    this.eventAttributeId = eventAttributeId;
    return this;
  }

   /**
   * 行为属性id，只有type为EVENT时有效
   * @return eventAttributeId
  **/
  @Schema(description = "行为属性id，只有type为EVENT时有效")
  public Integer getEventAttributeId() {
    return eventAttributeId;
  }

  public void setEventAttributeId(Integer eventAttributeId) {
    this.eventAttributeId = eventAttributeId;
  }

  public AnalysisAttributionObj attributeValueMapping(Map<String, String> attributeValueMapping) {
    this.attributeValueMapping = attributeValueMapping;
    return this;
  }

  public AnalysisAttributionObj putAttributeValueMappingItem(String key, String attributeValueMappingItem) {
    if (this.attributeValueMapping == null) {
      this.attributeValueMapping = new HashMap<String, String>();
    }
    this.attributeValueMapping.put(key, attributeValueMappingItem);
    return this;
  }

   /**
   * 属性值 Mapping
   * @return attributeValueMapping
  **/
  @Schema(description = "属性值 Mapping")
  public Map<String, String> getAttributeValueMapping() {
    return attributeValueMapping;
  }

  public void setAttributeValueMapping(Map<String, String> attributeValueMapping) {
    this.attributeValueMapping = attributeValueMapping;
  }

  public AnalysisAttributionObj attr(AttributionObj attr) {
    this.attr = attr;
    return this;
  }

   /**
   * Get attr
   * @return attr
  **/
  @Schema(description = "")
  public AttributionObj getAttr() {
    return attr;
  }

  public void setAttr(AttributionObj attr) {
    this.attr = attr;
  }

  public AnalysisAttributionObj dataSourceId(Integer dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

   /**
   * 数据源id，只有type为DETAIL时有效
   * @return dataSourceId
  **/
  @Schema(description = "数据源id，只有type为DETAIL时有效")
  public Integer getDataSourceId() {
    return dataSourceId;
  }

  public void setDataSourceId(Integer dataSourceId) {
    this.dataSourceId = dataSourceId;
  }

  public AnalysisAttributionObj columnId(Integer columnId) {
    this.columnId = columnId;
    return this;
  }

   /**
   * 字段列id，只有type为DETAIL时有效
   * @return columnId
  **/
  @Schema(description = "字段列id，只有type为DETAIL时有效")
  public Integer getColumnId() {
    return columnId;
  }

  public void setColumnId(Integer columnId) {
    this.columnId = columnId;
  }

  public AnalysisAttributionObj columnName(String columnName) {
    this.columnName = columnName;
    return this;
  }

   /**
   * 字段列id，只有type为DETAIL时有效
   * @return columnName
  **/
  @Schema(description = "字段列id，只有type为DETAIL时有效")
  public String getColumnName() {
    return columnName;
  }

  public void setColumnName(String columnName) {
    this.columnName = columnName;
  }

  public AnalysisAttributionObj propertyType(Integer propertyType) {
    this.propertyType = propertyType;
    return this;
  }

   /**
   * 属性类型，显示声明3是虚拟属性，其他都是普通属性，值为1
   * @return propertyType
  **/
  @Schema(description = "属性类型，显示声明3是虚拟属性，其他都是普通属性，值为1")
  public Integer getPropertyType() {
    return propertyType;
  }

  public void setPropertyType(Integer propertyType) {
    this.propertyType = propertyType;
  }

  public AnalysisAttributionObj limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * 维度数量限制，按照维度数量进行降序
   * @return limit
  **/
  @Schema(description = "维度数量限制，按照维度数量进行降序")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public AnalysisAttributionObj values(List<String> values) {
    this.values = values;
    return this;
  }

  public AnalysisAttributionObj addValuesItem(String valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<String>();
    }
    this.values.add(valuesItem);
    return this;
  }

   /**
   * 用户指定维度
   * @return values
  **/
  @Schema(description = "用户指定维度")
  public List<String> getValues() {
    return values;
  }

  public void setValues(List<String> values) {
    this.values = values;
  }

  public AnalysisAttributionObj rangeValues(List<RangeValueObj> rangeValues) {
    this.rangeValues = rangeValues;
    return this;
  }

  public AnalysisAttributionObj addRangeValuesItem(RangeValueObj rangeValuesItem) {
    if (this.rangeValues == null) {
      this.rangeValues = new ArrayList<RangeValueObj>();
    }
    this.rangeValues.add(rangeValuesItem);
    return this;
  }

   /**
   * 区间维度，如果传入区间维度，则优先识别
   * @return rangeValues
  **/
  @Schema(description = "区间维度，如果传入区间维度，则优先识别")
  public List<RangeValueObj> getRangeValues() {
    return rangeValues;
  }

  public void setRangeValues(List<RangeValueObj> rangeValues) {
    this.rangeValues = rangeValues;
  }

  public AnalysisAttributionObj include(JsonNode include) {
    this.include = include;
    return this;
  }

   /**
   * Get include
   * @return include
  **/
  @Schema(description = "")
  public JsonNode getInclude() {
    return include;
  }

  public void setInclude(JsonNode include) {
    this.include = include;
  }

  public AnalysisAttributionObj exclude(JsonNode exclude) {
    this.exclude = exclude;
    return this;
  }

   /**
   * Get exclude
   * @return exclude
  **/
  @Schema(description = "")
  public JsonNode getExclude() {
    return exclude;
  }

  public void setExclude(JsonNode exclude) {
    this.exclude = exclude;
  }

  public AnalysisAttributionObj windowPeriod(BasePeriod windowPeriod) {
    this.windowPeriod = windowPeriod;
    return this;
  }

   /**
   * Get windowPeriod
   * @return windowPeriod
  **/
  @Schema(description = "")
  public BasePeriod getWindowPeriod() {
    return windowPeriod;
  }

  public void setWindowPeriod(BasePeriod windowPeriod) {
    this.windowPeriod = windowPeriod;
  }

  public AnalysisAttributionObj analysisAttributionObjs(List<AnalysisAttributionObj> analysisAttributionObjs) {
    this.analysisAttributionObjs = analysisAttributionObjs;
    return this;
  }

  public AnalysisAttributionObj addAnalysisAttributionObjsItem(AnalysisAttributionObj analysisAttributionObjsItem) {
    if (this.analysisAttributionObjs == null) {
      this.analysisAttributionObjs = new ArrayList<AnalysisAttributionObj>();
    }
    this.analysisAttributionObjs.add(analysisAttributionObjsItem);
    return this;
  }

   /**
   * 子节点信息
   * @return analysisAttributionObjs
  **/
  @Schema(description = "子节点信息")
  public List<AnalysisAttributionObj> getAnalysisAttributionObjs() {
    return analysisAttributionObjs;
  }

  public void setAnalysisAttributionObjs(List<AnalysisAttributionObj> analysisAttributionObjs) {
    this.analysisAttributionObjs = analysisAttributionObjs;
  }

  public AnalysisAttributionObj startObj(PathObj startObj) {
    this.startObj = startObj;
    return this;
  }

   /**
   * Get startObj
   * @return startObj
  **/
  @Schema(description = "")
  public PathObj getStartObj() {
    return startObj;
  }

  public void setStartObj(PathObj startObj) {
    this.startObj = startObj;
  }

  public AnalysisAttributionObj endObj(PathObj endObj) {
    this.endObj = endObj;
    return this;
  }

   /**
   * Get endObj
   * @return endObj
  **/
  @Schema(description = "")
  public PathObj getEndObj() {
    return endObj;
  }

  public void setEndObj(PathObj endObj) {
    this.endObj = endObj;
  }

  public AnalysisAttributionObj condition(EventAttributionObjCondition condition) {
    this.condition = condition;
    return this;
  }

   /**
   * Get condition
   * @return condition
  **/
  @Schema(description = "")
  public EventAttributionObjCondition getCondition() {
    return condition;
  }

  public void setCondition(EventAttributionObjCondition condition) {
    this.condition = condition;
  }

  public AnalysisAttributionObj filterCondition(JsonNode filterCondition) {
    this.filterCondition = filterCondition;
    return this;
  }

   /**
   * Get filterCondition
   * @return filterCondition
  **/
  @Schema(description = "")
  public JsonNode getFilterCondition() {
    return filterCondition;
  }

  public void setFilterCondition(JsonNode filterCondition) {
    this.filterCondition = filterCondition;
  }

  public AnalysisAttributionObj distinct(Boolean distinct) {
    this.distinct = distinct;
    return this;
  }

   /**
   * 是否去重
   * @return distinct
  **/
  @Schema(description = "是否去重")
  public Boolean isDistinct() {
    return distinct;
  }

  public void setDistinct(Boolean distinct) {
    this.distinct = distinct;
  }

  public AnalysisAttributionObj nodes(List<AnalysisAttributionObj> nodes) {
    this.nodes = nodes;
    return this;
  }

  public AnalysisAttributionObj addNodesItem(AnalysisAttributionObj nodesItem) {
    if (this.nodes == null) {
      this.nodes = new ArrayList<AnalysisAttributionObj>();
    }
    this.nodes.add(nodesItem);
    return this;
  }

   /**
   * 子节点
   * @return nodes
  **/
  @Schema(description = "子节点")
  public List<AnalysisAttributionObj> getNodes() {
    return nodes;
  }

  public void setNodes(List<AnalysisAttributionObj> nodes) {
    this.nodes = nodes;
  }

  public AnalysisAttributionObj breakUp(Boolean breakUp) {
    this.breakUp = breakUp;
    return this;
  }

   /**
   * 是否打散，只用于行为
   * @return breakUp
  **/
  @Schema(description = "是否打散，只用于行为")
  public Boolean isBreakUp() {
    return breakUp;
  }

  public void setBreakUp(Boolean breakUp) {
    this.breakUp = breakUp;
  }

  public AnalysisAttributionObj method(MethodEnum method) {
    this.method = method;
    return this;
  }

   /**
   * 计算方式
   * @return method
  **/
  @Schema(description = "计算方式")
  public MethodEnum getMethod() {
    return method;
  }

  public void setMethod(MethodEnum method) {
    this.method = method;
  }

  public AnalysisAttributionObj segIds(List<Integer> segIds) {
    this.segIds = segIds;
    return this;
  }

  public AnalysisAttributionObj addSegIdsItem(Integer segIdsItem) {
    if (this.segIds == null) {
      this.segIds = new ArrayList<Integer>();
    }
    this.segIds.add(segIdsItem);
    return this;
  }

   /**
   * 人群id，只有type为SEG时有效
   * @return segIds
  **/
  @Schema(description = "人群id，只有type为SEG时有效")
  public List<Integer> getSegIds() {
    return segIds;
  }

  public void setSegIds(List<Integer> segIds) {
    this.segIds = segIds;
  }

  public AnalysisAttributionObj segRules(List<SegRuleObj> segRules) {
    this.segRules = segRules;
    return this;
  }

  public AnalysisAttributionObj addSegRulesItem(SegRuleObj segRulesItem) {
    if (this.segRules == null) {
      this.segRules = new ArrayList<SegRuleObj>();
    }
    this.segRules.add(segRulesItem);
    return this;
  }

   /**
   * 人群规则，只有type为SEG_RULE时有效
   * @return segRules
  **/
  @Schema(description = "人群规则，只有type为SEG_RULE时有效")
  public List<SegRuleObj> getSegRules() {
    return segRules;
  }

  public void setSegRules(List<SegRuleObj> segRules) {
    this.segRules = segRules;
  }

  public AnalysisAttributionObj dateGroupRange(DateGroupRangeEnum dateGroupRange) {
    this.dateGroupRange = dateGroupRange;
    return this;
  }

   /**
   * 日期维度聚合类型
   * @return dateGroupRange
  **/
  @Schema(description = "日期维度聚合类型")
  public DateGroupRangeEnum getDateGroupRange() {
    return dateGroupRange;
  }

  public void setDateGroupRange(DateGroupRangeEnum dateGroupRange) {
    this.dateGroupRange = dateGroupRange;
  }

  public AnalysisAttributionObj dateSplitIndex(Integer dateSplitIndex) {
    this.dateSplitIndex = dateSplitIndex;
    return this;
  }

   /**
   * 日期维度切片位置
   * @return dateSplitIndex
  **/
  @Schema(description = "日期维度切片位置")
  public Integer getDateSplitIndex() {
    return dateSplitIndex;
  }

  public void setDateSplitIndex(Integer dateSplitIndex) {
    this.dateSplitIndex = dateSplitIndex;
  }

  public AnalysisAttributionObj dateBasePeriods(List<BasePeriod> dateBasePeriods) {
    this.dateBasePeriods = dateBasePeriods;
    return this;
  }

  public AnalysisAttributionObj addDateBasePeriodsItem(BasePeriod dateBasePeriodsItem) {
    if (this.dateBasePeriods == null) {
      this.dateBasePeriods = new ArrayList<BasePeriod>();
    }
    this.dateBasePeriods.add(dateBasePeriodsItem);
    return this;
  }

   /**
   * 自定义日期维度
   * @return dateBasePeriods
  **/
  @Schema(description = "自定义日期维度")
  public List<BasePeriod> getDateBasePeriods() {
    return dateBasePeriods;
  }

  public void setDateBasePeriods(List<BasePeriod> dateBasePeriods) {
    this.dateBasePeriods = dateBasePeriods;
  }

  public AnalysisAttributionObj objDataPeriod(BasePeriod objDataPeriod) {
    this.objDataPeriod = objDataPeriod;
    return this;
  }

   /**
   * Get objDataPeriod
   * @return objDataPeriod
  **/
  @Schema(description = "")
  public BasePeriod getObjDataPeriod() {
    return objDataPeriod;
  }

  public void setObjDataPeriod(BasePeriod objDataPeriod) {
    this.objDataPeriod = objDataPeriod;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnalysisAttributionObj analysisAttributionObj = (AnalysisAttributionObj) o;
    return Objects.equals(this.index, analysisAttributionObj.index) &&
        Objects.equals(this.name, analysisAttributionObj.name) &&
        Objects.equals(this.type, analysisAttributionObj.type) &&
        Objects.equals(this.tagId, analysisAttributionObj.tagId) &&
        Objects.equals(this.attrId, analysisAttributionObj.attrId) &&
        Objects.equals(this.eventDatasourceId, analysisAttributionObj.eventDatasourceId) &&
        Objects.equals(this.eventId, analysisAttributionObj.eventId) &&
        Objects.equals(this.eventName, analysisAttributionObj.eventName) &&
        Objects.equals(this.eventType, analysisAttributionObj.eventType) &&
        Objects.equals(this.eventAttributeName, analysisAttributionObj.eventAttributeName) &&
        Objects.equals(this.dimDataSourceId, analysisAttributionObj.dimDataSourceId) &&
        Objects.equals(this.dimColumnName, analysisAttributionObj.dimColumnName) &&
        Objects.equals(this.eventAttributeId, analysisAttributionObj.eventAttributeId) &&
        Objects.equals(this.attributeValueMapping, analysisAttributionObj.attributeValueMapping) &&
        Objects.equals(this.attr, analysisAttributionObj.attr) &&
        Objects.equals(this.dataSourceId, analysisAttributionObj.dataSourceId) &&
        Objects.equals(this.columnId, analysisAttributionObj.columnId) &&
        Objects.equals(this.columnName, analysisAttributionObj.columnName) &&
        Objects.equals(this.propertyType, analysisAttributionObj.propertyType) &&
        Objects.equals(this.limit, analysisAttributionObj.limit) &&
        Objects.equals(this.values, analysisAttributionObj.values) &&
        Objects.equals(this.rangeValues, analysisAttributionObj.rangeValues) &&
        Objects.equals(this.include, analysisAttributionObj.include) &&
        Objects.equals(this.exclude, analysisAttributionObj.exclude) &&
        Objects.equals(this.windowPeriod, analysisAttributionObj.windowPeriod) &&
        Objects.equals(this.analysisAttributionObjs, analysisAttributionObj.analysisAttributionObjs) &&
        Objects.equals(this.startObj, analysisAttributionObj.startObj) &&
        Objects.equals(this.endObj, analysisAttributionObj.endObj) &&
        Objects.equals(this.condition, analysisAttributionObj.condition) &&
        Objects.equals(this.filterCondition, analysisAttributionObj.filterCondition) &&
        Objects.equals(this.distinct, analysisAttributionObj.distinct) &&
        Objects.equals(this.nodes, analysisAttributionObj.nodes) &&
        Objects.equals(this.breakUp, analysisAttributionObj.breakUp) &&
        Objects.equals(this.method, analysisAttributionObj.method) &&
        Objects.equals(this.segIds, analysisAttributionObj.segIds) &&
        Objects.equals(this.segRules, analysisAttributionObj.segRules) &&
        Objects.equals(this.dateGroupRange, analysisAttributionObj.dateGroupRange) &&
        Objects.equals(this.dateSplitIndex, analysisAttributionObj.dateSplitIndex) &&
        Objects.equals(this.dateBasePeriods, analysisAttributionObj.dateBasePeriods) &&
        Objects.equals(this.objDataPeriod, analysisAttributionObj.objDataPeriod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(index, name, type, tagId, attrId, eventDatasourceId, eventId, eventName, eventType, eventAttributeName, dimDataSourceId, dimColumnName, eventAttributeId, attributeValueMapping, attr, dataSourceId, columnId, columnName, propertyType, limit, values, rangeValues, include, exclude, windowPeriod, analysisAttributionObjs, startObj, endObj, condition, filterCondition, distinct, nodes, breakUp, method, segIds, segRules, dateGroupRange, dateSplitIndex, dateBasePeriods, objDataPeriod);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnalysisAttributionObj {\n");
    
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    tagId: ").append(toIndentedString(tagId)).append("\n");
    sb.append("    attrId: ").append(toIndentedString(attrId)).append("\n");
    sb.append("    eventDatasourceId: ").append(toIndentedString(eventDatasourceId)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventName: ").append(toIndentedString(eventName)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    eventAttributeName: ").append(toIndentedString(eventAttributeName)).append("\n");
    sb.append("    dimDataSourceId: ").append(toIndentedString(dimDataSourceId)).append("\n");
    sb.append("    dimColumnName: ").append(toIndentedString(dimColumnName)).append("\n");
    sb.append("    eventAttributeId: ").append(toIndentedString(eventAttributeId)).append("\n");
    sb.append("    attributeValueMapping: ").append(toIndentedString(attributeValueMapping)).append("\n");
    sb.append("    attr: ").append(toIndentedString(attr)).append("\n");
    sb.append("    dataSourceId: ").append(toIndentedString(dataSourceId)).append("\n");
    sb.append("    columnId: ").append(toIndentedString(columnId)).append("\n");
    sb.append("    columnName: ").append(toIndentedString(columnName)).append("\n");
    sb.append("    propertyType: ").append(toIndentedString(propertyType)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    rangeValues: ").append(toIndentedString(rangeValues)).append("\n");
    sb.append("    include: ").append(toIndentedString(include)).append("\n");
    sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
    sb.append("    windowPeriod: ").append(toIndentedString(windowPeriod)).append("\n");
    sb.append("    analysisAttributionObjs: ").append(toIndentedString(analysisAttributionObjs)).append("\n");
    sb.append("    startObj: ").append(toIndentedString(startObj)).append("\n");
    sb.append("    endObj: ").append(toIndentedString(endObj)).append("\n");
    sb.append("    condition: ").append(toIndentedString(condition)).append("\n");
    sb.append("    filterCondition: ").append(toIndentedString(filterCondition)).append("\n");
    sb.append("    distinct: ").append(toIndentedString(distinct)).append("\n");
    sb.append("    nodes: ").append(toIndentedString(nodes)).append("\n");
    sb.append("    breakUp: ").append(toIndentedString(breakUp)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    segIds: ").append(toIndentedString(segIds)).append("\n");
    sb.append("    segRules: ").append(toIndentedString(segRules)).append("\n");
    sb.append("    dateGroupRange: ").append(toIndentedString(dateGroupRange)).append("\n");
    sb.append("    dateSplitIndex: ").append(toIndentedString(dateSplitIndex)).append("\n");
    sb.append("    dateBasePeriods: ").append(toIndentedString(dateBasePeriods)).append("\n");
    sb.append("    objDataPeriod: ").append(toIndentedString(objDataPeriod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
