/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.AnalysisDashBoardRegisterInfo;
import code.byted.cdp.model.BaseDimension;
import code.byted.cdp.model.BaseMetrics;
import code.byted.cdp.model.BasePeriod;
import code.byted.cdp.model.JsonNode;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * BaseAnalysisModuleReq
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class BaseAnalysisModuleReq {
  @SerializedName("subjectId")
  private Integer subjectId = null;

  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    USER_TENDENCY("USER_TENDENCY"),
    TRANS("TRANS"),
    ATTRIBUTION("ATTRIBUTION"),
    ATTRIBUTION_COLUMN("ATTRIBUTION_COLUMN"),
    NORMAL("NORMAL"),
    NORMAL_COLUMN("NORMAL_COLUMN"),
    CROSS_DIMENSION("CROSS_DIMENSION"),
    NORMAL_COLUMN_LINKAGE("NORMAL_COLUMN_LINKAGE"),
    NORMAL_COUNT("NORMAL_COUNT"),
    CROSS_DIMENSION_MERGE("CROSS_DIMENSION_MERGE"),
    EXTRA("EXTRA");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("seg")
  private JsonNode seg = null;

  @SerializedName("dimension")
  private BaseDimension dimension = null;

  @SerializedName("period")
  private BasePeriod period = null;

  @SerializedName("metrics")
  private BaseMetrics metrics = null;

  @SerializedName("withCache")
  private Boolean withCache = null;

  /**
   * 离线运算类型
   */
  @JsonAdapter(ScheduleRangeEnum.Adapter.class)
  public enum ScheduleRangeEnum {
    UNKNOWN("Unknown"),
    MANUAL("MANUAL"),
    DAILY("DAILY"),
    WEEKLY("WEEKLY"),
    MONTHLY("MONTHLY");

    private String value;

    ScheduleRangeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ScheduleRangeEnum fromValue(String input) {
      for (ScheduleRangeEnum b : ScheduleRangeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ScheduleRangeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScheduleRangeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ScheduleRangeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ScheduleRangeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("scheduleRange")
  private ScheduleRangeEnum scheduleRange = null;

  @SerializedName("authFilter")
  private Boolean authFilter = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("descr")
  private String descr = null;

  @SerializedName("displayConfig")
  private JsonNode displayConfig = null;

  @SerializedName("segRequired")
  private Boolean segRequired = null;

  @SerializedName("dimensionRequired")
  private Boolean dimensionRequired = null;

  @SerializedName("periodRequired")
  private Boolean periodRequired = null;

  @SerializedName("metricsRequired")
  private Boolean metricsRequired = null;

  @SerializedName("platform")
  private String platform = null;

  @SerializedName("hide")
  private Boolean hide = null;

  @SerializedName("analysisModuleObjId")
  private Integer analysisModuleObjId = null;

  @SerializedName("onSchedule")
  private Boolean onSchedule = null;

  @SerializedName("usableCdpModules")
  private List<String> usableCdpModules = null;

  @SerializedName("dateAggregate")
  private Boolean dateAggregate = null;

  @SerializedName("enableOfflineQuery")
  private Boolean enableOfflineQuery = null;

  @SerializedName("authUser")
  private String authUser = null;

  @SerializedName("analysisDashBoardRegisterInfo")
  private AnalysisDashBoardRegisterInfo analysisDashBoardRegisterInfo = null;

  @SerializedName("domainIds")
  private List<Integer> domainIds = null;

  @SerializedName("authSchema")
  private JsonNode authSchema = null;

  @SerializedName("commonFilterSegRule")
  private JsonNode commonFilterSegRule = null;

  @SerializedName("skipSqlOptimize")
  private Boolean skipSqlOptimize = null;

  public BaseAnalysisModuleReq subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * Get subjectId
   * @return subjectId
  **/
  @Schema(description = "")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public BaseAnalysisModuleReq type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public BaseAnalysisModuleReq seg(JsonNode seg) {
    this.seg = seg;
    return this;
  }

   /**
   * Get seg
   * @return seg
  **/
  @Schema(description = "")
  public JsonNode getSeg() {
    return seg;
  }

  public void setSeg(JsonNode seg) {
    this.seg = seg;
  }

  public BaseAnalysisModuleReq dimension(BaseDimension dimension) {
    this.dimension = dimension;
    return this;
  }

   /**
   * Get dimension
   * @return dimension
  **/
  @Schema(description = "")
  public BaseDimension getDimension() {
    return dimension;
  }

  public void setDimension(BaseDimension dimension) {
    this.dimension = dimension;
  }

  public BaseAnalysisModuleReq period(BasePeriod period) {
    this.period = period;
    return this;
  }

   /**
   * Get period
   * @return period
  **/
  @Schema(description = "")
  public BasePeriod getPeriod() {
    return period;
  }

  public void setPeriod(BasePeriod period) {
    this.period = period;
  }

  public BaseAnalysisModuleReq metrics(BaseMetrics metrics) {
    this.metrics = metrics;
    return this;
  }

   /**
   * Get metrics
   * @return metrics
  **/
  @Schema(description = "")
  public BaseMetrics getMetrics() {
    return metrics;
  }

  public void setMetrics(BaseMetrics metrics) {
    this.metrics = metrics;
  }

  public BaseAnalysisModuleReq withCache(Boolean withCache) {
    this.withCache = withCache;
    return this;
  }

   /**
   * 使用历史计算结果
   * @return withCache
  **/
  @Schema(description = "使用历史计算结果")
  public Boolean isWithCache() {
    return withCache;
  }

  public void setWithCache(Boolean withCache) {
    this.withCache = withCache;
  }

  public BaseAnalysisModuleReq scheduleRange(ScheduleRangeEnum scheduleRange) {
    this.scheduleRange = scheduleRange;
    return this;
  }

   /**
   * 离线运算类型
   * @return scheduleRange
  **/
  @Schema(description = "离线运算类型")
  public ScheduleRangeEnum getScheduleRange() {
    return scheduleRange;
  }

  public void setScheduleRange(ScheduleRangeEnum scheduleRange) {
    this.scheduleRange = scheduleRange;
  }

  public BaseAnalysisModuleReq authFilter(Boolean authFilter) {
    this.authFilter = authFilter;
    return this;
  }

   /**
   * 是否使用行权限
   * @return authFilter
  **/
  @Schema(description = "是否使用行权限")
  public Boolean isAuthFilter() {
    return authFilter;
  }

  public void setAuthFilter(Boolean authFilter) {
    this.authFilter = authFilter;
  }

  public BaseAnalysisModuleReq name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 指标名称
   * @return name
  **/
  @Schema(description = "指标名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public BaseAnalysisModuleReq descr(String descr) {
    this.descr = descr;
    return this;
  }

   /**
   * 指标描述
   * @return descr
  **/
  @Schema(description = "指标描述")
  public String getDescr() {
    return descr;
  }

  public void setDescr(String descr) {
    this.descr = descr;
  }

  public BaseAnalysisModuleReq displayConfig(JsonNode displayConfig) {
    this.displayConfig = displayConfig;
    return this;
  }

   /**
   * Get displayConfig
   * @return displayConfig
  **/
  @Schema(description = "")
  public JsonNode getDisplayConfig() {
    return displayConfig;
  }

  public void setDisplayConfig(JsonNode displayConfig) {
    this.displayConfig = displayConfig;
  }

  public BaseAnalysisModuleReq segRequired(Boolean segRequired) {
    this.segRequired = segRequired;
    return this;
  }

   /**
   * 是否需要传入人群条件
   * @return segRequired
  **/
  @Schema(description = "是否需要传入人群条件")
  public Boolean isSegRequired() {
    return segRequired;
  }

  public void setSegRequired(Boolean segRequired) {
    this.segRequired = segRequired;
  }

  public BaseAnalysisModuleReq dimensionRequired(Boolean dimensionRequired) {
    this.dimensionRequired = dimensionRequired;
    return this;
  }

   /**
   * 是否需要传入维度条件
   * @return dimensionRequired
  **/
  @Schema(description = "是否需要传入维度条件")
  public Boolean isDimensionRequired() {
    return dimensionRequired;
  }

  public void setDimensionRequired(Boolean dimensionRequired) {
    this.dimensionRequired = dimensionRequired;
  }

  public BaseAnalysisModuleReq periodRequired(Boolean periodRequired) {
    this.periodRequired = periodRequired;
    return this;
  }

   /**
   * 是否需要传入时间周期
   * @return periodRequired
  **/
  @Schema(description = "是否需要传入时间周期")
  public Boolean isPeriodRequired() {
    return periodRequired;
  }

  public void setPeriodRequired(Boolean periodRequired) {
    this.periodRequired = periodRequired;
  }

  public BaseAnalysisModuleReq metricsRequired(Boolean metricsRequired) {
    this.metricsRequired = metricsRequired;
    return this;
  }

   /**
   * 是否需要传入指标条件
   * @return metricsRequired
  **/
  @Schema(description = "是否需要传入指标条件")
  public Boolean isMetricsRequired() {
    return metricsRequired;
  }

  public void setMetricsRequired(Boolean metricsRequired) {
    this.metricsRequired = metricsRequired;
  }

  public BaseAnalysisModuleReq platform(String platform) {
    this.platform = platform;
    return this;
  }

   /**
   * 应用平台/功能模块
   * @return platform
  **/
  @Schema(description = "应用平台/功能模块")
  public String getPlatform() {
    return platform;
  }

  public void setPlatform(String platform) {
    this.platform = platform;
  }

  public BaseAnalysisModuleReq hide(Boolean hide) {
    this.hide = hide;
    return this;
  }

   /**
   * 是否在通用了列表页中展示
   * @return hide
  **/
  @Schema(description = "是否在通用了列表页中展示")
  public Boolean isHide() {
    return hide;
  }

  public void setHide(Boolean hide) {
    this.hide = hide;
  }

  public BaseAnalysisModuleReq analysisModuleObjId(Integer analysisModuleObjId) {
    this.analysisModuleObjId = analysisModuleObjId;
    return this;
  }

   /**
   * Get analysisModuleObjId
   * @return analysisModuleObjId
  **/
  @Schema(description = "")
  public Integer getAnalysisModuleObjId() {
    return analysisModuleObjId;
  }

  public void setAnalysisModuleObjId(Integer analysisModuleObjId) {
    this.analysisModuleObjId = analysisModuleObjId;
  }

  public BaseAnalysisModuleReq onSchedule(Boolean onSchedule) {
    this.onSchedule = onSchedule;
    return this;
  }

   /**
   * 是否开启定时任务
   * @return onSchedule
  **/
  @Schema(description = "是否开启定时任务")
  public Boolean isOnSchedule() {
    return onSchedule;
  }

  public void setOnSchedule(Boolean onSchedule) {
    this.onSchedule = onSchedule;
  }

  public BaseAnalysisModuleReq usableCdpModules(List<String> usableCdpModules) {
    this.usableCdpModules = usableCdpModules;
    return this;
  }

  public BaseAnalysisModuleReq addUsableCdpModulesItem(String usableCdpModulesItem) {
    if (this.usableCdpModules == null) {
      this.usableCdpModules = new ArrayList<String>();
    }
    this.usableCdpModules.add(usableCdpModulesItem);
    return this;
  }

   /**
   * 可使用的cdp模块
   * @return usableCdpModules
  **/
  @Schema(description = "可使用的cdp模块")
  public List<String> getUsableCdpModules() {
    return usableCdpModules;
  }

  public void setUsableCdpModules(List<String> usableCdpModules) {
    this.usableCdpModules = usableCdpModules;
  }

  public BaseAnalysisModuleReq dateAggregate(Boolean dateAggregate) {
    this.dateAggregate = dateAggregate;
    return this;
  }

   /**
   * 日期聚合字段覆盖
   * @return dateAggregate
  **/
  @Schema(description = "日期聚合字段覆盖")
  public Boolean isDateAggregate() {
    return dateAggregate;
  }

  public void setDateAggregate(Boolean dateAggregate) {
    this.dateAggregate = dateAggregate;
  }

  public BaseAnalysisModuleReq enableOfflineQuery(Boolean enableOfflineQuery) {
    this.enableOfflineQuery = enableOfflineQuery;
    return this;
  }

   /**
   * Get enableOfflineQuery
   * @return enableOfflineQuery
  **/
  @Schema(description = "")
  public Boolean isEnableOfflineQuery() {
    return enableOfflineQuery;
  }

  public void setEnableOfflineQuery(Boolean enableOfflineQuery) {
    this.enableOfflineQuery = enableOfflineQuery;
  }

  public BaseAnalysisModuleReq authUser(String authUser) {
    this.authUser = authUser;
    return this;
  }

   /**
   * Get authUser
   * @return authUser
  **/
  @Schema(description = "")
  public String getAuthUser() {
    return authUser;
  }

  public void setAuthUser(String authUser) {
    this.authUser = authUser;
  }

  public BaseAnalysisModuleReq analysisDashBoardRegisterInfo(AnalysisDashBoardRegisterInfo analysisDashBoardRegisterInfo) {
    this.analysisDashBoardRegisterInfo = analysisDashBoardRegisterInfo;
    return this;
  }

   /**
   * Get analysisDashBoardRegisterInfo
   * @return analysisDashBoardRegisterInfo
  **/
  @Schema(description = "")
  public AnalysisDashBoardRegisterInfo getAnalysisDashBoardRegisterInfo() {
    return analysisDashBoardRegisterInfo;
  }

  public void setAnalysisDashBoardRegisterInfo(AnalysisDashBoardRegisterInfo analysisDashBoardRegisterInfo) {
    this.analysisDashBoardRegisterInfo = analysisDashBoardRegisterInfo;
  }

  public BaseAnalysisModuleReq domainIds(List<Integer> domainIds) {
    this.domainIds = domainIds;
    return this;
  }

  public BaseAnalysisModuleReq addDomainIdsItem(Integer domainIdsItem) {
    if (this.domainIds == null) {
      this.domainIds = new ArrayList<Integer>();
    }
    this.domainIds.add(domainIdsItem);
    return this;
  }

   /**
   * 挂载的分组id
   * @return domainIds
  **/
  @Schema(description = "挂载的分组id")
  public List<Integer> getDomainIds() {
    return domainIds;
  }

  public void setDomainIds(List<Integer> domainIds) {
    this.domainIds = domainIds;
  }

  public BaseAnalysisModuleReq authSchema(JsonNode authSchema) {
    this.authSchema = authSchema;
    return this;
  }

   /**
   * Get authSchema
   * @return authSchema
  **/
  @Schema(description = "")
  public JsonNode getAuthSchema() {
    return authSchema;
  }

  public void setAuthSchema(JsonNode authSchema) {
    this.authSchema = authSchema;
  }

  public BaseAnalysisModuleReq commonFilterSegRule(JsonNode commonFilterSegRule) {
    this.commonFilterSegRule = commonFilterSegRule;
    return this;
  }

   /**
   * Get commonFilterSegRule
   * @return commonFilterSegRule
  **/
  @Schema(description = "")
  public JsonNode getCommonFilterSegRule() {
    return commonFilterSegRule;
  }

  public void setCommonFilterSegRule(JsonNode commonFilterSegRule) {
    this.commonFilterSegRule = commonFilterSegRule;
  }

  public BaseAnalysisModuleReq skipSqlOptimize(Boolean skipSqlOptimize) {
    this.skipSqlOptimize = skipSqlOptimize;
    return this;
  }

   /**
   * 强制跳过规则简化拼接，因为规则优化的话，人群规则会触发特定日期的指定，对于效果分析等部分需要固定规则场景，会导致计算异常，默认false
   * @return skipSqlOptimize
  **/
  @Schema(description = "强制跳过规则简化拼接，因为规则优化的话，人群规则会触发特定日期的指定，对于效果分析等部分需要固定规则场景，会导致计算异常，默认false")
  public Boolean isSkipSqlOptimize() {
    return skipSqlOptimize;
  }

  public void setSkipSqlOptimize(Boolean skipSqlOptimize) {
    this.skipSqlOptimize = skipSqlOptimize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseAnalysisModuleReq baseAnalysisModuleReq = (BaseAnalysisModuleReq) o;
    return Objects.equals(this.subjectId, baseAnalysisModuleReq.subjectId) &&
        Objects.equals(this.type, baseAnalysisModuleReq.type) &&
        Objects.equals(this.seg, baseAnalysisModuleReq.seg) &&
        Objects.equals(this.dimension, baseAnalysisModuleReq.dimension) &&
        Objects.equals(this.period, baseAnalysisModuleReq.period) &&
        Objects.equals(this.metrics, baseAnalysisModuleReq.metrics) &&
        Objects.equals(this.withCache, baseAnalysisModuleReq.withCache) &&
        Objects.equals(this.scheduleRange, baseAnalysisModuleReq.scheduleRange) &&
        Objects.equals(this.authFilter, baseAnalysisModuleReq.authFilter) &&
        Objects.equals(this.name, baseAnalysisModuleReq.name) &&
        Objects.equals(this.descr, baseAnalysisModuleReq.descr) &&
        Objects.equals(this.displayConfig, baseAnalysisModuleReq.displayConfig) &&
        Objects.equals(this.segRequired, baseAnalysisModuleReq.segRequired) &&
        Objects.equals(this.dimensionRequired, baseAnalysisModuleReq.dimensionRequired) &&
        Objects.equals(this.periodRequired, baseAnalysisModuleReq.periodRequired) &&
        Objects.equals(this.metricsRequired, baseAnalysisModuleReq.metricsRequired) &&
        Objects.equals(this.platform, baseAnalysisModuleReq.platform) &&
        Objects.equals(this.hide, baseAnalysisModuleReq.hide) &&
        Objects.equals(this.analysisModuleObjId, baseAnalysisModuleReq.analysisModuleObjId) &&
        Objects.equals(this.onSchedule, baseAnalysisModuleReq.onSchedule) &&
        Objects.equals(this.usableCdpModules, baseAnalysisModuleReq.usableCdpModules) &&
        Objects.equals(this.dateAggregate, baseAnalysisModuleReq.dateAggregate) &&
        Objects.equals(this.enableOfflineQuery, baseAnalysisModuleReq.enableOfflineQuery) &&
        Objects.equals(this.authUser, baseAnalysisModuleReq.authUser) &&
        Objects.equals(this.analysisDashBoardRegisterInfo, baseAnalysisModuleReq.analysisDashBoardRegisterInfo) &&
        Objects.equals(this.domainIds, baseAnalysisModuleReq.domainIds) &&
        Objects.equals(this.authSchema, baseAnalysisModuleReq.authSchema) &&
        Objects.equals(this.commonFilterSegRule, baseAnalysisModuleReq.commonFilterSegRule) &&
        Objects.equals(this.skipSqlOptimize, baseAnalysisModuleReq.skipSqlOptimize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subjectId, type, seg, dimension, period, metrics, withCache, scheduleRange, authFilter, name, descr, displayConfig, segRequired, dimensionRequired, periodRequired, metricsRequired, platform, hide, analysisModuleObjId, onSchedule, usableCdpModules, dateAggregate, enableOfflineQuery, authUser, analysisDashBoardRegisterInfo, domainIds, authSchema, commonFilterSegRule, skipSqlOptimize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseAnalysisModuleReq {\n");
    
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    seg: ").append(toIndentedString(seg)).append("\n");
    sb.append("    dimension: ").append(toIndentedString(dimension)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    withCache: ").append(toIndentedString(withCache)).append("\n");
    sb.append("    scheduleRange: ").append(toIndentedString(scheduleRange)).append("\n");
    sb.append("    authFilter: ").append(toIndentedString(authFilter)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descr: ").append(toIndentedString(descr)).append("\n");
    sb.append("    displayConfig: ").append(toIndentedString(displayConfig)).append("\n");
    sb.append("    segRequired: ").append(toIndentedString(segRequired)).append("\n");
    sb.append("    dimensionRequired: ").append(toIndentedString(dimensionRequired)).append("\n");
    sb.append("    periodRequired: ").append(toIndentedString(periodRequired)).append("\n");
    sb.append("    metricsRequired: ").append(toIndentedString(metricsRequired)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    hide: ").append(toIndentedString(hide)).append("\n");
    sb.append("    analysisModuleObjId: ").append(toIndentedString(analysisModuleObjId)).append("\n");
    sb.append("    onSchedule: ").append(toIndentedString(onSchedule)).append("\n");
    sb.append("    usableCdpModules: ").append(toIndentedString(usableCdpModules)).append("\n");
    sb.append("    dateAggregate: ").append(toIndentedString(dateAggregate)).append("\n");
    sb.append("    enableOfflineQuery: ").append(toIndentedString(enableOfflineQuery)).append("\n");
    sb.append("    authUser: ").append(toIndentedString(authUser)).append("\n");
    sb.append("    analysisDashBoardRegisterInfo: ").append(toIndentedString(analysisDashBoardRegisterInfo)).append("\n");
    sb.append("    domainIds: ").append(toIndentedString(domainIds)).append("\n");
    sb.append("    authSchema: ").append(toIndentedString(authSchema)).append("\n");
    sb.append("    commonFilterSegRule: ").append(toIndentedString(commonFilterSegRule)).append("\n");
    sb.append("    skipSqlOptimize: ").append(toIndentedString(skipSqlOptimize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
