/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.AnalysisAttributionObj;
import code.byted.cdp.model.BaseMetrics;
import code.byted.cdp.model.BasePeriod;
import code.byted.cdp.model.FunctionObj;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * BaseMetrics
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class BaseMetrics {
  @SerializedName("name")
  private String name = null;

  /**
   * 指标计算模型
   */
  @JsonAdapter(MethodEnum.Adapter.class)
  public enum MethodEnum {
    UNKNOWN("Unknown"),
    SUM("SUM"),
    AVG("AVG"),
    MAX("MAX"),
    MIN("MIN"),
    COUNT("COUNT"),
    DISTINCT_COUNT("DISTINCT_COUNT"),
    COUNT_WITH_ATTR("COUNT_WITH_ATTR"),
    DISTINCT_COUNT_WITH_ATTR("DISTINCT_COUNT_WITH_ATTR"),
    ATTRIBUTION("ATTRIBUTION"),
    TRANS("TRANS"),
    FUNCTION("FUNCTION"),
    SINGLE("SINGLE"),
    ID("ID"),
    MULTI_METRICS("MULTI_METRICS"),
    USER_TENDENCY("USER_TENDENCY");

    private String value;

    MethodEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static MethodEnum fromValue(String input) {
      for (MethodEnum b : MethodEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<MethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final MethodEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public MethodEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return MethodEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("method")
  private MethodEnum method = null;

  @SerializedName("period")
  private BasePeriod period = null;

  /**
   * 归因分析模型
   */
  @JsonAdapter(AttributionTypeEnum.Adapter.class)
  public enum AttributionTypeEnum {
    UNKNOWN("Unknown"),
    FIRST("FIRST"),
    LAST("LAST"),
    LINE("LINE"),
    POSITION("POSITION"),
    ATTENUATION("ATTENUATION"),
    FULL("FULL");

    private String value;

    AttributionTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static AttributionTypeEnum fromValue(String input) {
      for (AttributionTypeEnum b : AttributionTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<AttributionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AttributionTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public AttributionTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return AttributionTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("attributionType")
  private AttributionTypeEnum attributionType = null;

  @SerializedName("analysisAttributionObjs")
  private List<AnalysisAttributionObj> analysisAttributionObjs = null;

  @SerializedName("function")
  private FunctionObj function = null;

  /**
   * 展示方式
   */
  @JsonAdapter(FormatEnumEnum.Adapter.class)
  public enum FormatEnumEnum {
    UNKNOWN("Unknown"),
    INTEGER("INTEGER"),
    FLOAT("FLOAT"),
    PERCENT_INTEGER("PERCENT_INTEGER"),
    PERCENT_FLOAT("PERCENT_FLOAT");

    private String value;

    FormatEnumEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static FormatEnumEnum fromValue(String input) {
      for (FormatEnumEnum b : FormatEnumEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<FormatEnumEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FormatEnumEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public FormatEnumEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return FormatEnumEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("formatEnum")
  private FormatEnumEnum formatEnum = null;

  @SerializedName("attributionEvent")
  private List<AnalysisAttributionObj> attributionEvent = null;

  @SerializedName("attributionObj")
  private AnalysisAttributionObj attributionObj = null;

  @SerializedName("limit")
  private Integer limit = null;

  @SerializedName("metricsId")
  private Integer metricsId = null;

  @SerializedName("metricsCnName")
  private String metricsCnName = null;

  @SerializedName("metricsList")
  private List<BaseMetrics> metricsList = null;

  @SerializedName("targetIdTypeId")
  private Integer targetIdTypeId = null;

  @SerializedName("simpleFormat")
  private Boolean simpleFormat = null;

  public BaseMetrics name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 指标名称
   * @return name
  **/
  @Schema(description = "指标名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public BaseMetrics method(MethodEnum method) {
    this.method = method;
    return this;
  }

   /**
   * 指标计算模型
   * @return method
  **/
  @Schema(required = true, description = "指标计算模型")
  public MethodEnum getMethod() {
    return method;
  }

  public void setMethod(MethodEnum method) {
    this.method = method;
  }

  public BaseMetrics period(BasePeriod period) {
    this.period = period;
    return this;
  }

   /**
   * Get period
   * @return period
  **/
  @Schema(description = "")
  public BasePeriod getPeriod() {
    return period;
  }

  public void setPeriod(BasePeriod period) {
    this.period = period;
  }

  public BaseMetrics attributionType(AttributionTypeEnum attributionType) {
    this.attributionType = attributionType;
    return this;
  }

   /**
   * 归因分析模型
   * @return attributionType
  **/
  @Schema(description = "归因分析模型")
  public AttributionTypeEnum getAttributionType() {
    return attributionType;
  }

  public void setAttributionType(AttributionTypeEnum attributionType) {
    this.attributionType = attributionType;
  }

  public BaseMetrics analysisAttributionObjs(List<AnalysisAttributionObj> analysisAttributionObjs) {
    this.analysisAttributionObjs = analysisAttributionObjs;
    return this;
  }

  public BaseMetrics addAnalysisAttributionObjsItem(AnalysisAttributionObj analysisAttributionObjsItem) {
    if (this.analysisAttributionObjs == null) {
      this.analysisAttributionObjs = new ArrayList<AnalysisAttributionObj>();
    }
    this.analysisAttributionObjs.add(analysisAttributionObjsItem);
    return this;
  }

   /**
   * 指标
   * @return analysisAttributionObjs
  **/
  @Schema(description = "指标")
  public List<AnalysisAttributionObj> getAnalysisAttributionObjs() {
    return analysisAttributionObjs;
  }

  public void setAnalysisAttributionObjs(List<AnalysisAttributionObj> analysisAttributionObjs) {
    this.analysisAttributionObjs = analysisAttributionObjs;
  }

  public BaseMetrics function(FunctionObj function) {
    this.function = function;
    return this;
  }

   /**
   * Get function
   * @return function
  **/
  @Schema(description = "")
  public FunctionObj getFunction() {
    return function;
  }

  public void setFunction(FunctionObj function) {
    this.function = function;
  }

  public BaseMetrics formatEnum(FormatEnumEnum formatEnum) {
    this.formatEnum = formatEnum;
    return this;
  }

   /**
   * 展示方式
   * @return formatEnum
  **/
  @Schema(description = "展示方式")
  public FormatEnumEnum getFormatEnum() {
    return formatEnum;
  }

  public void setFormatEnum(FormatEnumEnum formatEnum) {
    this.formatEnum = formatEnum;
  }

  public BaseMetrics attributionEvent(List<AnalysisAttributionObj> attributionEvent) {
    this.attributionEvent = attributionEvent;
    return this;
  }

  public BaseMetrics addAttributionEventItem(AnalysisAttributionObj attributionEventItem) {
    if (this.attributionEvent == null) {
      this.attributionEvent = new ArrayList<AnalysisAttributionObj>();
    }
    this.attributionEvent.add(attributionEventItem);
    return this;
  }

   /**
   * 归因分析归因目标事件
   * @return attributionEvent
  **/
  @Schema(description = "归因分析归因目标事件")
  public List<AnalysisAttributionObj> getAttributionEvent() {
    return attributionEvent;
  }

  public void setAttributionEvent(List<AnalysisAttributionObj> attributionEvent) {
    this.attributionEvent = attributionEvent;
  }

  public BaseMetrics attributionObj(AnalysisAttributionObj attributionObj) {
    this.attributionObj = attributionObj;
    return this;
  }

   /**
   * Get attributionObj
   * @return attributionObj
  **/
  @Schema(description = "")
  public AnalysisAttributionObj getAttributionObj() {
    return attributionObj;
  }

  public void setAttributionObj(AnalysisAttributionObj attributionObj) {
    this.attributionObj = attributionObj;
  }

  public BaseMetrics limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * 指标数量限制
   * @return limit
  **/
  @Schema(description = "指标数量限制")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public BaseMetrics metricsId(Integer metricsId) {
    this.metricsId = metricsId;
    return this;
  }

   /**
   * 指标id
   * @return metricsId
  **/
  @Schema(description = "指标id")
  public Integer getMetricsId() {
    return metricsId;
  }

  public void setMetricsId(Integer metricsId) {
    this.metricsId = metricsId;
  }

  public BaseMetrics metricsCnName(String metricsCnName) {
    this.metricsCnName = metricsCnName;
    return this;
  }

   /**
   * 指标中文名称，只用于模版，用户名称和id的替换
   * @return metricsCnName
  **/
  @Schema(description = "指标中文名称，只用于模版，用户名称和id的替换")
  public String getMetricsCnName() {
    return metricsCnName;
  }

  public void setMetricsCnName(String metricsCnName) {
    this.metricsCnName = metricsCnName;
  }

  public BaseMetrics metricsList(List<BaseMetrics> metricsList) {
    this.metricsList = metricsList;
    return this;
  }

  public BaseMetrics addMetricsListItem(BaseMetrics metricsListItem) {
    if (this.metricsList == null) {
      this.metricsList = new ArrayList<BaseMetrics>();
    }
    this.metricsList.add(metricsListItem);
    return this;
  }

   /**
   * 多指标对象
   * @return metricsList
  **/
  @Schema(description = "多指标对象")
  public List<BaseMetrics> getMetricsList() {
    return metricsList;
  }

  public void setMetricsList(List<BaseMetrics> metricsList) {
    this.metricsList = metricsList;
  }

  public BaseMetrics targetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
    return this;
  }

   /**
   * 计算输出的id类型
   * @return targetIdTypeId
  **/
  @Schema(description = "计算输出的id类型")
  public Integer getTargetIdTypeId() {
    return targetIdTypeId;
  }

  public void setTargetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
  }

  public BaseMetrics simpleFormat(Boolean simpleFormat) {
    this.simpleFormat = simpleFormat;
    return this;
  }

   /**
   * Get simpleFormat
   * @return simpleFormat
  **/
  @Schema(description = "")
  public Boolean isSimpleFormat() {
    return simpleFormat;
  }

  public void setSimpleFormat(Boolean simpleFormat) {
    this.simpleFormat = simpleFormat;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseMetrics baseMetrics = (BaseMetrics) o;
    return Objects.equals(this.name, baseMetrics.name) &&
        Objects.equals(this.method, baseMetrics.method) &&
        Objects.equals(this.period, baseMetrics.period) &&
        Objects.equals(this.attributionType, baseMetrics.attributionType) &&
        Objects.equals(this.analysisAttributionObjs, baseMetrics.analysisAttributionObjs) &&
        Objects.equals(this.function, baseMetrics.function) &&
        Objects.equals(this.formatEnum, baseMetrics.formatEnum) &&
        Objects.equals(this.attributionEvent, baseMetrics.attributionEvent) &&
        Objects.equals(this.attributionObj, baseMetrics.attributionObj) &&
        Objects.equals(this.limit, baseMetrics.limit) &&
        Objects.equals(this.metricsId, baseMetrics.metricsId) &&
        Objects.equals(this.metricsCnName, baseMetrics.metricsCnName) &&
        Objects.equals(this.metricsList, baseMetrics.metricsList) &&
        Objects.equals(this.targetIdTypeId, baseMetrics.targetIdTypeId) &&
        Objects.equals(this.simpleFormat, baseMetrics.simpleFormat);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, method, period, attributionType, analysisAttributionObjs, function, formatEnum, attributionEvent, attributionObj, limit, metricsId, metricsCnName, metricsList, targetIdTypeId, simpleFormat);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseMetrics {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    attributionType: ").append(toIndentedString(attributionType)).append("\n");
    sb.append("    analysisAttributionObjs: ").append(toIndentedString(analysisAttributionObjs)).append("\n");
    sb.append("    function: ").append(toIndentedString(function)).append("\n");
    sb.append("    formatEnum: ").append(toIndentedString(formatEnum)).append("\n");
    sb.append("    attributionEvent: ").append(toIndentedString(attributionEvent)).append("\n");
    sb.append("    attributionObj: ").append(toIndentedString(attributionObj)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    metricsId: ").append(toIndentedString(metricsId)).append("\n");
    sb.append("    metricsCnName: ").append(toIndentedString(metricsCnName)).append("\n");
    sb.append("    metricsList: ").append(toIndentedString(metricsList)).append("\n");
    sb.append("    targetIdTypeId: ").append(toIndentedString(targetIdTypeId)).append("\n");
    sb.append("    simpleFormat: ").append(toIndentedString(simpleFormat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
