package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import lombok.Data;

@Data
public class CreateConditionalSegReq {

    @Schema(description = "分群名称", required = true)
    private String name;
    @Schema(description = "分群描述")
    private String desc;
    @Schema(description = "导出实体id，公域写死0", required = true)
    private Integer targetIdTypeId;
    @Schema(description = "圈人条件", required = true)
    Object filter;
    @Schema(description = "更新方式，默认一次性")
    private ScheduleType scheduleType;
    @Schema(description = "任务执行时间，00:00格式")
    private String scheduleTime;
    @Schema(description = "来源平台")
    private String sourcePlatform;
    @Schema(description = "抽样数量")
    private Integer sampleLimit;
    @Schema(description = "黑名单分群ID")
    private Set<Long> blacklistSegId;

}
