/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * CreateImportLabelEvent
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class CreateImportLabelEvent {
  @SerializedName("showName")
  private String showName = null;

  @SerializedName("baseValueType")
  private String baseValueType = null;

  @SerializedName("domainId")
  private Integer domainId = null;

  @SerializedName("dataSourceId")
  private Long dataSourceId = null;

  @SerializedName("fieldMapId")
  private Integer fieldMapId = null;

  @SerializedName("decimalPlaces")
  private Integer decimalPlaces = null;

  public CreateImportLabelEvent showName(String showName) {
    this.showName = showName;
    return this;
  }

   /**
   * 标签展示名
   * @return showName
  **/
  @Schema(required = true, description = "标签展示名")
  public String getShowName() {
    return showName;
  }

  public void setShowName(String showName) {
    this.showName = showName;
  }

  public CreateImportLabelEvent baseValueType(String baseValueType) {
    this.baseValueType = baseValueType;
    return this;
  }

   /**
   * 标签数据类型, 可选值包括：浮点型-float, 数值型-int, 文本型-string, 日期型-date, 日期时间型-datetime, 多值文本型-array&lt;string&gt;
   * @return baseValueType
  **/
  @Schema(required = true, description = "标签数据类型, 可选值包括：浮点型-float, 数值型-int, 文本型-string, 日期型-date, 日期时间型-datetime, 多值文本型-array<string>")
  public String getBaseValueType() {
    return baseValueType;
  }

  public void setBaseValueType(String baseValueType) {
    this.baseValueType = baseValueType;
  }

  public CreateImportLabelEvent domainId(Integer domainId) {
    this.domainId = domainId;
    return this;
  }

   /**
   * 标签分类id
   * @return domainId
  **/
  @Schema(required = true, description = "标签分类id")
  public Integer getDomainId() {
    return domainId;
  }

  public void setDomainId(Integer domainId) {
    this.domainId = domainId;
  }

  public CreateImportLabelEvent dataSourceId(Long dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

   /**
   * 导入标签上游数据源id
   * @return dataSourceId
  **/
  @Schema(required = true, description = "导入标签上游数据源id")
  public Long getDataSourceId() {
    return dataSourceId;
  }

  public void setDataSourceId(Long dataSourceId) {
    this.dataSourceId = dataSourceId;
  }

  public CreateImportLabelEvent fieldMapId(Integer fieldMapId) {
    this.fieldMapId = fieldMapId;
    return this;
  }

   /**
   * 导入标签导入字段id
   * @return fieldMapId
  **/
  @Schema(required = true, description = "导入标签导入字段id")
  public Integer getFieldMapId() {
    return fieldMapId;
  }

  public void setFieldMapId(Integer fieldMapId) {
    this.fieldMapId = fieldMapId;
  }

  public CreateImportLabelEvent decimalPlaces(Integer decimalPlaces) {
    this.decimalPlaces = decimalPlaces;
    return this;
  }

   /**
   * 导入标签需保留小数位数, 小数型标签可以设置（范围0-4），不设置默认保留两位
   * @return decimalPlaces
  **/
  @Schema(description = "导入标签需保留小数位数, 小数型标签可以设置（范围0-4），不设置默认保留两位")
  public Integer getDecimalPlaces() {
    return decimalPlaces;
  }

  public void setDecimalPlaces(Integer decimalPlaces) {
    this.decimalPlaces = decimalPlaces;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateImportLabelEvent createImportLabelEvent = (CreateImportLabelEvent) o;
    return Objects.equals(this.showName, createImportLabelEvent.showName) &&
        Objects.equals(this.baseValueType, createImportLabelEvent.baseValueType) &&
        Objects.equals(this.domainId, createImportLabelEvent.domainId) &&
        Objects.equals(this.dataSourceId, createImportLabelEvent.dataSourceId) &&
        Objects.equals(this.fieldMapId, createImportLabelEvent.fieldMapId) &&
        Objects.equals(this.decimalPlaces, createImportLabelEvent.decimalPlaces);
  }

  @Override
  public int hashCode() {
    return Objects.hash(showName, baseValueType, domainId, dataSourceId, fieldMapId, decimalPlaces);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateImportLabelEvent {\n");
    
    sb.append("    showName: ").append(toIndentedString(showName)).append("\n");
    sb.append("    baseValueType: ").append(toIndentedString(baseValueType)).append("\n");
    sb.append("    domainId: ").append(toIndentedString(domainId)).append("\n");
    sb.append("    dataSourceId: ").append(toIndentedString(dataSourceId)).append("\n");
    sb.append("    fieldMapId: ").append(toIndentedString(fieldMapId)).append("\n");
    sb.append("    decimalPlaces: ").append(toIndentedString(decimalPlaces)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
