package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.nashorn.internal.ir.ObjectNode;
import lombok.Data;

@Data
public class CreatePercentUploadSegReq {

    @Schema(description = "分群名称", required = true)
    String name;
    @Schema(description = "是否开启了在线服务")
    Boolean abaseEnabled;
    @Schema(description = "目标id类型Id", required = true)
    Integer targetIdTypeId;
    @Schema(description = "分群DSL", required = true)
    Object filter;
    @Schema(description = "分群描述")
    String description;
    @Deprecated
    @Schema(description = "百分比")
    private BigDecimal percent;
    @Schema(description = "百分比,与分组数量二选一")
    private List<BigDecimal> percents;
    @Schema(description = "分组数量,与百分比二选一")
    private List<Long> parts;
    @Schema(description = "来源平台", required = true)
    private String sourcePlatform;
    @Schema(description = "取第几个百分比/分组数量,基于0", required = true)
    private Integer sampleIndex;
    @Schema(description = "黑名单分群ID，不传使用默认的")
    private Set<Long> blacklistSegId;
    @Schema(description = "更新方式，默认一次性")
    private ScheduleType scheduleType;
    @Schema(description = "任务执行时间，00:00格式")
    private String scheduleTime;
}
