/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.Resource;
import code.byted.cdp.model.ResourceUsage;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * CreateResourceUsagesRequest
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class CreateResourceUsagesRequest {
  @SerializedName("resources")
  private List<Resource> resources = new ArrayList<Resource>();

  @SerializedName("servicePsm")
  private String servicePsm = null;

  @SerializedName("resource_usages")
  private List<ResourceUsage> resourceUsages = new ArrayList<ResourceUsage>();

  public CreateResourceUsagesRequest resources(List<Resource> resources) {
    this.resources = resources;
    return this;
  }

  public CreateResourceUsagesRequest addResourcesItem(Resource resourcesItem) {
    this.resources.add(resourcesItem);
    return this;
  }

   /**
   * CDP资源的集合
   * @return resources
  **/
  @Schema(required = true, description = "CDP资源的集合")
  public List<Resource> getResources() {
    return resources;
  }

  public void setResources(List<Resource> resources) {
    this.resources = resources;
  }

  public CreateResourceUsagesRequest servicePsm(String servicePsm) {
    this.servicePsm = servicePsm;
    return this;
  }

   /**
   * 使用CDP资源的调用方
   * @return servicePsm
  **/
  @Schema(description = "使用CDP资源的调用方")
  public String getServicePsm() {
    return servicePsm;
  }

  public void setServicePsm(String servicePsm) {
    this.servicePsm = servicePsm;
  }

  public CreateResourceUsagesRequest resourceUsages(List<ResourceUsage> resourceUsages) {
    this.resourceUsages = resourceUsages;
    return this;
  }

  public CreateResourceUsagesRequest addResourceUsagesItem(ResourceUsage resourceUsagesItem) {
    this.resourceUsages.add(resourceUsagesItem);
    return this;
  }

   /**
   * 资源使用用例的集合
   * @return resourceUsages
  **/
  @Schema(required = true, description = "资源使用用例的集合")
  public List<ResourceUsage> getResourceUsages() {
    return resourceUsages;
  }

  public void setResourceUsages(List<ResourceUsage> resourceUsages) {
    this.resourceUsages = resourceUsages;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateResourceUsagesRequest createResourceUsagesRequest = (CreateResourceUsagesRequest) o;
    return Objects.equals(this.resources, createResourceUsagesRequest.resources) &&
        Objects.equals(this.servicePsm, createResourceUsagesRequest.servicePsm) &&
        Objects.equals(this.resourceUsages, createResourceUsagesRequest.resourceUsages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resources, servicePsm, resourceUsages);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateResourceUsagesRequest {\n");
    
    sb.append("    resources: ").append(toIndentedString(resources)).append("\n");
    sb.append("    servicePsm: ").append(toIndentedString(servicePsm)).append("\n");
    sb.append("    resourceUsages: ").append(toIndentedString(resourceUsages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
