package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;

@Data
public class CreateTopUploadSegBySegIdReq {

    @Schema(description = "是否开启了在线服务")
    Boolean abaseEnabled;
    @Schema(description = "来源平台")
    private String sourcePlatform;
    @Schema(description = "分群名称", required = true)
    String name;

    @Schema(description = "排序，标签/属性 二选一", required = true)
    private OrderBy orderBy;
    @Deprecated
    @Schema(description = "取Top")
    private Long top;
    @Schema(description = "百分比,与分组数量二选一")
    private List<BigDecimal> percents;
    @Schema(description = "分组数量,与百分比二选一")
    private List<Long> parts;
    @Schema(description = "取第几个百分比/分组数量,基于0", required = true)
    private Integer sampleIndex;
    @Schema(description = "分群描述")
    String description;
    @Schema(description = "更新方式，默认一次性")
    private ScheduleType scheduleType;
    @Schema(description = "任务执行时间，00:00格式")
    private String scheduleTime;

}
