/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * DeleteResourceUsagesRequest
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class DeleteResourceUsagesRequest {
  /**
   * CDP资源类型
   */
  @JsonAdapter(ResourceTypeEnum.Adapter.class)
  public enum ResourceTypeEnum {
    UNKNOWN("Unknown"),
    SEGMENT("segment"),
    PROPERTY("property"),
    FEATURE("feature"),
    ID_MAPPING("id_mapping");

    private String value;

    ResourceTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ResourceTypeEnum fromValue(String input) {
      for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ResourceTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ResourceTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ResourceTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ResourceTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("resource_type")
  private ResourceTypeEnum resourceType = null;

  @SerializedName("resource_id")
  private Integer resourceId = null;

  @SerializedName("usage_id")
  private String usageId = null;

  @SerializedName("usage_type")
  private String usageType = null;

  @SerializedName("resource_usages_ids")
  private List<Integer> resourceUsagesIds = null;

  public DeleteResourceUsagesRequest resourceType(ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * CDP资源类型
   * @return resourceType
  **/
  @Schema(description = "CDP资源类型")
  public ResourceTypeEnum getResourceType() {
    return resourceType;
  }

  public void setResourceType(ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
  }

  public DeleteResourceUsagesRequest resourceId(Integer resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * CDP资源id
   * @return resourceId
  **/
  @Schema(description = "CDP资源id")
  public Integer getResourceId() {
    return resourceId;
  }

  public void setResourceId(Integer resourceId) {
    this.resourceId = resourceId;
  }

  public DeleteResourceUsagesRequest usageId(String usageId) {
    this.usageId = usageId;
    return this;
  }

   /**
   * 使用CDP资源的对应id
   * @return usageId
  **/
  @Schema(description = "使用CDP资源的对应id")
  public String getUsageId() {
    return usageId;
  }

  public void setUsageId(String usageId) {
    this.usageId = usageId;
  }

  public DeleteResourceUsagesRequest usageType(String usageType) {
    this.usageType = usageType;
    return this;
  }

   /**
   * 使用CDP资源的业务场景
   * @return usageType
  **/
  @Schema(description = "使用CDP资源的业务场景")
  public String getUsageType() {
    return usageType;
  }

  public void setUsageType(String usageType) {
    this.usageType = usageType;
  }

  public DeleteResourceUsagesRequest resourceUsagesIds(List<Integer> resourceUsagesIds) {
    this.resourceUsagesIds = resourceUsagesIds;
    return this;
  }

  public DeleteResourceUsagesRequest addResourceUsagesIdsItem(Integer resourceUsagesIdsItem) {
    if (this.resourceUsagesIds == null) {
      this.resourceUsagesIds = new ArrayList<Integer>();
    }
    this.resourceUsagesIds.add(resourceUsagesIdsItem);
    return this;
  }

   /**
   * 注册资源使用类型时返回的id
   * @return resourceUsagesIds
  **/
  @Schema(description = "注册资源使用类型时返回的id")
  public List<Integer> getResourceUsagesIds() {
    return resourceUsagesIds;
  }

  public void setResourceUsagesIds(List<Integer> resourceUsagesIds) {
    this.resourceUsagesIds = resourceUsagesIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeleteResourceUsagesRequest deleteResourceUsagesRequest = (DeleteResourceUsagesRequest) o;
    return Objects.equals(this.resourceType, deleteResourceUsagesRequest.resourceType) &&
        Objects.equals(this.resourceId, deleteResourceUsagesRequest.resourceId) &&
        Objects.equals(this.usageId, deleteResourceUsagesRequest.usageId) &&
        Objects.equals(this.usageType, deleteResourceUsagesRequest.usageType) &&
        Objects.equals(this.resourceUsagesIds, deleteResourceUsagesRequest.resourceUsagesIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceType, resourceId, usageId, usageType, resourceUsagesIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeleteResourceUsagesRequest {\n");
    
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    usageId: ").append(toIndentedString(usageId)).append("\n");
    sb.append("    usageType: ").append(toIndentedString(usageType)).append("\n");
    sb.append("    resourceUsagesIds: ").append(toIndentedString(resourceUsagesIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
