/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.InsightRecord;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * GraphSimpleResult
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class GraphSimpleResult {
  @SerializedName("graphName")
  private String graphName = null;

  /**
   * 图表类型，CustomAnalysis：自定义分析；CrossAnalysis：交叉分析
   */
  @JsonAdapter(GraphTypeEnum.Adapter.class)
  public enum GraphTypeEnum {
    UNKNOWN("Unknown"),
    CUSTOMANALYSIS("CustomAnalysis"),
    CROSSANALYSIS("CrossAnalysis"),
    PUBLICCUSTOMANALYSIS("PublicCustomAnalysis");

    private String value;

    GraphTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static GraphTypeEnum fromValue(String input) {
      for (GraphTypeEnum b : GraphTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<GraphTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final GraphTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public GraphTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return GraphTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("graphType")
  private GraphTypeEnum graphType = null;

  @SerializedName("graphData")
  private List<InsightRecord> graphData = null;

  public GraphSimpleResult graphName(String graphName) {
    this.graphName = graphName;
    return this;
  }

   /**
   * 图表名称
   * @return graphName
  **/
  @Schema(description = "图表名称")
  public String getGraphName() {
    return graphName;
  }

  public void setGraphName(String graphName) {
    this.graphName = graphName;
  }

  public GraphSimpleResult graphType(GraphTypeEnum graphType) {
    this.graphType = graphType;
    return this;
  }

   /**
   * 图表类型，CustomAnalysis：自定义分析；CrossAnalysis：交叉分析
   * @return graphType
  **/
  @Schema(description = "图表类型，CustomAnalysis：自定义分析；CrossAnalysis：交叉分析")
  public GraphTypeEnum getGraphType() {
    return graphType;
  }

  public void setGraphType(GraphTypeEnum graphType) {
    this.graphType = graphType;
  }

  public GraphSimpleResult graphData(List<InsightRecord> graphData) {
    this.graphData = graphData;
    return this;
  }

  public GraphSimpleResult addGraphDataItem(InsightRecord graphDataItem) {
    if (this.graphData == null) {
      this.graphData = new ArrayList<InsightRecord>();
    }
    this.graphData.add(graphDataItem);
    return this;
  }

   /**
   * 图表结果
   * @return graphData
  **/
  @Schema(description = "图表结果")
  public List<InsightRecord> getGraphData() {
    return graphData;
  }

  public void setGraphData(List<InsightRecord> graphData) {
    this.graphData = graphData;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GraphSimpleResult graphSimpleResult = (GraphSimpleResult) o;
    return Objects.equals(this.graphName, graphSimpleResult.graphName) &&
        Objects.equals(this.graphType, graphSimpleResult.graphType) &&
        Objects.equals(this.graphData, graphSimpleResult.graphData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(graphName, graphType, graphData);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GraphSimpleResult {\n");
    
    sb.append("    graphName: ").append(toIndentedString(graphName)).append("\n");
    sb.append("    graphType: ").append(toIndentedString(graphType)).append("\n");
    sb.append("    graphData: ").append(toIndentedString(graphData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
