/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.FilterObj;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * ListQueryReq
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class ListQueryReq {
  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("filterColumns")
  private List<FilterObj> filterColumns = null;

  @SerializedName("sortBy")
  private String sortBy = null;

  /**
   * 排序方式
   */
  @JsonAdapter(OrderEnum.Adapter.class)
  public enum OrderEnum {
    UNKNOWN("Unknown"),
    ASC("Asc"),
    DESC("Desc");

    private String value;

    OrderEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static OrderEnum fromValue(String input) {
      for (OrderEnum b : OrderEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<OrderEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OrderEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public OrderEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return OrderEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("order")
  private OrderEnum order = null;

  @SerializedName("platform")
  private String platform = null;

  @SerializedName("pageSize")
  private Integer pageSize = null;

  @SerializedName("current")
  private Integer current = null;

  /**
   * 权限模型
   */
  @JsonAdapter(PermissionValueEnum.Adapter.class)
  public enum PermissionValueEnum {
    UNKNOWN("Unknown"),
    ADMIN("admin"),
    READ_ROLE("read_role"),
    WRITE_ROLE("write_role"),
    DOWNLOAD_ROLE("download_role"),
    ACCESS("access"),
    WRITE_ROLE_PERIODIC("write_role_periodic"),
    WRITE_ROLE_MANUAL("write_role_manual");

    private String value;

    PermissionValueEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static PermissionValueEnum fromValue(String input) {
      for (PermissionValueEnum b : PermissionValueEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<PermissionValueEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PermissionValueEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public PermissionValueEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return PermissionValueEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("permissionValue")
  private PermissionValueEnum permissionValue = null;

  @SerializedName("effectAnalysisSource")
  private String effectAnalysisSource = null;

  @SerializedName("selfCreate")
  private Boolean selfCreate = null;

  @SerializedName("shared")
  private Boolean shared = null;

  @SerializedName("bookmark")
  private Boolean bookmark = null;

  public ListQueryReq subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * Get subjectId
   * @return subjectId
  **/
  @Schema(description = "")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public ListQueryReq filterColumns(List<FilterObj> filterColumns) {
    this.filterColumns = filterColumns;
    return this;
  }

  public ListQueryReq addFilterColumnsItem(FilterObj filterColumnsItem) {
    if (this.filterColumns == null) {
      this.filterColumns = new ArrayList<FilterObj>();
    }
    this.filterColumns.add(filterColumnsItem);
    return this;
  }

   /**
   * Get filterColumns
   * @return filterColumns
  **/
  @Schema(description = "")
  public List<FilterObj> getFilterColumns() {
    return filterColumns;
  }

  public void setFilterColumns(List<FilterObj> filterColumns) {
    this.filterColumns = filterColumns;
  }

  public ListQueryReq sortBy(String sortBy) {
    this.sortBy = sortBy;
    return this;
  }

   /**
   * 排序字段
   * @return sortBy
  **/
  @Schema(description = "排序字段")
  public String getSortBy() {
    return sortBy;
  }

  public void setSortBy(String sortBy) {
    this.sortBy = sortBy;
  }

  public ListQueryReq order(OrderEnum order) {
    this.order = order;
    return this;
  }

   /**
   * 排序方式
   * @return order
  **/
  @Schema(description = "排序方式")
  public OrderEnum getOrder() {
    return order;
  }

  public void setOrder(OrderEnum order) {
    this.order = order;
  }

  public ListQueryReq platform(String platform) {
    this.platform = platform;
    return this;
  }

   /**
   * 平台
   * @return platform
  **/
  @Schema(description = "平台")
  public String getPlatform() {
    return platform;
  }

  public void setPlatform(String platform) {
    this.platform = platform;
  }

  public ListQueryReq pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页大小
   * @return pageSize
  **/
  @Schema(description = "每页大小")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public ListQueryReq current(Integer current) {
    this.current = current;
    return this;
  }

   /**
   * 页码
   * @return current
  **/
  @Schema(description = "页码")
  public Integer getCurrent() {
    return current;
  }

  public void setCurrent(Integer current) {
    this.current = current;
  }

  public ListQueryReq permissionValue(PermissionValueEnum permissionValue) {
    this.permissionValue = permissionValue;
    return this;
  }

   /**
   * 权限模型
   * @return permissionValue
  **/
  @Schema(description = "权限模型")
  public PermissionValueEnum getPermissionValue() {
    return permissionValue;
  }

  public void setPermissionValue(PermissionValueEnum permissionValue) {
    this.permissionValue = permissionValue;
  }

  public ListQueryReq effectAnalysisSource(String effectAnalysisSource) {
    this.effectAnalysisSource = effectAnalysisSource;
    return this;
  }

   /**
   * 效果分析数据源过滤，支持为空，如果传入值，则会过滤非传入效果分析数据源的预置指标
   * @return effectAnalysisSource
  **/
  @Schema(description = "效果分析数据源过滤，支持为空，如果传入值，则会过滤非传入效果分析数据源的预置指标")
  public String getEffectAnalysisSource() {
    return effectAnalysisSource;
  }

  public void setEffectAnalysisSource(String effectAnalysisSource) {
    this.effectAnalysisSource = effectAnalysisSource;
  }

  public ListQueryReq selfCreate(Boolean selfCreate) {
    this.selfCreate = selfCreate;
    return this;
  }

   /**
   * 过滤出我创建的,可选，与shared或关系，默认false
   * @return selfCreate
  **/
  @Schema(description = "过滤出我创建的,可选，与shared或关系，默认false")
  public Boolean isSelfCreate() {
    return selfCreate;
  }

  public void setSelfCreate(Boolean selfCreate) {
    this.selfCreate = selfCreate;
  }

  public ListQueryReq shared(Boolean shared) {
    this.shared = shared;
    return this;
  }

   /**
   * 过滤出授权给我的,可选，与selfCreate或关系，默认false
   * @return shared
  **/
  @Schema(description = "过滤出授权给我的,可选，与selfCreate或关系，默认false")
  public Boolean isShared() {
    return shared;
  }

  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  public ListQueryReq bookmark(Boolean bookmark) {
    this.bookmark = bookmark;
    return this;
  }

   /**
   * 只查看收藏的,可选，与上述两个且关系，默认false
   * @return bookmark
  **/
  @Schema(description = "只查看收藏的,可选，与上述两个且关系，默认false")
  public Boolean isBookmark() {
    return bookmark;
  }

  public void setBookmark(Boolean bookmark) {
    this.bookmark = bookmark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListQueryReq listQueryReq = (ListQueryReq) o;
    return Objects.equals(this.subjectId, listQueryReq.subjectId) &&
        Objects.equals(this.filterColumns, listQueryReq.filterColumns) &&
        Objects.equals(this.sortBy, listQueryReq.sortBy) &&
        Objects.equals(this.order, listQueryReq.order) &&
        Objects.equals(this.platform, listQueryReq.platform) &&
        Objects.equals(this.pageSize, listQueryReq.pageSize) &&
        Objects.equals(this.current, listQueryReq.current) &&
        Objects.equals(this.permissionValue, listQueryReq.permissionValue) &&
        Objects.equals(this.effectAnalysisSource, listQueryReq.effectAnalysisSource) &&
        Objects.equals(this.selfCreate, listQueryReq.selfCreate) &&
        Objects.equals(this.shared, listQueryReq.shared) &&
        Objects.equals(this.bookmark, listQueryReq.bookmark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subjectId, filterColumns, sortBy, order, platform, pageSize, current, permissionValue, effectAnalysisSource, selfCreate, shared, bookmark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListQueryReq {\n");
    
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    filterColumns: ").append(toIndentedString(filterColumns)).append("\n");
    sb.append("    sortBy: ").append(toIndentedString(sortBy)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    current: ").append(toIndentedString(current)).append("\n");
    sb.append("    permissionValue: ").append(toIndentedString(permissionValue)).append("\n");
    sb.append("    effectAnalysisSource: ").append(toIndentedString(effectAnalysisSource)).append("\n");
    sb.append("    selfCreate: ").append(toIndentedString(selfCreate)).append("\n");
    sb.append("    shared: ").append(toIndentedString(shared)).append("\n");
    sb.append("    bookmark: ").append(toIndentedString(bookmark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
