package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Data;

@Data
@Schema(description = "人工分群详情")
public class ManualSegInfo {

    @Schema(description = "分群id", required = true)
    Long id;
    @Schema(description = "分群名称", required = true)
    String name;
    @Schema(description = "分群创建人", required = true)
    String createdBy;
    @Schema(description = "分群实体类型code", required = true)
    String idType;
    @Schema(description = "分群实体类型名称", required = true)
    String idTypeName;
    @Schema(description = "分群结果", required = true)
    LegacySegResult result;
    @Schema(description = "分群类型", required = true)
    SegmentType segType;
    @Schema(description = "是否开启了在线服务")
    Boolean abaseEnabled;
    @Schema(description = "分群详情")
    ManualSegmentExtraCondition detail;

    @Schema(description = "分群分组详情")
    List<LegacySegGroupInfo> groupInf;
}
