package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Data;

@Data
@Schema(description = "修改人工分群")
public class ModifyManualSegmentReq {

    @Schema(description = "人群ID")
    List<Condition> ids;

    public static ModifyManualSegmentReq create(Set<String> ids, boolean addOrRemove) {
        ModifyManualSegmentReq req = new ModifyManualSegmentReq();
        List<Condition> conditions = new ArrayList<>();
        conditions.add(Condition.newCondition(ids, addOrRemove));
        req.setIds(conditions);
        return req;
    }

    @Data
    public static class Condition {

        @Schema(description = "组合ID")
        Set<String> id;
        @Schema(description = "新增(true）/删除（false)")
        Boolean isIn;

        public static Condition newCondition(Set<String> ids, boolean addOrRemove) {
            Condition condition = new Condition();
            condition.setId(ids);
            condition.setIsIn(addOrRemove);
            return condition;
        }
    }
}

