/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.IdTypeResponse;
import code.byted.cdp.model.SegGroupResponse;
import code.byted.cdp.model.SegInnerResponse;
import code.byted.cdp.model.SegmentCondition;
import code.byted.cdp.model.SegmentTaskConf;
import code.byted.cdp.model.SegmentTaskResult;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * SegInnerResponse
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class SegInnerResponse {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("condition")
  private SegmentCondition condition = null;

  @SerializedName("taskConf")
  private SegmentTaskConf taskConf = null;

  @SerializedName("taskResults")
  private List<SegmentTaskResult> taskResults = new ArrayList<SegmentTaskResult>();

  @SerializedName("lastSuccessTaskResults")
  private List<SegmentTaskResult> lastSuccessTaskResults = new ArrayList<SegmentTaskResult>();

  @SerializedName("count")
  private Long count = null;

  @SerializedName("exportAt")
  private String exportAt = null;

  @SerializedName("createdBy")
  private String createdBy = null;

  @SerializedName("createTime")
  private String createTime = null;

  @SerializedName("updatedBy")
  private String updatedBy = null;

  @SerializedName("updateTime")
  private String updateTime = null;

  @SerializedName("idType")
  private IdTypeResponse idType = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  @SerializedName("sourceModule")
  private String sourceModule = null;

  @SerializedName("deletedFlag")
  private Integer deletedFlag = null;

  /**
   * 分群类型:
   */
  @JsonAdapter(SegTypeEnum.Adapter.class)
  public enum SegTypeEnum {
    UNKNOWN("Unknown"),
    CONDITIONAL("Conditional"),
    UPLOADED("Uploaded"),
    ABI("ABI"),
    LOOKALIKE("Lookalike"),
    CHILDSEG("ChildSeg"),
    PRIVATETRANSTOPUBLIC("PrivateTransToPublic"),
    SUBJECTTRANS("SubjectTrans"),
    FEATURERECOMMENDATION("FeatureRecommendation"),
    INSIGHTEXPORT("InsightExport"),
    INSIGHTEXPORTV2("InsightExportV2"),
    PUBLICCONDITIONAL("PublicConditional"),
    FINDER("Finder"),
    PUBLICMODELRESULT("PublicModelResult"),
    PUBLICUPLOADED("PublicUploaded"),
    MODEL("Model"),
    PUBLICLOOKALIKE("PublicLookalike"),
    PRIVATELOOKALIKE("PrivateLookalike"),
    SQLEXPORT("SqlExport"),
    REALTIMECONDITIONAL("RealtimeConditional"),
    PRIVATECLUSTER("PrivateCluster"),
    PRIVATECLUSTERCHILD("PrivateClusterChild"),
    PUBLICCLUSTER("PublicCluster"),
    PUBLICCLUSTERCHILD("PublicClusterChild"),
    MANUALREALTIME("ManualRealtime"),
    MULTISUBJECTCONDITIONAL("MultiSubjectConditional");

    private String value;

    SegTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SegTypeEnum fromValue(String input) {
      for (SegTypeEnum b : SegTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SegTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SegTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SegTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SegTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("segType")
  private SegTypeEnum segType = null;

  @SerializedName("tenantId")
  private Integer tenantId = null;

  @SerializedName("bdbTaskId")
  private Long bdbTaskId = null;

  @SerializedName("childSegments")
  private List<SegInnerResponse> childSegments = null;

  @SerializedName("readable")
  private Boolean readable = null;

  @SerializedName("isHidden")
  private Boolean isHidden = null;

  @SerializedName("publicSegId")
  private Integer publicSegId = null;

  @SerializedName("groupInfo")
  private List<SegGroupResponse> groupInfo = null;

  @SerializedName("onlineServiceTaskId")
  private Long onlineServiceTaskId = null;

  public SegInnerResponse id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 分群id
   * @return id
  **/
  @Schema(required = true, description = "分群id")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public SegInnerResponse name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 分群名称
   * @return name
  **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SegInnerResponse desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 分群描述
   * @return desc
  **/
  @Schema(description = "分群描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public SegInnerResponse condition(SegmentCondition condition) {
    this.condition = condition;
    return this;
  }

   /**
   * Get condition
   * @return condition
  **/
  @Schema(description = "")
  public SegmentCondition getCondition() {
    return condition;
  }

  public void setCondition(SegmentCondition condition) {
    this.condition = condition;
  }

  public SegInnerResponse taskConf(SegmentTaskConf taskConf) {
    this.taskConf = taskConf;
    return this;
  }

   /**
   * Get taskConf
   * @return taskConf
  **/
  @Schema(required = true, description = "")
  public SegmentTaskConf getTaskConf() {
    return taskConf;
  }

  public void setTaskConf(SegmentTaskConf taskConf) {
    this.taskConf = taskConf;
  }

  public SegInnerResponse taskResults(List<SegmentTaskResult> taskResults) {
    this.taskResults = taskResults;
    return this;
  }

  public SegInnerResponse addTaskResultsItem(SegmentTaskResult taskResultsItem) {
    this.taskResults.add(taskResultsItem);
    return this;
  }

   /**
   * 分群最新任务状态
   * @return taskResults
  **/
  @Schema(required = true, description = "分群最新任务状态")
  public List<SegmentTaskResult> getTaskResults() {
    return taskResults;
  }

  public void setTaskResults(List<SegmentTaskResult> taskResults) {
    this.taskResults = taskResults;
  }

  public SegInnerResponse lastSuccessTaskResults(List<SegmentTaskResult> lastSuccessTaskResults) {
    this.lastSuccessTaskResults = lastSuccessTaskResults;
    return this;
  }

  public SegInnerResponse addLastSuccessTaskResultsItem(SegmentTaskResult lastSuccessTaskResultsItem) {
    this.lastSuccessTaskResults.add(lastSuccessTaskResultsItem);
    return this;
  }

   /**
   * 分群最新成功任务状态
   * @return lastSuccessTaskResults
  **/
  @Schema(required = true, description = "分群最新成功任务状态")
  public List<SegmentTaskResult> getLastSuccessTaskResults() {
    return lastSuccessTaskResults;
  }

  public void setLastSuccessTaskResults(List<SegmentTaskResult> lastSuccessTaskResults) {
    this.lastSuccessTaskResults = lastSuccessTaskResults;
  }

  public SegInnerResponse count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * 人群数量
   * @return count
  **/
  @Schema(description = "人群数量")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public SegInnerResponse exportAt(String exportAt) {
    this.exportAt = exportAt;
    return this;
  }

   /**
   * 分群导出时间
   * @return exportAt
  **/
  @Schema(description = "分群导出时间")
  public String getExportAt() {
    return exportAt;
  }

  public void setExportAt(String exportAt) {
    this.exportAt = exportAt;
  }

  public SegInnerResponse createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 创建人
   * @return createdBy
  **/
  @Schema(required = true, description = "创建人")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public SegInnerResponse createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建人
   * @return createTime
  **/
  @Schema(required = true, description = "创建人")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public SegInnerResponse updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * 编辑人
   * @return updatedBy
  **/
  @Schema(required = true, description = "编辑人")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public SegInnerResponse updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 编辑时间
   * @return updateTime
  **/
  @Schema(required = true, description = "编辑时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public SegInnerResponse idType(IdTypeResponse idType) {
    this.idType = idType;
    return this;
  }

   /**
   * Get idType
   * @return idType
  **/
  @Schema(required = true, description = "")
  public IdTypeResponse getIdType() {
    return idType;
  }

  public void setIdType(IdTypeResponse idType) {
    this.idType = idType;
  }

  public SegInnerResponse sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

   /**
   * 来源平台
   * @return sourcePlatform
  **/
  @Schema(description = "来源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  public SegInnerResponse sourceModule(String sourceModule) {
    this.sourceModule = sourceModule;
    return this;
  }

   /**
   * 来源模块
   * @return sourceModule
  **/
  @Schema(description = "来源模块")
  public String getSourceModule() {
    return sourceModule;
  }

  public void setSourceModule(String sourceModule) {
    this.sourceModule = sourceModule;
  }

  public SegInnerResponse deletedFlag(Integer deletedFlag) {
    this.deletedFlag = deletedFlag;
    return this;
  }

   /**
   * 软删除标记，0存在，1删除
   * @return deletedFlag
  **/
  @Schema(required = true, description = "软删除标记，0存在，1删除")
  public Integer getDeletedFlag() {
    return deletedFlag;
  }

  public void setDeletedFlag(Integer deletedFlag) {
    this.deletedFlag = deletedFlag;
  }

  public SegInnerResponse segType(SegTypeEnum segType) {
    this.segType = segType;
    return this;
  }

   /**
   * 分群类型:
   * @return segType
  **/
  @Schema(required = true, description = "分群类型:")
  public SegTypeEnum getSegType() {
    return segType;
  }

  public void setSegType(SegTypeEnum segType) {
    this.segType = segType;
  }

  public SegInnerResponse tenantId(Integer tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @Schema(required = true, description = "租户id")
  public Integer getTenantId() {
    return tenantId;
  }

  public void setTenantId(Integer tenantId) {
    this.tenantId = tenantId;
  }

  public SegInnerResponse bdbTaskId(Long bdbTaskId) {
    this.bdbTaskId = bdbTaskId;
    return this;
  }

   /**
   * bdb任务id
   * @return bdbTaskId
  **/
  @Schema(required = true, description = "bdb任务id")
  public Long getBdbTaskId() {
    return bdbTaskId;
  }

  public void setBdbTaskId(Long bdbTaskId) {
    this.bdbTaskId = bdbTaskId;
  }

  public SegInnerResponse childSegments(List<SegInnerResponse> childSegments) {
    this.childSegments = childSegments;
    return this;
  }

  public SegInnerResponse addChildSegmentsItem(SegInnerResponse childSegmentsItem) {
    if (this.childSegments == null) {
      this.childSegments = new ArrayList<SegInnerResponse>();
    }
    this.childSegments.add(childSegmentsItem);
    return this;
  }

   /**
   * 子包信息
   * @return childSegments
  **/
  @Schema(description = "子包信息")
  public List<SegInnerResponse> getChildSegments() {
    return childSegments;
  }

  public void setChildSegments(List<SegInnerResponse> childSegments) {
    this.childSegments = childSegments;
  }

  public SegInnerResponse readable(Boolean readable) {
    this.readable = readable;
    return this;
  }

   /**
   * 是否可读
   * @return readable
  **/
  @Schema(required = true, description = "是否可读")
  public Boolean isReadable() {
    return readable;
  }

  public void setReadable(Boolean readable) {
    this.readable = readable;
  }

  public SegInnerResponse isHidden(Boolean isHidden) {
    this.isHidden = isHidden;
    return this;
  }

   /**
   * 是否隐藏(GMP人群可能会隐藏)
   * @return isHidden
  **/
  @Schema(required = true, description = "是否隐藏(GMP人群可能会隐藏)")
  public Boolean isIsHidden() {
    return isHidden;
  }

  public void setIsHidden(Boolean isHidden) {
    this.isHidden = isHidden;
  }

  public SegInnerResponse publicSegId(Integer publicSegId) {
    this.publicSegId = publicSegId;
    return this;
  }

   /**
   * 私转公对应的公域人群包id
   * @return publicSegId
  **/
  @Schema(description = "私转公对应的公域人群包id")
  public Integer getPublicSegId() {
    return publicSegId;
  }

  public void setPublicSegId(Integer publicSegId) {
    this.publicSegId = publicSegId;
  }

  public SegInnerResponse groupInfo(List<SegGroupResponse> groupInfo) {
    this.groupInfo = groupInfo;
    return this;
  }

  public SegInnerResponse addGroupInfoItem(SegGroupResponse groupInfoItem) {
    if (this.groupInfo == null) {
      this.groupInfo = new ArrayList<SegGroupResponse>();
    }
    this.groupInfo.add(groupInfoItem);
    return this;
  }

   /**
   * Get groupInfo
   * @return groupInfo
  **/
  @Schema(description = "")
  public List<SegGroupResponse> getGroupInfo() {
    return groupInfo;
  }

  public void setGroupInfo(List<SegGroupResponse> groupInfo) {
    this.groupInfo = groupInfo;
  }

  public SegInnerResponse onlineServiceTaskId(Long onlineServiceTaskId) {
    this.onlineServiceTaskId = onlineServiceTaskId;
    return this;
  }

   /**
   * 在线导入任务id
   * @return onlineServiceTaskId
  **/
  @Schema(description = "在线导入任务id")
  public Long getOnlineServiceTaskId() {
    return onlineServiceTaskId;
  }

  public void setOnlineServiceTaskId(Long onlineServiceTaskId) {
    this.onlineServiceTaskId = onlineServiceTaskId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SegInnerResponse segInnerResponse = (SegInnerResponse) o;
    return Objects.equals(this.id, segInnerResponse.id) &&
        Objects.equals(this.name, segInnerResponse.name) &&
        Objects.equals(this.desc, segInnerResponse.desc) &&
        Objects.equals(this.condition, segInnerResponse.condition) &&
        Objects.equals(this.taskConf, segInnerResponse.taskConf) &&
        Objects.equals(this.taskResults, segInnerResponse.taskResults) &&
        Objects.equals(this.lastSuccessTaskResults, segInnerResponse.lastSuccessTaskResults) &&
        Objects.equals(this.count, segInnerResponse.count) &&
        Objects.equals(this.exportAt, segInnerResponse.exportAt) &&
        Objects.equals(this.createdBy, segInnerResponse.createdBy) &&
        Objects.equals(this.createTime, segInnerResponse.createTime) &&
        Objects.equals(this.updatedBy, segInnerResponse.updatedBy) &&
        Objects.equals(this.updateTime, segInnerResponse.updateTime) &&
        Objects.equals(this.idType, segInnerResponse.idType) &&
        Objects.equals(this.sourcePlatform, segInnerResponse.sourcePlatform) &&
        Objects.equals(this.sourceModule, segInnerResponse.sourceModule) &&
        Objects.equals(this.deletedFlag, segInnerResponse.deletedFlag) &&
        Objects.equals(this.segType, segInnerResponse.segType) &&
        Objects.equals(this.tenantId, segInnerResponse.tenantId) &&
        Objects.equals(this.bdbTaskId, segInnerResponse.bdbTaskId) &&
        Objects.equals(this.childSegments, segInnerResponse.childSegments) &&
        Objects.equals(this.readable, segInnerResponse.readable) &&
        Objects.equals(this.isHidden, segInnerResponse.isHidden) &&
        Objects.equals(this.publicSegId, segInnerResponse.publicSegId) &&
        Objects.equals(this.groupInfo, segInnerResponse.groupInfo) &&
        Objects.equals(this.onlineServiceTaskId, segInnerResponse.onlineServiceTaskId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, desc, condition, taskConf, taskResults, lastSuccessTaskResults, count, exportAt, createdBy, createTime, updatedBy, updateTime, idType, sourcePlatform, sourceModule, deletedFlag, segType, tenantId, bdbTaskId, childSegments, readable, isHidden, publicSegId, groupInfo, onlineServiceTaskId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SegInnerResponse {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    condition: ").append(toIndentedString(condition)).append("\n");
    sb.append("    taskConf: ").append(toIndentedString(taskConf)).append("\n");
    sb.append("    taskResults: ").append(toIndentedString(taskResults)).append("\n");
    sb.append("    lastSuccessTaskResults: ").append(toIndentedString(lastSuccessTaskResults)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    exportAt: ").append(toIndentedString(exportAt)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    idType: ").append(toIndentedString(idType)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("    sourceModule: ").append(toIndentedString(sourceModule)).append("\n");
    sb.append("    deletedFlag: ").append(toIndentedString(deletedFlag)).append("\n");
    sb.append("    segType: ").append(toIndentedString(segType)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    bdbTaskId: ").append(toIndentedString(bdbTaskId)).append("\n");
    sb.append("    childSegments: ").append(toIndentedString(childSegments)).append("\n");
    sb.append("    readable: ").append(toIndentedString(readable)).append("\n");
    sb.append("    isHidden: ").append(toIndentedString(isHidden)).append("\n");
    sb.append("    publicSegId: ").append(toIndentedString(publicSegId)).append("\n");
    sb.append("    groupInfo: ").append(toIndentedString(groupInfo)).append("\n");
    sb.append("    onlineServiceTaskId: ").append(toIndentedString(onlineServiceTaskId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
