/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.IdType;
import code.byted.cdp.model.JsonNode;
import code.byted.cdp.model.Segmentation;
import code.byted.cdp.model.TaskConf;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * Segmentation
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class Segmentation {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("count")
  private Long count = null;

  @SerializedName("idType")
  private IdType idType = null;

  @SerializedName("taskConf")
  private TaskConf taskConf = null;

  @SerializedName("condition")
  private JsonNode condition = null;

  @SerializedName("createdBy")
  private String createdBy = null;

  @SerializedName("updatedBy")
  private String updatedBy = null;

  @SerializedName("createTime")
  private String createTime = null;

  @SerializedName("updateTime")
  private String updateTime = null;

  @SerializedName("segType")
  private String segType = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  @SerializedName("sourceModule")
  private String sourceModule = null;

  @SerializedName("deletedFlag")
  private Integer deletedFlag = null;

  @SerializedName("isHidden")
  private Boolean isHidden = null;

  @SerializedName("readable")
  private Boolean readable = null;

  @SerializedName("childSegments")
  private List<Segmentation> childSegments = null;

  public Segmentation id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 人群id
   * @return id
  **/
  @Schema(description = "人群id")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public Segmentation desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 人群描述
   * @return desc
  **/
  @Schema(description = "人群描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public Segmentation name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 人群名称
   * @return name
  **/
  @Schema(description = "人群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Segmentation count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * 人群数量
   * @return count
  **/
  @Schema(description = "人群数量")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public Segmentation idType(IdType idType) {
    this.idType = idType;
    return this;
  }

   /**
   * Get idType
   * @return idType
  **/
  @Schema(description = "")
  public IdType getIdType() {
    return idType;
  }

  public void setIdType(IdType idType) {
    this.idType = idType;
  }

  public Segmentation taskConf(TaskConf taskConf) {
    this.taskConf = taskConf;
    return this;
  }

   /**
   * Get taskConf
   * @return taskConf
  **/
  @Schema(description = "")
  public TaskConf getTaskConf() {
    return taskConf;
  }

  public void setTaskConf(TaskConf taskConf) {
    this.taskConf = taskConf;
  }

  public Segmentation condition(JsonNode condition) {
    this.condition = condition;
    return this;
  }

   /**
   * Get condition
   * @return condition
  **/
  @Schema(description = "")
  public JsonNode getCondition() {
    return condition;
  }

  public void setCondition(JsonNode condition) {
    this.condition = condition;
  }

  public Segmentation createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 创建人
   * @return createdBy
  **/
  @Schema(description = "创建人")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public Segmentation updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * 最近更新人
   * @return updatedBy
  **/
  @Schema(description = "最近更新人")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public Segmentation createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @Schema(description = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public Segmentation updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 最近更新时间
   * @return updateTime
  **/
  @Schema(description = "最近更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public Segmentation segType(String segType) {
    this.segType = segType;
    return this;
  }

   /**
   * 人群类型
   * @return segType
  **/
  @Schema(description = "人群类型")
  public String getSegType() {
    return segType;
  }

  public void setSegType(String segType) {
    this.segType = segType;
  }

  public Segmentation sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

   /**
   * 来源平台
   * @return sourcePlatform
  **/
  @Schema(description = "来源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  public Segmentation sourceModule(String sourceModule) {
    this.sourceModule = sourceModule;
    return this;
  }

   /**
   * 来源模块
   * @return sourceModule
  **/
  @Schema(description = "来源模块")
  public String getSourceModule() {
    return sourceModule;
  }

  public void setSourceModule(String sourceModule) {
    this.sourceModule = sourceModule;
  }

  public Segmentation deletedFlag(Integer deletedFlag) {
    this.deletedFlag = deletedFlag;
    return this;
  }

   /**
   * 删除标识
   * @return deletedFlag
  **/
  @Schema(description = "删除标识")
  public Integer getDeletedFlag() {
    return deletedFlag;
  }

  public void setDeletedFlag(Integer deletedFlag) {
    this.deletedFlag = deletedFlag;
  }

  public Segmentation isHidden(Boolean isHidden) {
    this.isHidden = isHidden;
    return this;
  }

   /**
   * 是否隐藏(GMP人群可能会隐藏)
   * @return isHidden
  **/
  @Schema(description = "是否隐藏(GMP人群可能会隐藏)")
  public Boolean isIsHidden() {
    return isHidden;
  }

  public void setIsHidden(Boolean isHidden) {
    this.isHidden = isHidden;
  }

  public Segmentation readable(Boolean readable) {
    this.readable = readable;
    return this;
  }

   /**
   * 是否可读
   * @return readable
  **/
  @Schema(description = "是否可读")
  public Boolean isReadable() {
    return readable;
  }

  public void setReadable(Boolean readable) {
    this.readable = readable;
  }

  public Segmentation childSegments(List<Segmentation> childSegments) {
    this.childSegments = childSegments;
    return this;
  }

  public Segmentation addChildSegmentsItem(Segmentation childSegmentsItem) {
    if (this.childSegments == null) {
      this.childSegments = new ArrayList<Segmentation>();
    }
    this.childSegments.add(childSegmentsItem);
    return this;
  }

   /**
   * 子包
   * @return childSegments
  **/
  @Schema(description = "子包")
  public List<Segmentation> getChildSegments() {
    return childSegments;
  }

  public void setChildSegments(List<Segmentation> childSegments) {
    this.childSegments = childSegments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Segmentation segmentation = (Segmentation) o;
    return Objects.equals(this.id, segmentation.id) &&
        Objects.equals(this.desc, segmentation.desc) &&
        Objects.equals(this.name, segmentation.name) &&
        Objects.equals(this.count, segmentation.count) &&
        Objects.equals(this.idType, segmentation.idType) &&
        Objects.equals(this.taskConf, segmentation.taskConf) &&
        Objects.equals(this.condition, segmentation.condition) &&
        Objects.equals(this.createdBy, segmentation.createdBy) &&
        Objects.equals(this.updatedBy, segmentation.updatedBy) &&
        Objects.equals(this.createTime, segmentation.createTime) &&
        Objects.equals(this.updateTime, segmentation.updateTime) &&
        Objects.equals(this.segType, segmentation.segType) &&
        Objects.equals(this.sourcePlatform, segmentation.sourcePlatform) &&
        Objects.equals(this.sourceModule, segmentation.sourceModule) &&
        Objects.equals(this.deletedFlag, segmentation.deletedFlag) &&
        Objects.equals(this.isHidden, segmentation.isHidden) &&
        Objects.equals(this.readable, segmentation.readable) &&
        Objects.equals(this.childSegments, segmentation.childSegments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, desc, name, count, idType, taskConf, condition, createdBy, updatedBy, createTime, updateTime, segType, sourcePlatform, sourceModule, deletedFlag, isHidden, readable, childSegments);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Segmentation {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    idType: ").append(toIndentedString(idType)).append("\n");
    sb.append("    taskConf: ").append(toIndentedString(taskConf)).append("\n");
    sb.append("    condition: ").append(toIndentedString(condition)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    segType: ").append(toIndentedString(segType)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("    sourceModule: ").append(toIndentedString(sourceModule)).append("\n");
    sb.append("    deletedFlag: ").append(toIndentedString(deletedFlag)).append("\n");
    sb.append("    isHidden: ").append(toIndentedString(isHidden)).append("\n");
    sb.append("    readable: ").append(toIndentedString(readable)).append("\n");
    sb.append("    childSegments: ").append(toIndentedString(childSegments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
