/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.GetBusinessIdentityReq;
import code.byted.cdp.model.GetBusinessIdentityResp;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.AuthModulePermissionResp;
import code.byted.cdp.model.AuthUserAttributeUploadRequest;
import code.byted.cdp.model.AuthUserAttributeUploadResp;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthApi {
    private ApiClient apiClient;

    public AuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for modulePermission
     * @param xTenant 项目id (required)
     * @param filterModule 过滤模块 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call modulePermissionCall(Integer xTenant, String filterModule, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (filterModule != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("filter_module", filterModule));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","modulePermission"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call modulePermissionValidateBeforeCall(Integer xTenant, String filterModule, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling modulePermission(Async)");
        }

        com.squareup.okhttp.Call call = modulePermissionCall(xTenant, filterModule, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询用户模块权限
     * 查询用户拥有的模块权限列表
     * @param xTenant 项目id (required)
     * @param filterModule 过滤模块 (optional)
     * @return AuthModulePermissionResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AuthModulePermissionResp modulePermission(Integer xTenant, String filterModule) throws ApiException {
        ApiResponse<AuthModulePermissionResp> resp = modulePermissionWithHttpInfo(xTenant, filterModule);
        return resp.getData();
    }


    /**
     * 查询用户模块权限
     * 查询用户拥有的模块权限列表
     * @param xTenant 项目id (required)
     * @param filterModule 过滤模块 (optional)
     * @return ApiResponse&lt;AuthModulePermissionResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AuthModulePermissionResp> modulePermissionWithHttpInfo(Integer xTenant, String filterModule) throws ApiException {
        com.squareup.okhttp.Call call = modulePermissionValidateBeforeCall(xTenant, filterModule, null, null);
        Type localVarReturnType = new TypeToken<AuthModulePermissionResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询用户模块权限 (asynchronously)
     * 查询用户拥有的模块权限列表
     * @param xTenant 项目id (required)
     * @param filterModule 过滤模块 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call modulePermissionAsync(Integer xTenant, String filterModule, final ApiCallback<AuthModulePermissionResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = modulePermissionValidateBeforeCall(xTenant, filterModule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AuthModulePermissionResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for userAttributeUpload
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call userAttributeUploadCall(AuthUserAttributeUploadRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","userAttributeUpload"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call userAttributeUploadValidateBeforeCall(AuthUserAttributeUploadRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling userAttributeUpload(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling userAttributeUpload(Async)");
        }

        com.squareup.okhttp.Call call = userAttributeUploadCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传用户标识
     * 上传用户标识, 支持多个用户, 多个标识设置
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return AuthUserAttributeUploadResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AuthUserAttributeUploadResp userAttributeUpload(AuthUserAttributeUploadRequest body, Integer xTenant) throws ApiException {
        ApiResponse<AuthUserAttributeUploadResp> resp = userAttributeUploadWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 上传用户标识
     * 上传用户标识, 支持多个用户, 多个标识设置
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;AuthUserAttributeUploadResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AuthUserAttributeUploadResp> userAttributeUploadWithHttpInfo(AuthUserAttributeUploadRequest body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = userAttributeUploadValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<AuthUserAttributeUploadResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传用户标识 (asynchronously)
     * 上传用户标识, 支持多个用户, 多个标识设置
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call userAttributeUploadAsync(AuthUserAttributeUploadRequest body, Integer xTenant, final ApiCallback<AuthUserAttributeUploadResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = userAttributeUploadValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AuthUserAttributeUploadResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * 获取用户有权限的资源业务id列表
     * 获取用户有权限的资源业务id列表（可查询拥有有权限的项目id）
     * @param req  (required)
     * @param xTenant 项目id (required)
     * @return GetBusinessIdentityResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetBusinessIdentityResp getBusinessIdentity(GetBusinessIdentityReq req, Integer xTenant) throws ApiException {
        ApiResponse<GetBusinessIdentityResp> resp = getBusinessIdentityWithHttpInfo(req, xTenant);
        return resp.getData();
    }
    private ApiResponse<GetBusinessIdentityResp> getBusinessIdentityWithHttpInfo(GetBusinessIdentityReq req, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getBusinessIdentityValidateBeforeCall(req, xTenant, null, null);
        Type localVarReturnType = new TypeToken<GetBusinessIdentityResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBusinessIdentityValidateBeforeCall(GetBusinessIdentityReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling userAttributeUpload(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling userAttributeUpload(Async)");
        }

        com.squareup.okhttp.Call call = getBusinessIdentityCall(body, xTenant, progressListener, progressRequestListener);
        return call;

    }
    /**
     * Build call for userAttributeUpload
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    private com.squareup.okhttp.Call getBusinessIdentityCall(GetBusinessIdentityReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTmpBusinessIdentity"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-09-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }



}
