/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.CommonListLabelMetaInfo;
import code.byted.cdp.model.CommonListObject;
import code.byted.cdp.model.CommonString;
import code.byted.cdp.model.LabelQueryRequest;
import code.byted.cdp.model.RealtimeTagReq;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LabelOpenApiApi {
    private ApiClient apiClient;

    public LabelOpenApiApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LabelOpenApiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteRealtimeTagData
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRealtimeTagDataCall(Integer baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tagId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tagId", tagId));

        localVarQueryParams.add(new Pair("baseId", baseId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteRealtimeTagData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRealtimeTagDataValidateBeforeCall(Integer baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'baseId' is set
        if (baseId == null) {
            throw new ApiException("Missing the required parameter 'baseId' when calling deleteRealtimeTagData(Async)");
        }
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling deleteRealtimeTagData(Async)");
        }

        com.squareup.okhttp.Call call = deleteRealtimeTagDataCall(baseId, tagId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除某个用户身上的人工标签
     * 删除某个用户身上的人工标签，该接口可替换接口【删除某个用户身上的人工标签】
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @return CommonString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonString deleteRealtimeTagData(Integer baseId, Integer tagId) throws ApiException {
        ApiResponse<CommonString> resp = deleteRealtimeTagDataWithHttpInfo(baseId, tagId);
        return resp.getData();
    }


    /**
     * 删除某个用户身上的人工标签
     * 删除某个用户身上的人工标签，该接口可替换接口【删除某个用户身上的人工标签】
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @return ApiResponse&lt;CommonString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonString> deleteRealtimeTagDataWithHttpInfo(Integer baseId, Integer tagId) throws ApiException {
        com.squareup.okhttp.Call call = deleteRealtimeTagDataValidateBeforeCall(baseId, tagId, null, null);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除某个用户身上的人工标签 (asynchronously)
     * 删除某个用户身上的人工标签，该接口可替换接口【删除某个用户身上的人工标签】
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRealtimeTagDataAsync(Integer baseId, Integer tagId, final ApiCallback<CommonString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = deleteRealtimeTagDataValidateBeforeCall(baseId, tagId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getLabelValues
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelValuesCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (labelId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("labelId", labelId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabelValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelValuesValidateBeforeCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'labelId' is set
        if (labelId == null) {
            throw new ApiException("Missing the required parameter 'labelId' when calling getLabelValues(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelValues(Async)");
        }

        com.squareup.okhttp.Call call = getLabelValuesCall(labelId, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取某个标签的取值
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @return CommonListObject
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListObject getLabelValues(Integer labelId, Long xTenant) throws ApiException {
        ApiResponse<CommonListObject> resp = getLabelValuesWithHttpInfo(labelId, xTenant);
        return resp.getData();
    }


    /**
     * 获取某个标签的取值
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonListObject&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListObject> getLabelValuesWithHttpInfo(Integer labelId, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getLabelValuesValidateBeforeCall(labelId, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonListObject>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取某个标签的取值 (asynchronously)
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelValuesAsync(Integer labelId, Long xTenant, final ApiCallback<CommonListObject> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getLabelValuesValidateBeforeCall(labelId, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListObject>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for postLabels
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLabelsCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));
        if (type != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postLabels"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLabelsValidateBeforeCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postLabels(Async)");
        }

        com.squareup.okhttp.Call call = postLabelsCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 标签列表高级查询
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @return CommonListLabelMetaInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListLabelMetaInfo postLabels(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        ApiResponse<CommonListLabelMetaInfo> resp = postLabelsWithHttpInfo(xTenant, body, subjectId, type);
        return resp.getData();
    }


    /**
     * 标签列表高级查询
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @return ApiResponse&lt;CommonListLabelMetaInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListLabelMetaInfo> postLabelsWithHttpInfo(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        com.squareup.okhttp.Call call = postLabelsValidateBeforeCall(xTenant, body, subjectId, type, null, null);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 标签列表高级查询 (asynchronously)
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLabelsAsync(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ApiCallback<CommonListLabelMetaInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = postLabelsValidateBeforeCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for updateRealtimeTagData
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateRealtimeTagDataCall(Long xTenant, RealtimeTagReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","updateRealtimeTagData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateRealtimeTagDataValidateBeforeCall(Long xTenant, RealtimeTagReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateRealtimeTagData(Async)");
        }

        com.squareup.okhttp.Call call = updateRealtimeTagDataCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 添加或者修改某个用户身上的人工标签
     * 添加或者修改某个用户身上的人工标签，该接口可替换接口【添加或者修改某个用户身上的人工标签】和【添加或者修改某个用户身上的实时标签】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return CommonString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonString updateRealtimeTagData(Long xTenant, RealtimeTagReq body) throws ApiException {
        ApiResponse<CommonString> resp = updateRealtimeTagDataWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 添加或者修改某个用户身上的人工标签
     * 添加或者修改某个用户身上的人工标签，该接口可替换接口【添加或者修改某个用户身上的人工标签】和【添加或者修改某个用户身上的实时标签】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonString> updateRealtimeTagDataWithHttpInfo(Long xTenant, RealtimeTagReq body) throws ApiException {
        com.squareup.okhttp.Call call = updateRealtimeTagDataValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 添加或者修改某个用户身上的人工标签 (asynchronously)
     * 添加或者修改某个用户身上的人工标签，该接口可替换接口【添加或者修改某个用户身上的人工标签】和【添加或者修改某个用户身上的实时标签】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateRealtimeTagDataAsync(Long xTenant, RealtimeTagReq body, final ApiCallback<CommonString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = updateRealtimeTagDataValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
