/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.AuthModulePermissionResp;
import code.byted.cdp.model.AuthUserAttributeUploadRequest;
import code.byted.cdp.model.AuthUserAttributeUploadResp;
import code.byted.cdp.model.GetBusinessIdentityReq;
import code.byted.cdp.model.GetBusinessIdentityResp;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthApi {
    private ApiClient apiClient;

    public AuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call modulePermissionCall(Integer xTenant, String filterModule, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (filterModule != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter_module", filterModule));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "modulePermission"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call modulePermissionValidateBeforeCall(Integer xTenant, String filterModule, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling modulePermission(Async)");
        }
        Call call = this.modulePermissionCall(xTenant, filterModule, progressListener, progressRequestListener);
        return call;
    }

    public AuthModulePermissionResp modulePermission(Integer xTenant, String filterModule) throws ApiException {
        ApiResponse<AuthModulePermissionResp> resp = this.modulePermissionWithHttpInfo(xTenant, filterModule);
        return resp.getData();
    }

    public ApiResponse<AuthModulePermissionResp> modulePermissionWithHttpInfo(Integer xTenant, String filterModule) throws ApiException {
        Call call = this.modulePermissionValidateBeforeCall(xTenant, filterModule, null, null);
        Type localVarReturnType = new TypeToken<AuthModulePermissionResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call modulePermissionAsync(Integer xTenant, String filterModule, final ApiCallback<AuthModulePermissionResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.modulePermissionValidateBeforeCall(xTenant, filterModule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AuthModulePermissionResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call userAttributeUploadCall(AuthUserAttributeUploadRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AuthUserAttributeUploadRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "userAttributeUpload"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-01-25"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call userAttributeUploadValidateBeforeCall(AuthUserAttributeUploadRequest body, Integer xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling userAttributeUpload(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling userAttributeUpload(Async)");
        }
        Call call = this.userAttributeUploadCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public AuthUserAttributeUploadResp userAttributeUpload(AuthUserAttributeUploadRequest body, Integer xTenant) throws ApiException {
        ApiResponse<AuthUserAttributeUploadResp> resp = this.userAttributeUploadWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    public ApiResponse<AuthUserAttributeUploadResp> userAttributeUploadWithHttpInfo(AuthUserAttributeUploadRequest body, Integer xTenant) throws ApiException {
        Call call = this.userAttributeUploadValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<AuthUserAttributeUploadResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call userAttributeUploadAsync(AuthUserAttributeUploadRequest body, Integer xTenant, final ApiCallback<AuthUserAttributeUploadResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.userAttributeUploadValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AuthUserAttributeUploadResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public GetBusinessIdentityResp getBusinessIdentity(GetBusinessIdentityReq req, Integer xTenant) throws ApiException {
        ApiResponse<GetBusinessIdentityResp> resp = this.getBusinessIdentityWithHttpInfo(req, xTenant);
        return resp.getData();
    }

    private ApiResponse<GetBusinessIdentityResp> getBusinessIdentityWithHttpInfo(GetBusinessIdentityReq req, Integer xTenant) throws ApiException {
        Call call = this.getBusinessIdentityValidateBeforeCall(req, xTenant, null, null);
        Type localVarReturnType = new TypeToken<GetBusinessIdentityResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    private Call getBusinessIdentityValidateBeforeCall(GetBusinessIdentityReq body, Integer xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling userAttributeUpload(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling userAttributeUpload(Async)");
        }
        Call call = this.getBusinessIdentityCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    private Call getBusinessIdentityCall(GetBusinessIdentityReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GetBusinessIdentityReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getTmpBusinessIdentity"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-09-25"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
}

