/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.BatchOperateEventRequest;
import code.byted.cdp.model.CommonResponseBoolean;
import code.byted.cdp.model.CommonResponseSourcePropertyValue;
import code.byted.cdp.model.CreateDataSourceReq;
import code.byted.cdp.model.CreateDataSourceResult;
import code.byted.cdp.model.DetailAttributesReq;
import code.byted.cdp.model.DetailAttributesResp;
import code.byted.cdp.model.GetPropertiesResp;
import code.byted.cdp.model.GetPropertyValuesParams;
import code.byted.cdp.model.ListCdpEventPropertyVo;
import code.byted.cdp.model.ListCdpEventVo;
import code.byted.cdp.model.ListCdpPropertyVo;
import code.byted.cdp.model.ListDataSourceListItemVo;
import code.byted.cdp.model.ListString;
import code.byted.cdp.model.ResNodeLineage;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DatasourceApi {
    private ApiClient apiClient;

    public DatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call batchOperateEventCall(BatchOperateEventRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BatchOperateEventRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "batchOperateEvent"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call batchOperateEventValidateBeforeCall(BatchOperateEventRequest body, Integer xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling batchOperateEvent(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling batchOperateEvent(Async)");
        }
        Call call = this.batchOperateEventCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseBoolean batchOperateEvent(BatchOperateEventRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = this.batchOperateEventWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    public ApiResponse<CommonResponseBoolean> batchOperateEventWithHttpInfo(BatchOperateEventRequest body, Integer xTenant) throws ApiException {
        Call call = this.batchOperateEventValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call batchOperateEventAsync(BatchOperateEventRequest body, Integer xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.batchOperateEventValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getDetailAttributesCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DetailAttributesReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        if (current != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("current", current));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("attributeId", attributeId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getDetailAttributes"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDetailAttributesValidateBeforeCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getDetailAttributes(Async)");
        }
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getDetailAttributes(Async)");
        }
        if (attributeId == null) {
            throw new ApiException("Missing the required parameter 'attributeId' when calling getDetailAttributes(Async)");
        }
        Call call = this.getDetailAttributesCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        return call;
    }

    public DetailAttributesResp getDetailAttributes(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        ApiResponse<DetailAttributesResp> resp = this.getDetailAttributesWithHttpInfo(body, tenantCode, attributeId, keyword, current, pageSize);
        return resp.getData();
    }

    public ApiResponse<DetailAttributesResp> getDetailAttributesWithHttpInfo(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        Call call = this.getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, null, null);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getDetailAttributesAsync(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ApiCallback<DetailAttributesResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getPropertiesCall(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        if (onlineStatusCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("online_status_code", onlineStatusCode));
        }
        if (datasourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("datasource_id", datasourceId));
        }
        if (subjectId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subject_id", subjectId));
        }
        localVarQueryParams.add(new Pair("project_id", projectId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getProperties"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPropertiesValidateBeforeCall(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProperties(Async)");
        }
        Call call = this.getPropertiesCall(projectId, keyword, onlineStatusCode, datasourceId, subjectId, progressListener, progressRequestListener);
        return call;
    }

    public GetPropertiesResp getProperties(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId) throws ApiException {
        ApiResponse<GetPropertiesResp> resp = this.getPropertiesWithHttpInfo(projectId, keyword, onlineStatusCode, datasourceId, subjectId);
        return resp.getData();
    }

    public ApiResponse<GetPropertiesResp> getPropertiesWithHttpInfo(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId) throws ApiException {
        Call call = this.getPropertiesValidateBeforeCall(projectId, keyword, onlineStatusCode, datasourceId, subjectId, null, null);
        Type localVarReturnType = new TypeToken<GetPropertiesResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getPropertiesAsync(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId, final ApiCallback<GetPropertiesResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.getPropertiesValidateBeforeCall(projectId, keyword, onlineStatusCode, datasourceId, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetPropertiesResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getPropertyValuesCall(Long xTenant, GetPropertyValuesParams body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GetPropertyValuesParams localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getPropertyValues"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-01-25"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPropertyValuesValidateBeforeCall(Long xTenant, GetPropertyValuesParams body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getPropertyValues(Async)");
        }
        Call call = this.getPropertyValuesCall(xTenant, body, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseSourcePropertyValue getPropertyValues(Long xTenant, GetPropertyValuesParams body) throws ApiException {
        ApiResponse<CommonResponseSourcePropertyValue> resp = this.getPropertyValuesWithHttpInfo(xTenant, body);
        return resp.getData();
    }

    public ApiResponse<CommonResponseSourcePropertyValue> getPropertyValuesWithHttpInfo(Long xTenant, GetPropertyValuesParams body) throws ApiException {
        Call call = this.getPropertyValuesValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseSourcePropertyValue>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getPropertyValuesAsync(Long xTenant, GetPropertyValuesParams body, final ApiCallback<CommonResponseSourcePropertyValue> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.getPropertyValuesValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseSourcePropertyValue>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryDataSourceListCall(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourceName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceName", sourceName));
        }
        if (sourceType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceType", sourceType));
        }
        if (subjectId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subjectId", subjectId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryDataSourceList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryDataSourceListValidateBeforeCall(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryDataSourceList(Async)");
        }
        Call call = this.queryDataSourceListCall(xTenant, sourceName, sourceType, subjectId, progressListener, progressRequestListener);
        return call;
    }

    public ListDataSourceListItemVo queryDataSourceList(Long xTenant, String sourceName, Integer sourceType, Integer subjectId) throws ApiException {
        ApiResponse<ListDataSourceListItemVo> resp = this.queryDataSourceListWithHttpInfo(xTenant, sourceName, sourceType, subjectId);
        return resp.getData();
    }

    public ApiResponse<ListDataSourceListItemVo> queryDataSourceListWithHttpInfo(Long xTenant, String sourceName, Integer sourceType, Integer subjectId) throws ApiException {
        Call call = this.queryDataSourceListValidateBeforeCall(xTenant, sourceName, sourceType, subjectId, null, null);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryDataSourceListAsync(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ApiCallback<ListDataSourceListItemVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.queryDataSourceListValidateBeforeCall(xTenant, sourceName, sourceType, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryLineageByNidCall(String bizType, Long nativeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bizType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("bizType", bizType));
        }
        if (nativeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nativeId", nativeId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryLineageByNid"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-06-20"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryLineageByNidValidateBeforeCall(String bizType, Long nativeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (bizType == null) {
            throw new ApiException("Missing the required parameter 'bizType' when calling queryLineageByNid(Async)");
        }
        if (nativeId == null) {
            throw new ApiException("Missing the required parameter 'nativeId' when calling queryLineageByNid(Async)");
        }
        Call call = this.queryLineageByNidCall(bizType, nativeId, progressListener, progressRequestListener);
        return call;
    }

    public ResNodeLineage queryLineageByNid(String bizType, Long nativeId) throws ApiException {
        ApiResponse<ResNodeLineage> resp = this.queryLineageByNidWithHttpInfo(bizType, nativeId);
        return resp.getData();
    }

    public ApiResponse<ResNodeLineage> queryLineageByNidWithHttpInfo(String bizType, Long nativeId) throws ApiException {
        Call call = this.queryLineageByNidValidateBeforeCall(bizType, nativeId, null, null);
        Type localVarReturnType = new TypeToken<ResNodeLineage>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryLineageByNidAsync(String bizType, Long nativeId, final ApiCallback<ResNodeLineage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.queryLineageByNidValidateBeforeCall(bizType, nativeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResNodeLineage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryeventListCall(Integer dataSourceId, String platform, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        if (platform != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("platform", platform));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryeventList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryeventListValidateBeforeCall(Integer dataSourceId, String platform, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling queryeventList(Async)");
        }
        Call call = this.queryeventListCall(dataSourceId, platform, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpEventVo queryeventList(Integer dataSourceId, String platform) throws ApiException {
        ApiResponse<ListCdpEventVo> resp = this.queryeventListWithHttpInfo(dataSourceId, platform);
        return resp.getData();
    }

    public ApiResponse<ListCdpEventVo> queryeventListWithHttpInfo(Integer dataSourceId, String platform) throws ApiException {
        Call call = this.queryeventListValidateBeforeCall(dataSourceId, platform, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryeventListAsync(Integer dataSourceId, String platform, final ApiCallback<ListCdpEventVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.queryeventListValidateBeforeCall(dataSourceId, platform, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryeventPropertyListCall(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (eventId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("eventId", eventId));
        }
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        if (eventName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("eventName", eventName));
        }
        if (platform != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("platform", platform));
        }
        if (primitive != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("primitive", primitive));
        }
        if (withCommon != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("withCommon", withCommon));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryeventPropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-01-25"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryeventPropertyListValidateBeforeCall(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.queryeventPropertyListCall(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpEventPropertyVo queryeventPropertyList(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon) throws ApiException {
        ApiResponse<ListCdpEventPropertyVo> resp = this.queryeventPropertyListWithHttpInfo(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon);
        return resp.getData();
    }

    public ApiResponse<ListCdpEventPropertyVo> queryeventPropertyListWithHttpInfo(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon) throws ApiException {
        Call call = this.queryeventPropertyListValidateBeforeCall(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryeventPropertyListAsync(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon, final ApiCallback<ListCdpEventPropertyVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.queryeventPropertyListValidateBeforeCall(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call querypropertyListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "querypropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call querypropertyListValidateBeforeCall(Integer dataSourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyList(Async)");
        }
        Call call = this.querypropertyListCall(dataSourceId, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpPropertyVo querypropertyList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpPropertyVo> resp = this.querypropertyListWithHttpInfo(dataSourceId);
        return resp.getData();
    }

    public ApiResponse<ListCdpPropertyVo> querypropertyListWithHttpInfo(Integer dataSourceId) throws ApiException {
        Call call = this.querypropertyListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call querypropertyListAsync(Integer dataSourceId, final ApiCallback<ListCdpPropertyVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.querypropertyListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call querypropertyValuesCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("id", id));
        }
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "querypropertyValues"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call querypropertyValuesValidateBeforeCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling querypropertyValues(Async)");
        }
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyValues(Async)");
        }
        Call call = this.querypropertyValuesCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        return call;
    }

    public ListString querypropertyValues(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        ApiResponse<ListString> resp = this.querypropertyValuesWithHttpInfo(id, dataSourceId, page, pageSize, keyword);
        return resp.getData();
    }

    public ApiResponse<ListString> querypropertyValuesWithHttpInfo(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        Call call = this.querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, null, null);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call querypropertyValuesAsync(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ApiCallback<ListString> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call registerSetOriginSourceCall(CreateDataSourceReq body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateDataSourceReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "registerSetOriginSource"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call registerSetOriginSourceValidateBeforeCall(CreateDataSourceReq body, Long xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling registerSetOriginSource(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling registerSetOriginSource(Async)");
        }
        Call call = this.registerSetOriginSourceCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CreateDataSourceResult registerSetOriginSource(CreateDataSourceReq body, Long xTenant) throws ApiException {
        ApiResponse<CreateDataSourceResult> resp = this.registerSetOriginSourceWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    public ApiResponse<CreateDataSourceResult> registerSetOriginSourceWithHttpInfo(CreateDataSourceReq body, Long xTenant) throws ApiException {
        Call call = this.registerSetOriginSourceValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CreateDataSourceResult>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call registerSetOriginSourceAsync(CreateDataSourceReq body, Long xTenant, final ApiCallback<CreateDataSourceResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.registerSetOriginSourceValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateDataSourceResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

