package com.bytedance.dp.cloud_damask.datasource.write.userdefine;

import java.util.Map;

public abstract class BatchOutput implements UDFOutput {

    public OutputType getOutputType() {
        return OutputType.BATCH;
    }


    /**
     * 每个分区数据开始输出时执行
     *
     * @param schema  数据类型数组
     * @param options 从前端配置低的配置
     * @throws Exception 如果初始化过程中发生错误
     */
    public abstract void partitionInit(DataType[] schema, Map<String, String> options) throws Exception;

    /**
     * 每个batch输出的时候执行
     *
     * @param schema  数据类型数组
     * @param row     行数据，row.size le batch
     * @param options 从前端配置低的配置
     * @return 用户自己定义当前batch实际返回了多少数据
     * @throws Exception 如果执行过程中发生错误
     */
    public abstract int run(DataType[] schema, Object[][] row, Map<String, String> options) throws Exception;

}