package com.bytedance.dp.cloud_damask.datasource.write.userdefine;

public abstract class SourceStreamOutput implements UDFOutput {

    public OutputType getOutputType() {
        return OutputType.HDFS_FILE;
    }


    /**
     * 整个任务结束时执行，可以用户自己定义一些回调操作
     *
     * @param schema     数据类型数组
     * @param metaData   如果用户需要给输出的数据集添加一些附属信息，后续会追加在此类中
     * @param taskStatus 当前stage的执行状态
     */
    public abstract void finish(DataType[] schema, MetaData metaData, TaskStatus taskStatus);
}
