package com.bytedance.dp.cloud_damask.datasource.write.userdefine;

import java.util.Map;

public interface UDFOutput {

    public OutputType getOutputType();

    /**
     * 数据开始输出时执行
     *
     * @param schema  数据类型数组
     * @param options 从前端配置的配置
     * @throws Exception 如果初始化过程中发生错误
     */
    public abstract void init(DataType[] schema, Map<String, String> options) throws Exception;



    /**
     * 整个任务结束时执行, 可以用户自己定义一些回调操作
     *
     * @param schema     数据类型数组
     * @param metaData   如果用户需要给输出的数据集添加一些附属信息, 后续会追加在此类中
     * @param taskStatus 当前stage的执行状态
     * @param options    从前端配置的配置
     * @throws Exception 如果执行过程中发生错误
     */
    public abstract void finish(DataType[] schema, MetaData metaData, TaskStatus taskStatus, Map<String, String> options) throws Exception;
}
