/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.ByteDanceResponsePageResponseSegInnerResponse;
import code.byted.cdp.model.ByteDanceResponseRecordSegShardInfoResp;
import code.byted.cdp.model.ByteDanceResponseSegFileUploadResponse;
import code.byted.cdp.model.LegacyUploadedSegCreateRequest;
import code.byted.cdp.model.LoadRemoteSegRequest;
import code.byted.cdp.model.SegmentListRequest;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SegmentationApi {
    private ApiClient apiClient;

    public SegmentationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for legacyCreateUploadSegment
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyCreateUploadSegmentCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyCreateUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyCreateUploadSegmentValidateBeforeCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateUploadSegment(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateUploadSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyCreateUploadSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传分群包-导入
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ByteDanceResponseRecordSegShardInfoResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseRecordSegShardInfoResp legacyCreateUploadSegment(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseRecordSegShardInfoResp> resp = legacyCreateUploadSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }


    /**
     * 上传分群包-导入
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ApiResponse&lt;ByteDanceResponseRecordSegShardInfoResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseRecordSegShardInfoResp> legacyCreateUploadSegmentWithHttpInfo(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传分群包-导入 (asynchronously)
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyCreateUploadSegmentAsync(LegacyUploadedSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseRecordSegShardInfoResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getSegmentListV2
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSegmentListV2Call(String xTenant, SegmentListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getSegmentListV2"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSegmentListV2ValidateBeforeCall(String xTenant, SegmentListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getSegmentListV2(Async)");
        }

        com.squareup.okhttp.Call call = getSegmentListV2Call(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群列表V2
     * 拉取分群列表
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @return ByteDanceResponsePageResponseSegInnerResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponsePageResponseSegInnerResponse getSegmentListV2(String xTenant, SegmentListRequest body) throws ApiException {
        ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> resp = getSegmentListV2WithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 分群列表V2
     * 拉取分群列表
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponsePageResponseSegInnerResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> getSegmentListV2WithHttpInfo(String xTenant, SegmentListRequest body) throws ApiException {
        com.squareup.okhttp.Call call = getSegmentListV2ValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群列表V2 (asynchronously)
     * 拉取分群列表
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSegmentListV2Async(String xTenant, SegmentListRequest body, final ApiCallback<ByteDanceResponsePageResponseSegInnerResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getSegmentListV2ValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for loadRemoteHdfsSeg
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call loadRemoteHdfsSegCall(LoadRemoteSegRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","loadRemoteHdfsSeg"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call loadRemoteHdfsSegValidateBeforeCall(LoadRemoteSegRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling loadRemoteHdfsSeg(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling loadRemoteHdfsSeg(Async)");
        }

        com.squareup.okhttp.Call call = loadRemoteHdfsSegCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传分群包-解析 hdfs 路径
     * 创建上传分群前置：解析 hdfs 路径
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ByteDanceResponseSegFileUploadResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegFileUploadResponse loadRemoteHdfsSeg(LoadRemoteSegRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegFileUploadResponse> resp = loadRemoteHdfsSegWithHttpInfo(body, tenantId);
        return resp.getData();
    }


    /**
     * 上传分群包-解析 hdfs 路径
     * 创建上传分群前置：解析 hdfs 路径
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ApiResponse&lt;ByteDanceResponseSegFileUploadResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegFileUploadResponse> loadRemoteHdfsSegWithHttpInfo(LoadRemoteSegRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = loadRemoteHdfsSegValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegFileUploadResponse>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传分群包-解析 hdfs 路径 (asynchronously)
     * 创建上传分群前置：解析 hdfs 路径
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call loadRemoteHdfsSegAsync(LoadRemoteSegRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseSegFileUploadResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = loadRemoteHdfsSegValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegFileUploadResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

}
