/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.FieldMap;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * CreateImportLabelReq
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-23T16:40:56.827+08:00[Asia/Shanghai]")
public class CreateImportLabelReq {
  @SerializedName("appId")
  private Long appId = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("labelEntityType")
  private String labelEntityType = null;

  @SerializedName("dataSourceId")
  private Long dataSourceId = null;

  @SerializedName("fieldMapList")
  private List<FieldMap> fieldMapList = null;

  @SerializedName("emailPrefix")
  private String emailPrefix = null;

  @SerializedName("appIdList")
  private List<Long> appIdList = null;

  @SerializedName("dataSecurityLevel")
  private String dataSecurityLevel = null;

  @SerializedName("productKey")
  private String productKey = null;

  public CreateImportLabelReq appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 产品线id
   * @return appId
  **/
  @Schema(description = "产品线id")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  public CreateImportLabelReq subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(description = "主体id")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public CreateImportLabelReq labelEntityType(String labelEntityType) {
    this.labelEntityType = labelEntityType;
    return this;
  }

   /**
   * 实体类型
   * @return labelEntityType
  **/
  @Schema(description = "实体类型")
  public String getLabelEntityType() {
    return labelEntityType;
  }

  public void setLabelEntityType(String labelEntityType) {
    this.labelEntityType = labelEntityType;
  }

  public CreateImportLabelReq dataSourceId(Long dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

   /**
   * 档案id
   * @return dataSourceId
  **/
  @Schema(description = "档案id")
  public Long getDataSourceId() {
    return dataSourceId;
  }

  public void setDataSourceId(Long dataSourceId) {
    this.dataSourceId = dataSourceId;
  }

  public CreateImportLabelReq fieldMapList(List<FieldMap> fieldMapList) {
    this.fieldMapList = fieldMapList;
    return this;
  }

  public CreateImportLabelReq addFieldMapListItem(FieldMap fieldMapListItem) {
    if (this.fieldMapList == null) {
      this.fieldMapList = new ArrayList<FieldMap>();
    }
    this.fieldMapList.add(fieldMapListItem);
    return this;
  }

   /**
   * 字段列表
   * @return fieldMapList
  **/
  @Schema(description = "字段列表")
  public List<FieldMap> getFieldMapList() {
    return fieldMapList;
  }

  public void setFieldMapList(List<FieldMap> fieldMapList) {
    this.fieldMapList = fieldMapList;
  }

  public CreateImportLabelReq emailPrefix(String emailPrefix) {
    this.emailPrefix = emailPrefix;
    return this;
  }

   /**
   * 创建人邮箱前缀
   * @return emailPrefix
  **/
  @Schema(description = "创建人邮箱前缀")
  public String getEmailPrefix() {
    return emailPrefix;
  }

  public void setEmailPrefix(String emailPrefix) {
    this.emailPrefix = emailPrefix;
  }

  public CreateImportLabelReq appIdList(List<Long> appIdList) {
    this.appIdList = appIdList;
    return this;
  }

  public CreateImportLabelReq addAppIdListItem(Long appIdListItem) {
    if (this.appIdList == null) {
      this.appIdList = new ArrayList<Long>();
    }
    this.appIdList.add(appIdListItem);
    return this;
  }

   /**
   * app id列表
   * @return appIdList
  **/
  @Schema(description = "app id列表")
  public List<Long> getAppIdList() {
    return appIdList;
  }

  public void setAppIdList(List<Long> appIdList) {
    this.appIdList = appIdList;
  }

  public CreateImportLabelReq dataSecurityLevel(String dataSecurityLevel) {
    this.dataSecurityLevel = dataSecurityLevel;
    return this;
  }

   /**
   * 安全等级
   * @return dataSecurityLevel
  **/
  @Schema(description = "安全等级")
  public String getDataSecurityLevel() {
    return dataSecurityLevel;
  }

  public void setDataSecurityLevel(String dataSecurityLevel) {
    this.dataSecurityLevel = dataSecurityLevel;
  }

  public CreateImportLabelReq productKey(String productKey) {
    this.productKey = productKey;
    return this;
  }

   /**
   * 部门key
   * @return productKey
  **/
  @Schema(description = "部门key")
  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateImportLabelReq createImportLabelReq = (CreateImportLabelReq) o;
    return Objects.equals(this.appId, createImportLabelReq.appId) &&
        Objects.equals(this.subjectId, createImportLabelReq.subjectId) &&
        Objects.equals(this.labelEntityType, createImportLabelReq.labelEntityType) &&
        Objects.equals(this.dataSourceId, createImportLabelReq.dataSourceId) &&
        Objects.equals(this.fieldMapList, createImportLabelReq.fieldMapList) &&
        Objects.equals(this.emailPrefix, createImportLabelReq.emailPrefix) &&
        Objects.equals(this.appIdList, createImportLabelReq.appIdList) &&
        Objects.equals(this.dataSecurityLevel, createImportLabelReq.dataSecurityLevel) &&
        Objects.equals(this.productKey, createImportLabelReq.productKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, subjectId, labelEntityType, dataSourceId, fieldMapList, emailPrefix, appIdList, dataSecurityLevel, productKey);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateImportLabelReq {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    labelEntityType: ").append(toIndentedString(labelEntityType)).append("\n");
    sb.append("    dataSourceId: ").append(toIndentedString(dataSourceId)).append("\n");
    sb.append("    fieldMapList: ").append(toIndentedString(fieldMapList)).append("\n");
    sb.append("    emailPrefix: ").append(toIndentedString(emailPrefix)).append("\n");
    sb.append("    appIdList: ").append(toIndentedString(appIdList)).append("\n");
    sb.append("    dataSecurityLevel: ").append(toIndentedString(dataSecurityLevel)).append("\n");
    sb.append("    productKey: ").append(toIndentedString(productKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
