/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * 数据源链接信息
 */
@Schema(description = "数据源链接信息")
@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-23T16:40:56.827+08:00[Asia/Shanghai]")
public class DataSourceConnectionVo {
  @SerializedName("driverName")
  private String driverName = null;

  @SerializedName("cluster")
  private String cluster = null;

  @SerializedName("db")
  private String db = null;

  @SerializedName("table")
  private String table = null;

  @SerializedName("localTable")
  private String localTable = null;

  @SerializedName("targetSetId")
  private Long targetSetId = null;

  @SerializedName("syncType")
  private Integer syncType = null;

  @SerializedName("prepId")
  private Long prepId = null;

  public DataSourceConnectionVo driverName(String driverName) {
    this.driverName = driverName;
    return this;
  }

   /**
   * driver名称
   * @return driverName
  **/
  @Schema(description = "driver名称")
  public String getDriverName() {
    return driverName;
  }

  public void setDriverName(String driverName) {
    this.driverName = driverName;
  }

  public DataSourceConnectionVo cluster(String cluster) {
    this.cluster = cluster;
    return this;
  }

   /**
   * 集群
   * @return cluster
  **/
  @Schema(description = "集群")
  public String getCluster() {
    return cluster;
  }

  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  public DataSourceConnectionVo db(String db) {
    this.db = db;
    return this;
  }

   /**
   * 数据库
   * @return db
  **/
  @Schema(description = "数据库")
  public String getDb() {
    return db;
  }

  public void setDb(String db) {
    this.db = db;
  }

  public DataSourceConnectionVo table(String table) {
    this.table = table;
    return this;
  }

   /**
   * 数据表
   * @return table
  **/
  @Schema(description = "数据表")
  public String getTable() {
    return table;
  }

  public void setTable(String table) {
    this.table = table;
  }

  public DataSourceConnectionVo localTable(String localTable) {
    this.localTable = localTable;
    return this;
  }

   /**
   * 数据local表
   * @return localTable
  **/
  @Schema(description = "数据local表")
  public String getLocalTable() {
    return localTable;
  }

  public void setLocalTable(String localTable) {
    this.localTable = localTable;
  }

  public DataSourceConnectionVo targetSetId(Long targetSetId) {
    this.targetSetId = targetSetId;
    return this;
  }

   /**
   * 数据集id
   * @return targetSetId
  **/
  @Schema(description = "数据集id")
  public Long getTargetSetId() {
    return targetSetId;
  }

  public void setTargetSetId(Long targetSetId) {
    this.targetSetId = targetSetId;
  }

  public DataSourceConnectionVo syncType(Integer syncType) {
    this.syncType = syncType;
    return this;
  }

   /**
   * 调度类型
   * @return syncType
  **/
  @Schema(description = "调度类型")
  public Integer getSyncType() {
    return syncType;
  }

  public void setSyncType(Integer syncType) {
    this.syncType = syncType;
  }

  public DataSourceConnectionVo prepId(Long prepId) {
    this.prepId = prepId;
    return this;
  }

   /**
   * prep任务id
   * @return prepId
  **/
  @Schema(description = "prep任务id")
  public Long getPrepId() {
    return prepId;
  }

  public void setPrepId(Long prepId) {
    this.prepId = prepId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSourceConnectionVo dataSourceConnectionVo = (DataSourceConnectionVo) o;
    return Objects.equals(this.driverName, dataSourceConnectionVo.driverName) &&
        Objects.equals(this.cluster, dataSourceConnectionVo.cluster) &&
        Objects.equals(this.db, dataSourceConnectionVo.db) &&
        Objects.equals(this.table, dataSourceConnectionVo.table) &&
        Objects.equals(this.localTable, dataSourceConnectionVo.localTable) &&
        Objects.equals(this.targetSetId, dataSourceConnectionVo.targetSetId) &&
        Objects.equals(this.syncType, dataSourceConnectionVo.syncType) &&
        Objects.equals(this.prepId, dataSourceConnectionVo.prepId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(driverName, cluster, db, table, localTable, targetSetId, syncType, prepId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSourceConnectionVo {\n");
    
    sb.append("    driverName: ").append(toIndentedString(driverName)).append("\n");
    sb.append("    cluster: ").append(toIndentedString(cluster)).append("\n");
    sb.append("    db: ").append(toIndentedString(db)).append("\n");
    sb.append("    table: ").append(toIndentedString(table)).append("\n");
    sb.append("    localTable: ").append(toIndentedString(localTable)).append("\n");
    sb.append("    targetSetId: ").append(toIndentedString(targetSetId)).append("\n");
    sb.append("    syncType: ").append(toIndentedString(syncType)).append("\n");
    sb.append("    prepId: ").append(toIndentedString(prepId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
