/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.AppInfoVO;
import code.byted.cdp.model.CdpAtomicFieldVo;
import code.byted.cdp.model.DataSourceConnectionVo;
import code.byted.cdp.model.EventParams;
import code.byted.cdp.model.PermissionDetail;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * DataSourceMetaVo
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-23T16:40:56.827+08:00[Asia/Shanghai]")
public class DataSourceMetaVo {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("sourceName")
  private String sourceName = null;

  @SerializedName("sourceDesc")
  private String sourceDesc = null;

  @SerializedName("templateCode")
  private String templateCode = null;

  @SerializedName("projectId")
  private Long projectId = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("entityType")
  private String entityType = null;

  @SerializedName("sourceType")
  private Integer sourceType = null;

  @SerializedName("entityIdField")
  private String entityIdField = null;

  @SerializedName("primaryField")
  private String primaryField = null;

  @SerializedName("timeField")
  private String timeField = null;

  @SerializedName("eventField")
  private String eventField = null;

  @SerializedName("eventParams")
  private EventParams eventParams = null;

  @SerializedName("owner")
  private String owner = null;

  @SerializedName("eventSource")
  private String eventSource = null;

  @SerializedName("sourceTag")
  private String sourceTag = null;

  @SerializedName("withFieldsOrNot")
  private Boolean withFieldsOrNot = null;

  @SerializedName("fieldSchemas")
  private List<CdpAtomicFieldVo> fieldSchemas = null;

  @SerializedName("connectInfo")
  private DataSourceConnectionVo connectInfo = null;

  @SerializedName("editBan")
  private Boolean editBan = null;

  @SerializedName("sourcePermission")
  private PermissionDetail sourcePermission = null;

  @SerializedName("sourceScope")
  private AppInfoVO sourceScope = null;

  @SerializedName("syncType")
  private Integer syncType = null;

  @SerializedName("pdateField")
  private String pdateField = null;

  public DataSourceMetaVo id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 档案id
   * @return id
  **/
  @Schema(description = "档案id")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public DataSourceMetaVo sourceName(String sourceName) {
    this.sourceName = sourceName;
    return this;
  }

   /**
   * 档案名
   * @return sourceName
  **/
  @Schema(description = "档案名")
  public String getSourceName() {
    return sourceName;
  }

  public void setSourceName(String sourceName) {
    this.sourceName = sourceName;
  }

  public DataSourceMetaVo sourceDesc(String sourceDesc) {
    this.sourceDesc = sourceDesc;
    return this;
  }

   /**
   * 档案描述
   * @return sourceDesc
  **/
  @Schema(description = "档案描述")
  public String getSourceDesc() {
    return sourceDesc;
  }

  public void setSourceDesc(String sourceDesc) {
    this.sourceDesc = sourceDesc;
  }

  public DataSourceMetaVo templateCode(String templateCode) {
    this.templateCode = templateCode;
    return this;
  }

   /**
   * 档案模版code
   * @return templateCode
  **/
  @Schema(description = "档案模版code")
  public String getTemplateCode() {
    return templateCode;
  }

  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }

  public DataSourceMetaVo projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 项目id
   * @return projectId
  **/
  @Schema(description = "项目id")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public DataSourceMetaVo subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(description = "主体id")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public DataSourceMetaVo entityType(String entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * 实体类型
   * @return entityType
  **/
  @Schema(description = "实体类型")
  public String getEntityType() {
    return entityType;
  }

  public void setEntityType(String entityType) {
    this.entityType = entityType;
  }

  public DataSourceMetaVo sourceType(Integer sourceType) {
    this.sourceType = sourceType;
    return this;
  }

   /**
   * 档案类型
   * @return sourceType
  **/
  @Schema(description = "档案类型")
  public Integer getSourceType() {
    return sourceType;
  }

  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }

  public DataSourceMetaVo entityIdField(String entityIdField) {
    this.entityIdField = entityIdField;
    return this;
  }

   /**
   * 实体id字段
   * @return entityIdField
  **/
  @Schema(description = "实体id字段")
  public String getEntityIdField() {
    return entityIdField;
  }

  public void setEntityIdField(String entityIdField) {
    this.entityIdField = entityIdField;
  }

  public DataSourceMetaVo primaryField(String primaryField) {
    this.primaryField = primaryField;
    return this;
  }

   /**
   * 主键id字段
   * @return primaryField
  **/
  @Schema(description = "主键id字段")
  public String getPrimaryField() {
    return primaryField;
  }

  public void setPrimaryField(String primaryField) {
    this.primaryField = primaryField;
  }

  public DataSourceMetaVo timeField(String timeField) {
    this.timeField = timeField;
    return this;
  }

   /**
   * 时间字段
   * @return timeField
  **/
  @Schema(description = "时间字段")
  public String getTimeField() {
    return timeField;
  }

  public void setTimeField(String timeField) {
    this.timeField = timeField;
  }

  public DataSourceMetaVo eventField(String eventField) {
    this.eventField = eventField;
    return this;
  }

   /**
   * 事件字段
   * @return eventField
  **/
  @Schema(description = "事件字段")
  public String getEventField() {
    return eventField;
  }

  public void setEventField(String eventField) {
    this.eventField = eventField;
  }

  public DataSourceMetaVo eventParams(EventParams eventParams) {
    this.eventParams = eventParams;
    return this;
  }

   /**
   * Get eventParams
   * @return eventParams
  **/
  @Schema(description = "")
  public EventParams getEventParams() {
    return eventParams;
  }

  public void setEventParams(EventParams eventParams) {
    this.eventParams = eventParams;
  }

  public DataSourceMetaVo owner(String owner) {
    this.owner = owner;
    return this;
  }

   /**
   * 档案所有人
   * @return owner
  **/
  @Schema(description = "档案所有人")
  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public DataSourceMetaVo eventSource(String eventSource) {
    this.eventSource = eventSource;
    return this;
  }

   /**
   * 事件来源
   * @return eventSource
  **/
  @Schema(description = "事件来源")
  public String getEventSource() {
    return eventSource;
  }

  public void setEventSource(String eventSource) {
    this.eventSource = eventSource;
  }

  public DataSourceMetaVo sourceTag(String sourceTag) {
    this.sourceTag = sourceTag;
    return this;
  }

   /**
   * 档案注册来源
   * @return sourceTag
  **/
  @Schema(description = "档案注册来源")
  public String getSourceTag() {
    return sourceTag;
  }

  public void setSourceTag(String sourceTag) {
    this.sourceTag = sourceTag;
  }

  public DataSourceMetaVo withFieldsOrNot(Boolean withFieldsOrNot) {
    this.withFieldsOrNot = withFieldsOrNot;
    return this;
  }

   /**
   * 是否包含字段
   * @return withFieldsOrNot
  **/
  @Schema(description = "是否包含字段")
  public Boolean isWithFieldsOrNot() {
    return withFieldsOrNot;
  }

  public void setWithFieldsOrNot(Boolean withFieldsOrNot) {
    this.withFieldsOrNot = withFieldsOrNot;
  }

  public DataSourceMetaVo fieldSchemas(List<CdpAtomicFieldVo> fieldSchemas) {
    this.fieldSchemas = fieldSchemas;
    return this;
  }

  public DataSourceMetaVo addFieldSchemasItem(CdpAtomicFieldVo fieldSchemasItem) {
    if (this.fieldSchemas == null) {
      this.fieldSchemas = new ArrayList<CdpAtomicFieldVo>();
    }
    this.fieldSchemas.add(fieldSchemasItem);
    return this;
  }

   /**
   * 字段列表
   * @return fieldSchemas
  **/
  @Schema(description = "字段列表")
  public List<CdpAtomicFieldVo> getFieldSchemas() {
    return fieldSchemas;
  }

  public void setFieldSchemas(List<CdpAtomicFieldVo> fieldSchemas) {
    this.fieldSchemas = fieldSchemas;
  }

  public DataSourceMetaVo connectInfo(DataSourceConnectionVo connectInfo) {
    this.connectInfo = connectInfo;
    return this;
  }

   /**
   * Get connectInfo
   * @return connectInfo
  **/
  @Schema(description = "")
  public DataSourceConnectionVo getConnectInfo() {
    return connectInfo;
  }

  public void setConnectInfo(DataSourceConnectionVo connectInfo) {
    this.connectInfo = connectInfo;
  }

  public DataSourceMetaVo editBan(Boolean editBan) {
    this.editBan = editBan;
    return this;
  }

   /**
   * 是否可编辑
   * @return editBan
  **/
  @Schema(description = "是否可编辑")
  public Boolean isEditBan() {
    return editBan;
  }

  public void setEditBan(Boolean editBan) {
    this.editBan = editBan;
  }

  public DataSourceMetaVo sourcePermission(PermissionDetail sourcePermission) {
    this.sourcePermission = sourcePermission;
    return this;
  }

   /**
   * Get sourcePermission
   * @return sourcePermission
  **/
  @Schema(description = "")
  public PermissionDetail getSourcePermission() {
    return sourcePermission;
  }

  public void setSourcePermission(PermissionDetail sourcePermission) {
    this.sourcePermission = sourcePermission;
  }

  public DataSourceMetaVo sourceScope(AppInfoVO sourceScope) {
    this.sourceScope = sourceScope;
    return this;
  }

   /**
   * Get sourceScope
   * @return sourceScope
  **/
  @Schema(description = "")
  public AppInfoVO getSourceScope() {
    return sourceScope;
  }

  public void setSourceScope(AppInfoVO sourceScope) {
    this.sourceScope = sourceScope;
  }

  public DataSourceMetaVo syncType(Integer syncType) {
    this.syncType = syncType;
    return this;
  }

   /**
   * 同步类型
   * @return syncType
  **/
  @Schema(description = "同步类型")
  public Integer getSyncType() {
    return syncType;
  }

  public void setSyncType(Integer syncType) {
    this.syncType = syncType;
  }

  public DataSourceMetaVo pdateField(String pdateField) {
    this.pdateField = pdateField;
    return this;
  }

   /**
   * 分区字段
   * @return pdateField
  **/
  @Schema(description = "分区字段")
  public String getPdateField() {
    return pdateField;
  }

  public void setPdateField(String pdateField) {
    this.pdateField = pdateField;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSourceMetaVo dataSourceMetaVo = (DataSourceMetaVo) o;
    return Objects.equals(this.id, dataSourceMetaVo.id) &&
        Objects.equals(this.sourceName, dataSourceMetaVo.sourceName) &&
        Objects.equals(this.sourceDesc, dataSourceMetaVo.sourceDesc) &&
        Objects.equals(this.templateCode, dataSourceMetaVo.templateCode) &&
        Objects.equals(this.projectId, dataSourceMetaVo.projectId) &&
        Objects.equals(this.subjectId, dataSourceMetaVo.subjectId) &&
        Objects.equals(this.entityType, dataSourceMetaVo.entityType) &&
        Objects.equals(this.sourceType, dataSourceMetaVo.sourceType) &&
        Objects.equals(this.entityIdField, dataSourceMetaVo.entityIdField) &&
        Objects.equals(this.primaryField, dataSourceMetaVo.primaryField) &&
        Objects.equals(this.timeField, dataSourceMetaVo.timeField) &&
        Objects.equals(this.eventField, dataSourceMetaVo.eventField) &&
        Objects.equals(this.eventParams, dataSourceMetaVo.eventParams) &&
        Objects.equals(this.owner, dataSourceMetaVo.owner) &&
        Objects.equals(this.eventSource, dataSourceMetaVo.eventSource) &&
        Objects.equals(this.sourceTag, dataSourceMetaVo.sourceTag) &&
        Objects.equals(this.withFieldsOrNot, dataSourceMetaVo.withFieldsOrNot) &&
        Objects.equals(this.fieldSchemas, dataSourceMetaVo.fieldSchemas) &&
        Objects.equals(this.connectInfo, dataSourceMetaVo.connectInfo) &&
        Objects.equals(this.editBan, dataSourceMetaVo.editBan) &&
        Objects.equals(this.sourcePermission, dataSourceMetaVo.sourcePermission) &&
        Objects.equals(this.sourceScope, dataSourceMetaVo.sourceScope) &&
        Objects.equals(this.syncType, dataSourceMetaVo.syncType) &&
        Objects.equals(this.pdateField, dataSourceMetaVo.pdateField);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sourceName, sourceDesc, templateCode, projectId, subjectId, entityType, sourceType, entityIdField, primaryField, timeField, eventField, eventParams, owner, eventSource, sourceTag, withFieldsOrNot, fieldSchemas, connectInfo, editBan, sourcePermission, sourceScope, syncType, pdateField);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSourceMetaVo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    sourceName: ").append(toIndentedString(sourceName)).append("\n");
    sb.append("    sourceDesc: ").append(toIndentedString(sourceDesc)).append("\n");
    sb.append("    templateCode: ").append(toIndentedString(templateCode)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    sourceType: ").append(toIndentedString(sourceType)).append("\n");
    sb.append("    entityIdField: ").append(toIndentedString(entityIdField)).append("\n");
    sb.append("    primaryField: ").append(toIndentedString(primaryField)).append("\n");
    sb.append("    timeField: ").append(toIndentedString(timeField)).append("\n");
    sb.append("    eventField: ").append(toIndentedString(eventField)).append("\n");
    sb.append("    eventParams: ").append(toIndentedString(eventParams)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    eventSource: ").append(toIndentedString(eventSource)).append("\n");
    sb.append("    sourceTag: ").append(toIndentedString(sourceTag)).append("\n");
    sb.append("    withFieldsOrNot: ").append(toIndentedString(withFieldsOrNot)).append("\n");
    sb.append("    fieldSchemas: ").append(toIndentedString(fieldSchemas)).append("\n");
    sb.append("    connectInfo: ").append(toIndentedString(connectInfo)).append("\n");
    sb.append("    editBan: ").append(toIndentedString(editBan)).append("\n");
    sb.append("    sourcePermission: ").append(toIndentedString(sourcePermission)).append("\n");
    sb.append("    sourceScope: ").append(toIndentedString(sourceScope)).append("\n");
    sb.append("    syncType: ").append(toIndentedString(syncType)).append("\n");
    sb.append("    pdateField: ").append(toIndentedString(pdateField)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
