/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.JsonNode;
import code.byted.cdp.model.LabelUdfValueVo;
import code.byted.cdp.model.SyncParams;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * LabelMetaInfo
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-23T16:40:56.827+08:00[Asia/Shanghai]")
public class LabelMetaInfo {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("orgId")
  private Long orgId = null;

  @SerializedName("projectId")
  private Long projectId = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("descr")
  private String descr = null;

  @SerializedName("dataSecurityLevel")
  private String dataSecurityLevel = null;

  @SerializedName("productKey")
  private String productKey = null;

  @SerializedName("labelType")
  private String labelType = null;

  @SerializedName("dataTypeName")
  private String dataTypeName = null;

  @SerializedName("baseValueType")
  private String baseValueType = null;

  @SerializedName("domainId")
  private Integer domainId = null;

  @SerializedName("domainName")
  private String domainName = null;

  @SerializedName("position")
  private Double position = null;

  @SerializedName("entityId")
  private Integer entityId = null;

  @SerializedName("entityType")
  private String entityType = null;

  @SerializedName("computeType")
  private String computeType = null;

  @SerializedName("isMautag")
  private Integer isMautag = null;

  @SerializedName("syncParams")
  private JsonNode syncParams = null;

  @SerializedName("conf")
  private JsonNode conf = null;

  @SerializedName("taskId")
  private Integer taskId = null;

  @SerializedName("dimMetId")
  private Integer dimMetId = null;

  @SerializedName("labelRangeRules")
  private JsonNode labelRangeRules = null;

  @SerializedName("status")
  private Integer status = null;

  @SerializedName("createApiTask")
  private Boolean createApiTask = null;

  @SerializedName("realtimeTaskId")
  private Integer realtimeTaskId = null;

  @SerializedName("realtimeStatus")
  private Integer realtimeStatus = null;

  @SerializedName("outputMode")
  private String outputMode = null;

  @SerializedName("owner")
  private String owner = null;

  @SerializedName("createTime")
  private String createTime = null;

  @SerializedName("updater")
  private String updater = null;

  @SerializedName("updateTime")
  private String updateTime = null;

  @SerializedName("abiDimMetId")
  private Integer abiDimMetId = null;

  @SerializedName("lastSuccessTaskInstanceId")
  private Integer lastSuccessTaskInstanceId = null;

  @SerializedName("latestRunDate")
  private String latestRunDate = null;

  @SerializedName("userNum")
  private Integer userNum = null;

  @SerializedName("realtimeCompensateTaskId")
  private Long realtimeCompensateTaskId = null;

  @SerializedName("values")
  private List<String> values = null;

  @SerializedName("udf")
  private List<LabelUdfValueVo> udf = null;

  @SerializedName("syncParamsStruct")
  private SyncParams syncParamsStruct = null;

  public LabelMetaInfo id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 标签id
   * @return id
  **/
  @Schema(description = "标签id")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public LabelMetaInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 标签名
   * @return name
  **/
  @Schema(description = "标签名")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public LabelMetaInfo orgId(Long orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * 集团id
   * @return orgId
  **/
  @Schema(description = "集团id")
  public Long getOrgId() {
    return orgId;
  }

  public void setOrgId(Long orgId) {
    this.orgId = orgId;
  }

  public LabelMetaInfo projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 项目id
   * @return projectId
  **/
  @Schema(description = "项目id")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public LabelMetaInfo subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(description = "主体id")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public LabelMetaInfo descr(String descr) {
    this.descr = descr;
    return this;
  }

   /**
   * 标签描述
   * @return descr
  **/
  @Schema(description = "标签描述")
  public String getDescr() {
    return descr;
  }

  public void setDescr(String descr) {
    this.descr = descr;
  }

  public LabelMetaInfo dataSecurityLevel(String dataSecurityLevel) {
    this.dataSecurityLevel = dataSecurityLevel;
    return this;
  }

   /**
   * 安全级别
   * @return dataSecurityLevel
  **/
  @Schema(description = "安全级别")
  public String getDataSecurityLevel() {
    return dataSecurityLevel;
  }

  public void setDataSecurityLevel(String dataSecurityLevel) {
    this.dataSecurityLevel = dataSecurityLevel;
  }

  public LabelMetaInfo productKey(String productKey) {
    this.productKey = productKey;
    return this;
  }

   /**
   * 部门key
   * @return productKey
  **/
  @Schema(description = "部门key")
  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public LabelMetaInfo labelType(String labelType) {
    this.labelType = labelType;
    return this;
  }

   /**
   * 标签类型
   * @return labelType
  **/
  @Schema(description = "标签类型")
  public String getLabelType() {
    return labelType;
  }

  public void setLabelType(String labelType) {
    this.labelType = labelType;
  }

  public LabelMetaInfo dataTypeName(String dataTypeName) {
    this.dataTypeName = dataTypeName;
    return this;
  }

   /**
   * 数据类型
   * @return dataTypeName
  **/
  @Schema(description = "数据类型")
  public String getDataTypeName() {
    return dataTypeName;
  }

  public void setDataTypeName(String dataTypeName) {
    this.dataTypeName = dataTypeName;
  }

  public LabelMetaInfo baseValueType(String baseValueType) {
    this.baseValueType = baseValueType;
    return this;
  }

   /**
   * 营销套件通用字段类型string|int|float|date|datetime|array&lt;T&gt;|map&lt;K,T&gt;
   * @return baseValueType
  **/
  @Schema(description = "营销套件通用字段类型string|int|float|date|datetime|array<T>|map<K,T>")
  public String getBaseValueType() {
    return baseValueType;
  }

  public void setBaseValueType(String baseValueType) {
    this.baseValueType = baseValueType;
  }

  public LabelMetaInfo domainId(Integer domainId) {
    this.domainId = domainId;
    return this;
  }

   /**
   * 目录id
   * @return domainId
  **/
  @Schema(description = "目录id")
  public Integer getDomainId() {
    return domainId;
  }

  public void setDomainId(Integer domainId) {
    this.domainId = domainId;
  }

  public LabelMetaInfo domainName(String domainName) {
    this.domainName = domainName;
    return this;
  }

   /**
   * 目录名称
   * @return domainName
  **/
  @Schema(description = "目录名称")
  public String getDomainName() {
    return domainName;
  }

  public void setDomainName(String domainName) {
    this.domainName = domainName;
  }

  public LabelMetaInfo position(Double position) {
    this.position = position;
    return this;
  }

   /**
   * 目录位置
   * @return position
  **/
  @Schema(description = "目录位置")
  public Double getPosition() {
    return position;
  }

  public void setPosition(Double position) {
    this.position = position;
  }

  public LabelMetaInfo entityId(Integer entityId) {
    this.entityId = entityId;
    return this;
  }

   /**
   * 实体id
   * @return entityId
  **/
  @Schema(description = "实体id")
  public Integer getEntityId() {
    return entityId;
  }

  public void setEntityId(Integer entityId) {
    this.entityId = entityId;
  }

  public LabelMetaInfo entityType(String entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * 实体名称
   * @return entityType
  **/
  @Schema(description = "实体名称")
  public String getEntityType() {
    return entityType;
  }

  public void setEntityType(String entityType) {
    this.entityType = entityType;
  }

  public LabelMetaInfo computeType(String computeType) {
    this.computeType = computeType;
    return this;
  }

   /**
   * 计算类型
   * @return computeType
  **/
  @Schema(description = "计算类型")
  public String getComputeType() {
    return computeType;
  }

  public void setComputeType(String computeType) {
    this.computeType = computeType;
  }

  public LabelMetaInfo isMautag(Integer isMautag) {
    this.isMautag = isMautag;
    return this;
  }

   /**
   * 是否是全量标签
   * @return isMautag
  **/
  @Schema(description = "是否是全量标签")
  public Integer getIsMautag() {
    return isMautag;
  }

  public void setIsMautag(Integer isMautag) {
    this.isMautag = isMautag;
  }

  public LabelMetaInfo syncParams(JsonNode syncParams) {
    this.syncParams = syncParams;
    return this;
  }

   /**
   * Get syncParams
   * @return syncParams
  **/
  @Schema(description = "")
  public JsonNode getSyncParams() {
    return syncParams;
  }

  public void setSyncParams(JsonNode syncParams) {
    this.syncParams = syncParams;
  }

  public LabelMetaInfo conf(JsonNode conf) {
    this.conf = conf;
    return this;
  }

   /**
   * Get conf
   * @return conf
  **/
  @Schema(description = "")
  public JsonNode getConf() {
    return conf;
  }

  public void setConf(JsonNode conf) {
    this.conf = conf;
  }

  public LabelMetaInfo taskId(Integer taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * 任务id
   * @return taskId
  **/
  @Schema(description = "任务id")
  public Integer getTaskId() {
    return taskId;
  }

  public void setTaskId(Integer taskId) {
    this.taskId = taskId;
  }

  public LabelMetaInfo dimMetId(Integer dimMetId) {
    this.dimMetId = dimMetId;
    return this;
  }

   /**
   * 维度id
   * @return dimMetId
  **/
  @Schema(description = "维度id")
  public Integer getDimMetId() {
    return dimMetId;
  }

  public void setDimMetId(Integer dimMetId) {
    this.dimMetId = dimMetId;
  }

  public LabelMetaInfo labelRangeRules(JsonNode labelRangeRules) {
    this.labelRangeRules = labelRangeRules;
    return this;
  }

   /**
   * Get labelRangeRules
   * @return labelRangeRules
  **/
  @Schema(description = "")
  public JsonNode getLabelRangeRules() {
    return labelRangeRules;
  }

  public void setLabelRangeRules(JsonNode labelRangeRules) {
    this.labelRangeRules = labelRangeRules;
  }

  public LabelMetaInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 标签状态
   * @return status
  **/
  @Schema(description = "标签状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public LabelMetaInfo createApiTask(Boolean createApiTask) {
    this.createApiTask = createApiTask;
    return this;
  }

   /**
   * 是否有在线服务
   * @return createApiTask
  **/
  @Schema(description = "是否有在线服务")
  public Boolean isCreateApiTask() {
    return createApiTask;
  }

  public void setCreateApiTask(Boolean createApiTask) {
    this.createApiTask = createApiTask;
  }

  public LabelMetaInfo realtimeTaskId(Integer realtimeTaskId) {
    this.realtimeTaskId = realtimeTaskId;
    return this;
  }

   /**
   * 实时任务id
   * @return realtimeTaskId
  **/
  @Schema(description = "实时任务id")
  public Integer getRealtimeTaskId() {
    return realtimeTaskId;
  }

  public void setRealtimeTaskId(Integer realtimeTaskId) {
    this.realtimeTaskId = realtimeTaskId;
  }

  public LabelMetaInfo realtimeStatus(Integer realtimeStatus) {
    this.realtimeStatus = realtimeStatus;
    return this;
  }

   /**
   * 实时状态
   * @return realtimeStatus
  **/
  @Schema(description = "实时状态")
  public Integer getRealtimeStatus() {
    return realtimeStatus;
  }

  public void setRealtimeStatus(Integer realtimeStatus) {
    this.realtimeStatus = realtimeStatus;
  }

  public LabelMetaInfo outputMode(String outputMode) {
    this.outputMode = outputMode;
    return this;
  }

   /**
   * 输出模式
   * @return outputMode
  **/
  @Schema(description = "输出模式")
  public String getOutputMode() {
    return outputMode;
  }

  public void setOutputMode(String outputMode) {
    this.outputMode = outputMode;
  }

  public LabelMetaInfo owner(String owner) {
    this.owner = owner;
    return this;
  }

   /**
   * owner
   * @return owner
  **/
  @Schema(description = "owner")
  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public LabelMetaInfo createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @Schema(description = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public LabelMetaInfo updater(String updater) {
    this.updater = updater;
    return this;
  }

   /**
   * 编辑人
   * @return updater
  **/
  @Schema(description = "编辑人")
  public String getUpdater() {
    return updater;
  }

  public void setUpdater(String updater) {
    this.updater = updater;
  }

  public LabelMetaInfo updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @Schema(description = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public LabelMetaInfo abiDimMetId(Integer abiDimMetId) {
    this.abiDimMetId = abiDimMetId;
    return this;
  }

   /**
   * abi维度id
   * @return abiDimMetId
  **/
  @Schema(description = "abi维度id")
  public Integer getAbiDimMetId() {
    return abiDimMetId;
  }

  public void setAbiDimMetId(Integer abiDimMetId) {
    this.abiDimMetId = abiDimMetId;
  }

  public LabelMetaInfo lastSuccessTaskInstanceId(Integer lastSuccessTaskInstanceId) {
    this.lastSuccessTaskInstanceId = lastSuccessTaskInstanceId;
    return this;
  }

   /**
   * 最近一次成功实例id
   * @return lastSuccessTaskInstanceId
  **/
  @Schema(description = "最近一次成功实例id")
  public Integer getLastSuccessTaskInstanceId() {
    return lastSuccessTaskInstanceId;
  }

  public void setLastSuccessTaskInstanceId(Integer lastSuccessTaskInstanceId) {
    this.lastSuccessTaskInstanceId = lastSuccessTaskInstanceId;
  }

  public LabelMetaInfo latestRunDate(String latestRunDate) {
    this.latestRunDate = latestRunDate;
    return this;
  }

   /**
   * 最近一次成功日期
   * @return latestRunDate
  **/
  @Schema(description = "最近一次成功日期")
  public String getLatestRunDate() {
    return latestRunDate;
  }

  public void setLatestRunDate(String latestRunDate) {
    this.latestRunDate = latestRunDate;
  }

  public LabelMetaInfo userNum(Integer userNum) {
    this.userNum = userNum;
    return this;
  }

   /**
   * 用户数
   * @return userNum
  **/
  @Schema(description = "用户数")
  public Integer getUserNum() {
    return userNum;
  }

  public void setUserNum(Integer userNum) {
    this.userNum = userNum;
  }

  public LabelMetaInfo realtimeCompensateTaskId(Long realtimeCompensateTaskId) {
    this.realtimeCompensateTaskId = realtimeCompensateTaskId;
    return this;
  }

   /**
   * 实时补偿任务id
   * @return realtimeCompensateTaskId
  **/
  @Schema(description = "实时补偿任务id")
  public Long getRealtimeCompensateTaskId() {
    return realtimeCompensateTaskId;
  }

  public void setRealtimeCompensateTaskId(Long realtimeCompensateTaskId) {
    this.realtimeCompensateTaskId = realtimeCompensateTaskId;
  }

  public LabelMetaInfo values(List<String> values) {
    this.values = values;
    return this;
  }

  public LabelMetaInfo addValuesItem(String valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<String>();
    }
    this.values.add(valuesItem);
    return this;
  }

   /**
   * 枚举值
   * @return values
  **/
  @Schema(description = "枚举值")
  public List<String> getValues() {
    return values;
  }

  public void setValues(List<String> values) {
    this.values = values;
  }

  public LabelMetaInfo udf(List<LabelUdfValueVo> udf) {
    this.udf = udf;
    return this;
  }

  public LabelMetaInfo addUdfItem(LabelUdfValueVo udfItem) {
    if (this.udf == null) {
      this.udf = new ArrayList<LabelUdfValueVo>();
    }
    this.udf.add(udfItem);
    return this;
  }

   /**
   * 自定义元信息
   * @return udf
  **/
  @Schema(description = "自定义元信息")
  public List<LabelUdfValueVo> getUdf() {
    return udf;
  }

  public void setUdf(List<LabelUdfValueVo> udf) {
    this.udf = udf;
  }

  public LabelMetaInfo syncParamsStruct(SyncParams syncParamsStruct) {
    this.syncParamsStruct = syncParamsStruct;
    return this;
  }

   /**
   * Get syncParamsStruct
   * @return syncParamsStruct
  **/
  @Schema(description = "")
  public SyncParams getSyncParamsStruct() {
    return syncParamsStruct;
  }

  public void setSyncParamsStruct(SyncParams syncParamsStruct) {
    this.syncParamsStruct = syncParamsStruct;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LabelMetaInfo labelMetaInfo = (LabelMetaInfo) o;
    return Objects.equals(this.id, labelMetaInfo.id) &&
        Objects.equals(this.name, labelMetaInfo.name) &&
        Objects.equals(this.orgId, labelMetaInfo.orgId) &&
        Objects.equals(this.projectId, labelMetaInfo.projectId) &&
        Objects.equals(this.subjectId, labelMetaInfo.subjectId) &&
        Objects.equals(this.descr, labelMetaInfo.descr) &&
        Objects.equals(this.dataSecurityLevel, labelMetaInfo.dataSecurityLevel) &&
        Objects.equals(this.productKey, labelMetaInfo.productKey) &&
        Objects.equals(this.labelType, labelMetaInfo.labelType) &&
        Objects.equals(this.dataTypeName, labelMetaInfo.dataTypeName) &&
        Objects.equals(this.baseValueType, labelMetaInfo.baseValueType) &&
        Objects.equals(this.domainId, labelMetaInfo.domainId) &&
        Objects.equals(this.domainName, labelMetaInfo.domainName) &&
        Objects.equals(this.position, labelMetaInfo.position) &&
        Objects.equals(this.entityId, labelMetaInfo.entityId) &&
        Objects.equals(this.entityType, labelMetaInfo.entityType) &&
        Objects.equals(this.computeType, labelMetaInfo.computeType) &&
        Objects.equals(this.isMautag, labelMetaInfo.isMautag) &&
        Objects.equals(this.syncParams, labelMetaInfo.syncParams) &&
        Objects.equals(this.conf, labelMetaInfo.conf) &&
        Objects.equals(this.taskId, labelMetaInfo.taskId) &&
        Objects.equals(this.dimMetId, labelMetaInfo.dimMetId) &&
        Objects.equals(this.labelRangeRules, labelMetaInfo.labelRangeRules) &&
        Objects.equals(this.status, labelMetaInfo.status) &&
        Objects.equals(this.createApiTask, labelMetaInfo.createApiTask) &&
        Objects.equals(this.realtimeTaskId, labelMetaInfo.realtimeTaskId) &&
        Objects.equals(this.realtimeStatus, labelMetaInfo.realtimeStatus) &&
        Objects.equals(this.outputMode, labelMetaInfo.outputMode) &&
        Objects.equals(this.owner, labelMetaInfo.owner) &&
        Objects.equals(this.createTime, labelMetaInfo.createTime) &&
        Objects.equals(this.updater, labelMetaInfo.updater) &&
        Objects.equals(this.updateTime, labelMetaInfo.updateTime) &&
        Objects.equals(this.abiDimMetId, labelMetaInfo.abiDimMetId) &&
        Objects.equals(this.lastSuccessTaskInstanceId, labelMetaInfo.lastSuccessTaskInstanceId) &&
        Objects.equals(this.latestRunDate, labelMetaInfo.latestRunDate) &&
        Objects.equals(this.userNum, labelMetaInfo.userNum) &&
        Objects.equals(this.realtimeCompensateTaskId, labelMetaInfo.realtimeCompensateTaskId) &&
        Objects.equals(this.values, labelMetaInfo.values) &&
        Objects.equals(this.udf, labelMetaInfo.udf) &&
        Objects.equals(this.syncParamsStruct, labelMetaInfo.syncParamsStruct);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, orgId, projectId, subjectId, descr, dataSecurityLevel, productKey, labelType, dataTypeName, baseValueType, domainId, domainName, position, entityId, entityType, computeType, isMautag, syncParams, conf, taskId, dimMetId, labelRangeRules, status, createApiTask, realtimeTaskId, realtimeStatus, outputMode, owner, createTime, updater, updateTime, abiDimMetId, lastSuccessTaskInstanceId, latestRunDate, userNum, realtimeCompensateTaskId, values, udf, syncParamsStruct);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LabelMetaInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    descr: ").append(toIndentedString(descr)).append("\n");
    sb.append("    dataSecurityLevel: ").append(toIndentedString(dataSecurityLevel)).append("\n");
    sb.append("    productKey: ").append(toIndentedString(productKey)).append("\n");
    sb.append("    labelType: ").append(toIndentedString(labelType)).append("\n");
    sb.append("    dataTypeName: ").append(toIndentedString(dataTypeName)).append("\n");
    sb.append("    baseValueType: ").append(toIndentedString(baseValueType)).append("\n");
    sb.append("    domainId: ").append(toIndentedString(domainId)).append("\n");
    sb.append("    domainName: ").append(toIndentedString(domainName)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    computeType: ").append(toIndentedString(computeType)).append("\n");
    sb.append("    isMautag: ").append(toIndentedString(isMautag)).append("\n");
    sb.append("    syncParams: ").append(toIndentedString(syncParams)).append("\n");
    sb.append("    conf: ").append(toIndentedString(conf)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    dimMetId: ").append(toIndentedString(dimMetId)).append("\n");
    sb.append("    labelRangeRules: ").append(toIndentedString(labelRangeRules)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createApiTask: ").append(toIndentedString(createApiTask)).append("\n");
    sb.append("    realtimeTaskId: ").append(toIndentedString(realtimeTaskId)).append("\n");
    sb.append("    realtimeStatus: ").append(toIndentedString(realtimeStatus)).append("\n");
    sb.append("    outputMode: ").append(toIndentedString(outputMode)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updater: ").append(toIndentedString(updater)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    abiDimMetId: ").append(toIndentedString(abiDimMetId)).append("\n");
    sb.append("    lastSuccessTaskInstanceId: ").append(toIndentedString(lastSuccessTaskInstanceId)).append("\n");
    sb.append("    latestRunDate: ").append(toIndentedString(latestRunDate)).append("\n");
    sb.append("    userNum: ").append(toIndentedString(userNum)).append("\n");
    sb.append("    realtimeCompensateTaskId: ").append(toIndentedString(realtimeCompensateTaskId)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    udf: ").append(toIndentedString(udf)).append("\n");
    sb.append("    syncParamsStruct: ").append(toIndentedString(syncParamsStruct)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
