/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * MultiTagMapRequest
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-23T16:40:56.827+08:00[Asia/Shanghai]")
public class MultiTagMapRequest {
  @SerializedName("idAlias")
  private String idAlias = null;

  @SerializedName("appId")
  private Integer appId = null;

  @SerializedName("bucketNumbers")
  private Integer bucketNumbers = null;

  @SerializedName("appIds")
  private List<Integer> appIds = null;

  @SerializedName("labelIdList")
  private List<Integer> labelIdList = null;

  public MultiTagMapRequest idAlias(String idAlias) {
    this.idAlias = idAlias;
    return this;
  }

   /**
   * 输出主键的id别名
   * @return idAlias
  **/
  @Schema(description = "输出主键的id别名")
  public String getIdAlias() {
    return idAlias;
  }

  public void setIdAlias(String idAlias) {
    this.idAlias = idAlias;
  }

  public MultiTagMapRequest appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * app id
   * @return appId
  **/
  @Schema(description = "app id")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  public MultiTagMapRequest bucketNumbers(Integer bucketNumbers) {
    this.bucketNumbers = bucketNumbers;
    return this;
  }

   /**
   * 预留参数，后续cdp需要依靠这个区分是读哪张tea表
   * @return bucketNumbers
  **/
  @Schema(required = true, description = "预留参数，后续cdp需要依靠这个区分是读哪张tea表")
  public Integer getBucketNumbers() {
    return bucketNumbers;
  }

  public void setBucketNumbers(Integer bucketNumbers) {
    this.bucketNumbers = bucketNumbers;
  }

  public MultiTagMapRequest appIds(List<Integer> appIds) {
    this.appIds = appIds;
    return this;
  }

  public MultiTagMapRequest addAppIdsItem(Integer appIdsItem) {
    if (this.appIds == null) {
      this.appIds = new ArrayList<Integer>();
    }
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * app id 集合
   * @return appIds
  **/
  @Schema(description = "app id 集合")
  public List<Integer> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Integer> appIds) {
    this.appIds = appIds;
  }

  public MultiTagMapRequest labelIdList(List<Integer> labelIdList) {
    this.labelIdList = labelIdList;
    return this;
  }

  public MultiTagMapRequest addLabelIdListItem(Integer labelIdListItem) {
    if (this.labelIdList == null) {
      this.labelIdList = new ArrayList<Integer>();
    }
    this.labelIdList.add(labelIdListItem);
    return this;
  }

   /**
   * 标签 id 集合
   * @return labelIdList
  **/
  @Schema(description = "标签 id 集合")
  public List<Integer> getLabelIdList() {
    return labelIdList;
  }

  public void setLabelIdList(List<Integer> labelIdList) {
    this.labelIdList = labelIdList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultiTagMapRequest multiTagMapRequest = (MultiTagMapRequest) o;
    return Objects.equals(this.idAlias, multiTagMapRequest.idAlias) &&
        Objects.equals(this.appId, multiTagMapRequest.appId) &&
        Objects.equals(this.bucketNumbers, multiTagMapRequest.bucketNumbers) &&
        Objects.equals(this.appIds, multiTagMapRequest.appIds) &&
        Objects.equals(this.labelIdList, multiTagMapRequest.labelIdList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(idAlias, appId, bucketNumbers, appIds, labelIdList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultiTagMapRequest {\n");
    
    sb.append("    idAlias: ").append(toIndentedString(idAlias)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    bucketNumbers: ").append(toIndentedString(bucketNumbers)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("    labelIdList: ").append(toIndentedString(labelIdList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
