/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * RelationRequest
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-19T16:13:38.497+08:00[Asia/Shanghai]")
public class RelationRequest {
  @SerializedName("service_key")
  private String serviceKey = null;

  @SerializedName("project_id")
  private Long projectId = null;

  @SerializedName("app_ids")
  private List<Long> appIds = null;

  public RelationRequest serviceKey(String serviceKey) {
    this.serviceKey = serviceKey;
    return this;
  }

   /**
   * 枚举服务：Tea/Libra
   * @return serviceKey
  **/
  @Schema(required = true, description = "枚举服务：Tea/Libra")
  public String getServiceKey() {
    return serviceKey;
  }

  public void setServiceKey(String serviceKey) {
    this.serviceKey = serviceKey;
  }

  public RelationRequest projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 服务项目id
   * @return projectId
  **/
  @Schema(description = "服务项目id")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public RelationRequest appIds(List<Long> appIds) {
    this.appIds = appIds;
    return this;
  }

  public RelationRequest addAppIdsItem(Long appIdsItem) {
    if (this.appIds == null) {
      this.appIds = new ArrayList<Long>();
    }
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * AppId列表
   * @return appIds
  **/
  @Schema(description = "AppId列表")
  public List<Long> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Long> appIds) {
    this.appIds = appIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelationRequest relationRequest = (RelationRequest) o;
    return Objects.equals(this.serviceKey, relationRequest.serviceKey) &&
        Objects.equals(this.projectId, relationRequest.projectId) &&
        Objects.equals(this.appIds, relationRequest.appIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serviceKey, projectId, appIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelationRequest {\n");
    
    sb.append("    serviceKey: ").append(toIndentedString(serviceKey)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
