/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * ScheduleConf
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-08-23T16:40:56.827+08:00[Asia/Shanghai]")
public class ScheduleConf {
  @SerializedName("scheduleTime")
  private String scheduleTime = null;

  @SerializedName("scheduleDay")
  private List<Integer> scheduleDay = null;

  @SerializedName("frequency")
  private String frequency = null;

  public ScheduleConf scheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
    return this;
  }

   /**
   * 调度当天运行的时间点
   * @return scheduleTime
  **/
  @Schema(description = "调度当天运行的时间点")
  public String getScheduleTime() {
    return scheduleTime;
  }

  public void setScheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
  }

  public ScheduleConf scheduleDay(List<Integer> scheduleDay) {
    this.scheduleDay = scheduleDay;
    return this;
  }

  public ScheduleConf addScheduleDayItem(Integer scheduleDayItem) {
    if (this.scheduleDay == null) {
      this.scheduleDay = new ArrayList<Integer>();
    }
    this.scheduleDay.add(scheduleDayItem);
    return this;
  }

   /**
   * 当周级同步时 e.g.数字0表示运行时间为周一；当月级同步时 e.g.数字0表示运行时间为1号。业务时间应该往前推一天
   * @return scheduleDay
  **/
  @Schema(description = "当周级同步时 e.g.数字0表示运行时间为周一；当月级同步时 e.g.数字0表示运行时间为1号。业务时间应该往前推一天")
  public List<Integer> getScheduleDay() {
    return scheduleDay;
  }

  public void setScheduleDay(List<Integer> scheduleDay) {
    this.scheduleDay = scheduleDay;
  }

  public ScheduleConf frequency(String frequency) {
    this.frequency = frequency;
    return this;
  }

   /**
   * d:天,w:周,m:月
   * @return frequency
  **/
  @Schema(description = "d:天,w:周,m:月")
  public String getFrequency() {
    return frequency;
  }

  public void setFrequency(String frequency) {
    this.frequency = frequency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleConf scheduleConf = (ScheduleConf) o;
    return Objects.equals(this.scheduleTime, scheduleConf.scheduleTime) &&
        Objects.equals(this.scheduleDay, scheduleConf.scheduleDay) &&
        Objects.equals(this.frequency, scheduleConf.frequency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scheduleTime, scheduleDay, frequency);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleConf {\n");
    
    sb.append("    scheduleTime: ").append(toIndentedString(scheduleTime)).append("\n");
    sb.append("    scheduleDay: ").append(toIndentedString(scheduleDay)).append("\n");
    sb.append("    frequency: ").append(toIndentedString(frequency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
