/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * SegmentListRequest
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class SegmentListRequest {
    @SerializedName("pageSize")
    private Integer pageSize = null;

    @SerializedName("pageNum")
    private Integer pageNum = null;

    @SerializedName("idTypeId")
    private Integer idTypeId = null;

    @SerializedName("idTypeCode")
    private String idTypeCode = null;

    @SerializedName("subjectId")
    private Integer subjectId = null;

    @SerializedName("groupIds")
    private String groupIds = null;

    @SerializedName("keyword")
    private String keyword = null;

    @SerializedName("isSelfSee")
    private Boolean isSelfSee = null;

    @SerializedName("showHidden")
    private Boolean showHidden = null;

    /**
     * 公私域类型
     */
    @JsonAdapter(DomainTypeEnum.Adapter.class)
    public enum DomainTypeEnum {
        UNKNOWN("Unknown"),
        PUBLIC("Public"),
        PRIVATE("Private");

        private String value;

        DomainTypeEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static DomainTypeEnum fromValue(String input) {
            for (DomainTypeEnum b : DomainTypeEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<DomainTypeEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final DomainTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public DomainTypeEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return DomainTypeEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("domainType")
    private DomainTypeEnum domainType = null;

    @SerializedName("majorIdValues")
    private String majorIdValues = null;

    @SerializedName("onlineServiceEnabled")
    private Boolean onlineServiceEnabled = null;

    @SerializedName("orderBy")
    private String orderBy = null;

    /**
     * 排序方式
     */
    @JsonAdapter(OrderEnum.Adapter.class)
    public enum OrderEnum {
        UNKNOWN("Unknown"),
        DESC("desc"),
        ASC("asc");

        private String value;

        OrderEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static OrderEnum fromValue(String input) {
            for (OrderEnum b : OrderEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<OrderEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final OrderEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public OrderEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return OrderEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("order")
    private OrderEnum order = null;

    /**
     * Gets or Sets segmentTypes
     */
    @JsonAdapter(SegmentTypesEnum.Adapter.class)
    public enum SegmentTypesEnum {
        UNKNOWN("Unknown"),
        CONDITIONAL("Conditional"),
        UPLOADED("Uploaded"),
        ABI("ABI"),
        LOOKALIKE("Lookalike"),
        CHILDSEG("ChildSeg"),
        PRIVATETRANSTOPUBLIC("PrivateTransToPublic"),
        SUBJECTTRANS("SubjectTrans"),
        FEATURERECOMMENDATION("FeatureRecommendation"),
        INSIGHTEXPORT("InsightExport"),
        INSIGHTEXPORTV2("InsightExportV2"),
        PUBLICCONDITIONAL("PublicConditional"),
        FINDER("Finder"),
        PUBLICMODELRESULT("PublicModelResult"),
        PUBLICUPLOADED("PublicUploaded"),
        MODEL("Model"),
        PUBLICLOOKALIKE("PublicLookalike"),
        PRIVATELOOKALIKE("PrivateLookalike"),
        SQLEXPORT("SqlExport"),
        REALTIMECONDITIONAL("RealtimeConditional"),
        PRIVATECLUSTER("PrivateCluster"),
        PRIVATECLUSTERCHILD("PrivateClusterChild"),
        PUBLICCLUSTER("PublicCluster"),
        PUBLICCLUSTERCHILD("PublicClusterChild"),
        MANUALREALTIME("ManualRealtime"),
        MULTISUBJECTCONDITIONAL("MultiSubjectConditional");

        private String value;

        SegmentTypesEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static SegmentTypesEnum fromValue(String input) {
            for (SegmentTypesEnum b : SegmentTypesEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<SegmentTypesEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final SegmentTypesEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public SegmentTypesEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return SegmentTypesEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("segmentTypes")
    private List<SegmentTypesEnum> segmentTypes = null;

    /**
     * Gets or Sets scheduleTypes
     */
    @JsonAdapter(ScheduleTypesEnum.Adapter.class)
    public enum ScheduleTypesEnum {
        UNKNOWN("Unknown"),
        ONCE("Once"),
        DAILY("Daily"),
        TRIGGER("Trigger"),
        REALTIME("Realtime");

        private String value;

        ScheduleTypesEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static ScheduleTypesEnum fromValue(String input) {
            for (ScheduleTypesEnum b : ScheduleTypesEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<ScheduleTypesEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final ScheduleTypesEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public ScheduleTypesEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return ScheduleTypesEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("scheduleTypes")
    private List<ScheduleTypesEnum> scheduleTypes = null;

    /**
     * Gets or Sets fileStatus
     */
    @JsonAdapter(FileStatusEnum.Adapter.class)
    public enum FileStatusEnum {
        UNKNOWN("Unknown"),
        CREATED("Created"),
        PENDING("Pending"),
        RUNNING("Running"),
        SUCCESS("Success"),
        FAILED("Failed"),
        NOTCREATED("NotCreated"),
        WAITING("Waiting"),
        STOPPED("Stopped");

        private String value;

        FileStatusEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static FileStatusEnum fromValue(String input) {
            for (FileStatusEnum b : FileStatusEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<FileStatusEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final FileStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public FileStatusEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return FileStatusEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("fileStatus")
    private List<FileStatusEnum> fileStatus = null;

    /**
     * Gets or Sets bitmapStatus
     */
    @JsonAdapter(BitmapStatusEnum.Adapter.class)
    public enum BitmapStatusEnum {
        UNKNOWN("Unknown"),
        CREATED("Created"),
        PENDING("Pending"),
        RUNNING("Running"),
        SUCCESS("Success"),
        FAILED("Failed"),
        NOTCREATED("NotCreated"),
        WAITING("Waiting"),
        STOPPED("Stopped");

        private String value;

        BitmapStatusEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static BitmapStatusEnum fromValue(String input) {
            for (BitmapStatusEnum b : BitmapStatusEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<BitmapStatusEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final BitmapStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public BitmapStatusEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return BitmapStatusEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("bitmapStatus")
    private List<BitmapStatusEnum> bitmapStatus = null;

    /**
     * Gets or Sets onlineServiceStatus
     */
    @JsonAdapter(OnlineServiceStatusEnum.Adapter.class)
    public enum OnlineServiceStatusEnum {
        UNKNOWN("Unknown"),
        CREATED("Created"),
        PENDING("Pending"),
        RUNNING("Running"),
        SUCCESS("Success"),
        FAILED("Failed"),
        NOTCREATED("NotCreated"),
        WAITING("Waiting"),
        STOPPED("Stopped");

        private String value;

        OnlineServiceStatusEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static OnlineServiceStatusEnum fromValue(String input) {
            for (OnlineServiceStatusEnum b : OnlineServiceStatusEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<OnlineServiceStatusEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final OnlineServiceStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public OnlineServiceStatusEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return OnlineServiceStatusEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("onlineServiceStatus")
    private List<OnlineServiceStatusEnum> onlineServiceStatus = null;

    @SerializedName("segIdLike")
    private Integer segIdLike = null;

    @SerializedName("subjectIds")
    private List<Integer> subjectIds = null;

    @SerializedName("sourcePlatforms")
    private List<String> sourcePlatforms = null;

    /**
     * Gets or Sets encryptionMethods
     */
    @JsonAdapter(EncryptionMethodsEnum.Adapter.class)
    public enum EncryptionMethodsEnum {
        UNKNOWN("Unknown"),
        SHA256("SHA256"),
        MD5("MD5"),
        AES256("AES256"),
        NONE("None");

        private String value;

        EncryptionMethodsEnum(String value) {
            this.value = value;
        }
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
        public static EncryptionMethodsEnum fromValue(String input) {
            for (EncryptionMethodsEnum b : EncryptionMethodsEnum.values()) {
                if (b.value.equals(input)) {
                    return b;
                }
            }
            return UNKNOWN;
        }
        public static class Adapter extends TypeAdapter<EncryptionMethodsEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final EncryptionMethodsEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            @Override
            public EncryptionMethodsEnum read(final JsonReader jsonReader) throws IOException {
                Object value = jsonReader.nextString();
                return EncryptionMethodsEnum.fromValue((String)(value));
            }
        }
    }  @SerializedName("encryptionMethods")
    private List<EncryptionMethodsEnum> encryptionMethods = null;

    @SerializedName("viewer")
    private String viewer = null;

    @SerializedName("segIds")
    private List<Integer> segIds = null;

    @SerializedName("name")
    private String name = null;

    @SerializedName("createdBy")
    private String createdBy = null;

    public SegmentListRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    /**
     * 每页大小
     * @return pageSize
     **/
    @Schema(description = "每页大小")
    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public SegmentListRequest pageNum(Integer pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    /**
     * 页码
     * @return pageNum
     **/
    @Schema(description = "页码")
    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public SegmentListRequest idTypeId(Integer idTypeId) {
        this.idTypeId = idTypeId;
        return this;
    }

    /**
     * ID类型id
     * @return idTypeId
     **/
    @Schema(description = "ID类型id")
    public Integer getIdTypeId() {
        return idTypeId;
    }

    public void setIdTypeId(Integer idTypeId) {
        this.idTypeId = idTypeId;
    }

    public SegmentListRequest idTypeCode(String idTypeCode) {
        this.idTypeCode = idTypeCode;
        return this;
    }

    /**
     * 实体类型code
     * @return idTypeCode
     **/
    @Schema(description = "实体类型code")
    public String getIdTypeCode() {
        return idTypeCode;
    }

    public void setIdTypeCode(String idTypeCode) {
        this.idTypeCode = idTypeCode;
    }

    public SegmentListRequest subjectId(Integer subjectId) {
        this.subjectId = subjectId;
        return this;
    }

    /**
     * 主体ID
     * @return subjectId
     **/
    @Schema(description = "主体ID")
    public Integer getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Integer subjectId) {
        this.subjectId = subjectId;
    }

    public SegmentListRequest groupIds(String groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    /**
     * 分组ID列表，逗号分隔
     * @return groupIds
     **/
    @Schema(description = "分组ID列表，逗号分隔")
    public String getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }

    public SegmentListRequest keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    /**
     * 关键词，模糊搜索分群名称和创建人
     * @return keyword
     **/
    @Schema(description = "关键词，模糊搜索分群名称和创建人")
    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public SegmentListRequest isSelfSee(Boolean isSelfSee) {
        this.isSelfSee = isSelfSee;
        return this;
    }

    /**
     * 是否只看自己创建的
     * @return isSelfSee
     **/
    @Schema(description = "是否只看自己创建的")
    public Boolean isIsSelfSee() {
        return isSelfSee;
    }

    public void setIsSelfSee(Boolean isSelfSee) {
        this.isSelfSee = isSelfSee;
    }

    public SegmentListRequest showHidden(Boolean showHidden) {
        this.showHidden = showHidden;
        return this;
    }

    /**
     * 是否展示隐藏分群
     * @return showHidden
     **/
    @Schema(description = "是否展示隐藏分群")
    public Boolean isShowHidden() {
        return showHidden;
    }

    public void setShowHidden(Boolean showHidden) {
        this.showHidden = showHidden;
    }

    public SegmentListRequest domainType(DomainTypeEnum domainType) {
        this.domainType = domainType;
        return this;
    }

    /**
     * 公私域类型
     * @return domainType
     **/
    @Schema(description = "公私域类型")
    public DomainTypeEnum getDomainType() {
        return domainType;
    }

    public void setDomainType(DomainTypeEnum domainType) {
        this.domainType = domainType;
    }

    public SegmentListRequest majorIdValues(String majorIdValues) {
        this.majorIdValues = majorIdValues;
        return this;
    }

    /**
     * 主id筛选项
     * @return majorIdValues
     **/
    @Schema(description = "主id筛选项")
    public String getMajorIdValues() {
        return majorIdValues;
    }

    public void setMajorIdValues(String majorIdValues) {
        this.majorIdValues = majorIdValues;
    }

    public SegmentListRequest onlineServiceEnabled(Boolean onlineServiceEnabled) {
        this.onlineServiceEnabled = onlineServiceEnabled;
        return this;
    }

    /**
     * 是否开启在线服务
     * @return onlineServiceEnabled
     **/
    @Schema(description = "是否开启在线服务")
    public Boolean isOnlineServiceEnabled() {
        return onlineServiceEnabled;
    }

    public void setOnlineServiceEnabled(Boolean onlineServiceEnabled) {
        this.onlineServiceEnabled = onlineServiceEnabled;
    }

    public SegmentListRequest orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    /**
     * 排序键
     * @return orderBy
     **/
    @Schema(description = "排序键")
    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public SegmentListRequest order(OrderEnum order) {
        this.order = order;
        return this;
    }

    /**
     * 排序方式
     * @return order
     **/
    @Schema(description = "排序方式")
    public OrderEnum getOrder() {
        return order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public SegmentListRequest segmentTypes(List<SegmentTypesEnum> segmentTypes) {
        this.segmentTypes = segmentTypes;
        return this;
    }

    public SegmentListRequest addSegmentTypesItem(SegmentTypesEnum segmentTypesItem) {
        if (this.segmentTypes == null) {
            this.segmentTypes = new ArrayList<SegmentTypesEnum>();
        }
        this.segmentTypes.add(segmentTypesItem);
        return this;
    }

    /**
     * 分群类型列表
     * @return segmentTypes
     **/
    @Schema(description = "分群类型列表")
    public List<SegmentTypesEnum> getSegmentTypes() {
        return segmentTypes;
    }

    public void setSegmentTypes(List<SegmentTypesEnum> segmentTypes) {
        this.segmentTypes = segmentTypes;
    }

    public SegmentListRequest scheduleTypes(List<ScheduleTypesEnum> scheduleTypes) {
        this.scheduleTypes = scheduleTypes;
        return this;
    }

    public SegmentListRequest addScheduleTypesItem(ScheduleTypesEnum scheduleTypesItem) {
        if (this.scheduleTypes == null) {
            this.scheduleTypes = new ArrayList<ScheduleTypesEnum>();
        }
        this.scheduleTypes.add(scheduleTypesItem);
        return this;
    }

    /**
     * 调度类型列表
     * @return scheduleTypes
     **/
    @Schema(description = "调度类型列表")
    public List<ScheduleTypesEnum> getScheduleTypes() {
        return scheduleTypes;
    }

    public void setScheduleTypes(List<ScheduleTypesEnum> scheduleTypes) {
        this.scheduleTypes = scheduleTypes;
    }

    public SegmentListRequest fileStatus(List<FileStatusEnum> fileStatus) {
        this.fileStatus = fileStatus;
        return this;
    }

    public SegmentListRequest addFileStatusItem(FileStatusEnum fileStatusItem) {
        if (this.fileStatus == null) {
            this.fileStatus = new ArrayList<FileStatusEnum>();
        }
        this.fileStatus.add(fileStatusItem);
        return this;
    }

    /**
     * 文件任务状态列表
     * @return fileStatus
     **/
    @Schema(description = "文件任务状态列表")
    public List<FileStatusEnum> getFileStatus() {
        return fileStatus;
    }

    public void setFileStatus(List<FileStatusEnum> fileStatus) {
        this.fileStatus = fileStatus;
    }

    public SegmentListRequest bitmapStatus(List<BitmapStatusEnum> bitmapStatus) {
        this.bitmapStatus = bitmapStatus;
        return this;
    }

    public SegmentListRequest addBitmapStatusItem(BitmapStatusEnum bitmapStatusItem) {
        if (this.bitmapStatus == null) {
            this.bitmapStatus = new ArrayList<BitmapStatusEnum>();
        }
        this.bitmapStatus.add(bitmapStatusItem);
        return this;
    }

    /**
     * bitmap任务状态列表
     * @return bitmapStatus
     **/
    @Schema(description = "bitmap任务状态列表")
    public List<BitmapStatusEnum> getBitmapStatus() {
        return bitmapStatus;
    }

    public void setBitmapStatus(List<BitmapStatusEnum> bitmapStatus) {
        this.bitmapStatus = bitmapStatus;
    }

    public SegmentListRequest onlineServiceStatus(List<OnlineServiceStatusEnum> onlineServiceStatus) {
        this.onlineServiceStatus = onlineServiceStatus;
        return this;
    }

    public SegmentListRequest addOnlineServiceStatusItem(OnlineServiceStatusEnum onlineServiceStatusItem) {
        if (this.onlineServiceStatus == null) {
            this.onlineServiceStatus = new ArrayList<OnlineServiceStatusEnum>();
        }
        this.onlineServiceStatus.add(onlineServiceStatusItem);
        return this;
    }

    /**
     * 在线服务状态列表
     * @return onlineServiceStatus
     **/
    @Schema(description = "在线服务状态列表")
    public List<OnlineServiceStatusEnum> getOnlineServiceStatus() {
        return onlineServiceStatus;
    }

    public void setOnlineServiceStatus(List<OnlineServiceStatusEnum> onlineServiceStatus) {
        this.onlineServiceStatus = onlineServiceStatus;
    }

    public SegmentListRequest segIdLike(Integer segIdLike) {
        this.segIdLike = segIdLike;
        return this;
    }

    /**
     * 单个分群id过滤, 仅在分群列表页生效
     * @return segIdLike
     **/
    @Schema(description = "单个分群id过滤, 仅在分群列表页生效")
    public Integer getSegIdLike() {
        return segIdLike;
    }

    public void setSegIdLike(Integer segIdLike) {
        this.segIdLike = segIdLike;
    }

    public SegmentListRequest subjectIds(List<Integer> subjectIds) {
        this.subjectIds = subjectIds;
        return this;
    }

    public SegmentListRequest addSubjectIdsItem(Integer subjectIdsItem) {
        if (this.subjectIds == null) {
            this.subjectIds = new ArrayList<Integer>();
        }
        this.subjectIds.add(subjectIdsItem);
        return this;
    }

    /**
     * 多个主体id过滤，仅在分群列表页生效
     * @return subjectIds
     **/
    @Schema(description = "多个主体id过滤，仅在分群列表页生效")
    public List<Integer> getSubjectIds() {
        return subjectIds;
    }

    public void setSubjectIds(List<Integer> subjectIds) {
        this.subjectIds = subjectIds;
    }

    public SegmentListRequest sourcePlatforms(List<String> sourcePlatforms) {
        this.sourcePlatforms = sourcePlatforms;
        return this;
    }

    public SegmentListRequest addSourcePlatformsItem(String sourcePlatformsItem) {
        if (this.sourcePlatforms == null) {
            this.sourcePlatforms = new ArrayList<String>();
        }
        this.sourcePlatforms.add(sourcePlatformsItem);
        return this;
    }

    /**
     * 来源平台列表
     * @return sourcePlatforms
     **/
    @Schema(description = "来源平台列表")
    public List<String> getSourcePlatforms() {
        return sourcePlatforms;
    }

    public void setSourcePlatforms(List<String> sourcePlatforms) {
        this.sourcePlatforms = sourcePlatforms;
    }

    public SegmentListRequest encryptionMethods(List<EncryptionMethodsEnum> encryptionMethods) {
        this.encryptionMethods = encryptionMethods;
        return this;
    }

    public SegmentListRequest addEncryptionMethodsItem(EncryptionMethodsEnum encryptionMethodsItem) {
        if (this.encryptionMethods == null) {
            this.encryptionMethods = new ArrayList<EncryptionMethodsEnum>();
        }
        this.encryptionMethods.add(encryptionMethodsItem);
        return this;
    }

    /**
     * 加密方法列表
     * @return encryptionMethods
     **/
    @Schema(description = "加密方法列表")
    public List<EncryptionMethodsEnum> getEncryptionMethods() {
        return encryptionMethods;
    }

    public void setEncryptionMethods(List<EncryptionMethodsEnum> encryptionMethods) {
        this.encryptionMethods = encryptionMethods;
    }

    public SegmentListRequest viewer(String viewer) {
        this.viewer = viewer;
        return this;
    }

    /**
     * 查看人，需要 admin 身份调用才能生效
     * @return viewer
     **/
    @Schema(description = "查看人，需要 admin 身份调用才能生效")
    public String getViewer() {
        return viewer;
    }

    public void setViewer(String viewer) {
        this.viewer = viewer;
    }

    public SegmentListRequest segIds(List<Integer> segIds) {
        this.segIds = segIds;
        return this;
    }

    public SegmentListRequest addSegIdsItem(Integer segIdsItem) {
        if (this.segIds == null) {
            this.segIds = new ArrayList<Integer>();
        }
        this.segIds.add(segIdsItem);
        return this;
    }

    /**
     * 分群ID列表
     * @return segIds
     **/
    @Schema(description = "分群ID列表")
    public List<Integer> getSegIds() {
        return segIds;
    }

    public void setSegIds(List<Integer> segIds) {
        this.segIds = segIds;
    }

    public SegmentListRequest name(String name) {
        this.name = name;
        return this;
    }

    /**
     * 名称
     * @return name
     **/
    @Schema(description = "名称")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SegmentListRequest createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 创建者
     * @return createdBy
     **/
    @Schema(description = "创建者")
    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentListRequest segmentListRequest = (SegmentListRequest) o;
        return Objects.equals(this.pageSize, segmentListRequest.pageSize) &&
                Objects.equals(this.pageNum, segmentListRequest.pageNum) &&
                Objects.equals(this.idTypeId, segmentListRequest.idTypeId) &&
                Objects.equals(this.idTypeCode, segmentListRequest.idTypeCode) &&
                Objects.equals(this.subjectId, segmentListRequest.subjectId) &&
                Objects.equals(this.groupIds, segmentListRequest.groupIds) &&
                Objects.equals(this.keyword, segmentListRequest.keyword) &&
                Objects.equals(this.isSelfSee, segmentListRequest.isSelfSee) &&
                Objects.equals(this.showHidden, segmentListRequest.showHidden) &&
                Objects.equals(this.domainType, segmentListRequest.domainType) &&
                Objects.equals(this.majorIdValues, segmentListRequest.majorIdValues) &&
                Objects.equals(this.onlineServiceEnabled, segmentListRequest.onlineServiceEnabled) &&
                Objects.equals(this.orderBy, segmentListRequest.orderBy) &&
                Objects.equals(this.order, segmentListRequest.order) &&
                Objects.equals(this.segmentTypes, segmentListRequest.segmentTypes) &&
                Objects.equals(this.scheduleTypes, segmentListRequest.scheduleTypes) &&
                Objects.equals(this.fileStatus, segmentListRequest.fileStatus) &&
                Objects.equals(this.bitmapStatus, segmentListRequest.bitmapStatus) &&
                Objects.equals(this.onlineServiceStatus, segmentListRequest.onlineServiceStatus) &&
                Objects.equals(this.segIdLike, segmentListRequest.segIdLike) &&
                Objects.equals(this.subjectIds, segmentListRequest.subjectIds) &&
                Objects.equals(this.sourcePlatforms, segmentListRequest.sourcePlatforms) &&
                Objects.equals(this.encryptionMethods, segmentListRequest.encryptionMethods) &&
                Objects.equals(this.viewer, segmentListRequest.viewer) &&
                Objects.equals(this.segIds, segmentListRequest.segIds) &&
                Objects.equals(this.name, segmentListRequest.name) &&
                Objects.equals(this.createdBy, segmentListRequest.createdBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageSize, pageNum, idTypeId, idTypeCode, subjectId, groupIds, keyword, isSelfSee, showHidden, domainType, majorIdValues, onlineServiceEnabled, orderBy, order, segmentTypes, scheduleTypes, fileStatus, bitmapStatus, onlineServiceStatus, segIdLike, subjectIds, sourcePlatforms, encryptionMethods, viewer, segIds, name, createdBy);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SegmentListRequest {\n");

        sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
        sb.append("    pageNum: ").append(toIndentedString(pageNum)).append("\n");
        sb.append("    idTypeId: ").append(toIndentedString(idTypeId)).append("\n");
        sb.append("    idTypeCode: ").append(toIndentedString(idTypeCode)).append("\n");
        sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
        sb.append("    groupIds: ").append(toIndentedString(groupIds)).append("\n");
        sb.append("    keyword: ").append(toIndentedString(keyword)).append("\n");
        sb.append("    isSelfSee: ").append(toIndentedString(isSelfSee)).append("\n");
        sb.append("    showHidden: ").append(toIndentedString(showHidden)).append("\n");
        sb.append("    domainType: ").append(toIndentedString(domainType)).append("\n");
        sb.append("    majorIdValues: ").append(toIndentedString(majorIdValues)).append("\n");
        sb.append("    onlineServiceEnabled: ").append(toIndentedString(onlineServiceEnabled)).append("\n");
        sb.append("    orderBy: ").append(toIndentedString(orderBy)).append("\n");
        sb.append("    order: ").append(toIndentedString(order)).append("\n");
        sb.append("    segmentTypes: ").append(toIndentedString(segmentTypes)).append("\n");
        sb.append("    scheduleTypes: ").append(toIndentedString(scheduleTypes)).append("\n");
        sb.append("    fileStatus: ").append(toIndentedString(fileStatus)).append("\n");
        sb.append("    bitmapStatus: ").append(toIndentedString(bitmapStatus)).append("\n");
        sb.append("    onlineServiceStatus: ").append(toIndentedString(onlineServiceStatus)).append("\n");
        sb.append("    segIdLike: ").append(toIndentedString(segIdLike)).append("\n");
        sb.append("    subjectIds: ").append(toIndentedString(subjectIds)).append("\n");
        sb.append("    sourcePlatforms: ").append(toIndentedString(sourcePlatforms)).append("\n");
        sb.append("    encryptionMethods: ").append(toIndentedString(encryptionMethods)).append("\n");
        sb.append("    viewer: ").append(toIndentedString(viewer)).append("\n");
        sb.append("    segIds: ").append(toIndentedString(segIds)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
