/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.AppLabelQueryRequest;
import code.byted.cdp.model.ByteDanceSeqResponseTagValueResp;
import code.byted.cdp.model.CirceActionResponseMultiTagMapResp;
import code.byted.cdp.model.CommonListLabelMetaInfo;
import code.byted.cdp.model.CommonResponseLabelAppPermission;
import code.byted.cdp.model.CommonResponseLabelValue;
import code.byted.cdp.model.MultiTagMapRequest;
import code.byted.cdp.model.TagValueRequest;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.BatchApplyImportLabelReq;
import code.byted.cdp.model.CommonResponseBoolean;
import code.byted.cdp.model.CommonResponseCreateImportLabelResp;
import code.byted.cdp.model.CommonResponseListLabelMetaInfo;
import code.byted.cdp.model.CommonResponseLong;
import code.byted.cdp.model.CreateDataSourceRequest;
import code.byted.cdp.model.CreateImportLabelReq;
import code.byted.cdp.model.LabelQueryRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LabelApi {
    private ApiClient apiClient;

    public LabelApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LabelApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getLabelValues
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelValuesCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (labelId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("labelId", labelId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabelValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelValuesValidateBeforeCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'labelId' is set
        if (labelId == null) {
            throw new ApiException("Missing the required parameter 'labelId' when calling getLabelValues(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelValues(Async)");
        }

        com.squareup.okhttp.Call call = getLabelValuesCall(labelId, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取某个标签的取值
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @return ByteDanceSeqResponse_TagValueResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseTagValueResp getLabelValues(Integer labelId, Long xTenant) throws ApiException {
        ApiResponse<ByteDanceSeqResponseTagValueResp> resp = getLabelValuesWithHttpInfo(labelId, xTenant);
        return resp.getData();
    }


    /**
     * 获取某个标签的取值
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;ByteDanceSeqResponse_TagValueResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseTagValueResp> getLabelValuesWithHttpInfo(Integer labelId, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getLabelValuesValidateBeforeCall(labelId, xTenant, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseTagValueResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取某个标签的取值 (asynchronously)
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelValuesAsync(Integer labelId, Long xTenant, final ApiCallback<ByteDanceSeqResponseTagValueResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getLabelValuesValidateBeforeCall(labelId, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseTagValueResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for postLabels
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLabelsCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));
        if (type != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("type", type));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postLabels"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLabelsValidateBeforeCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postLabels(Async)");
        }

        com.squareup.okhttp.Call call = postLabelsCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 标签列表高级查询
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type  (optional)
     * @return CommonListLabelMetaInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListLabelMetaInfo postLabels(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        ApiResponse<CommonListLabelMetaInfo> resp = postLabelsWithHttpInfo(xTenant, body, subjectId, type);
        return resp.getData();
    }


    /**
     * 标签列表高级查询
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type  (optional)
     * @return ApiResponse&lt;CommonListLabelMetaInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListLabelMetaInfo> postLabelsWithHttpInfo(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        com.squareup.okhttp.Call call = postLabelsValidateBeforeCall(xTenant, body, subjectId, type, null, null);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 标签列表高级查询 (asynchronously)
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLabelsAsync(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ApiCallback<CommonListLabelMetaInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = postLabelsValidateBeforeCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for batchApplyImport
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call batchApplyImportCall(Long xTenant, BatchApplyImportLabelReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","batchApplyImport"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-06-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchApplyImportValidateBeforeCall(Long xTenant, BatchApplyImportLabelReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling batchApplyImport(Async)");
        }

        com.squareup.okhttp.Call call = batchApplyImportCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 标签批量申请导入
     * 标签批量申请导入
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @return CommonResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseBoolean batchApplyImport(Long xTenant, BatchApplyImportLabelReq body) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = batchApplyImportWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 标签批量申请导入
     * 标签批量申请导入
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseBoolean> batchApplyImportWithHttpInfo(Long xTenant, BatchApplyImportLabelReq body) throws ApiException {
        com.squareup.okhttp.Call call = batchApplyImportValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 标签批量申请导入 (asynchronously)
     * 标签批量申请导入
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call batchApplyImportAsync(Long xTenant, BatchApplyImportLabelReq body, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = batchApplyImportValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createDataSource
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createDataSourceCall(CreateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createDataSource"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createDataSourceValidateBeforeCall(CreateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDataSource(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createDataSource(Async)");
        }

        com.squareup.okhttp.Call call = createDataSourceCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建数据档案
     * 创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return CommonResponseLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLong createDataSource(CreateDataSourceRequest body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = createDataSourceWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建数据档案
     * 创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return ApiResponse&lt;CommonResponseLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLong> createDataSourceWithHttpInfo(CreateDataSourceRequest body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createDataSourceValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建数据档案 (asynchronously)
     * 创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createDataSourceAsync(CreateDataSourceRequest body, Long xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = createDataSourceValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createImportLabel
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createImportLabelCall(Long xTenant, CreateImportLabelReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createImportLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-06-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createImportLabelValidateBeforeCall(Long xTenant, CreateImportLabelReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createImportLabel(Async)");
        }

        com.squareup.okhttp.Call call = createImportLabelCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建导入标签
     * 创建导入标签
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @return CommonResponseCreateImportLabelResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseCreateImportLabelResp createImportLabel(Long xTenant, CreateImportLabelReq body) throws ApiException {
        ApiResponse<CommonResponseCreateImportLabelResp> resp = createImportLabelWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 创建导入标签
     * 创建导入标签
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseCreateImportLabelResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseCreateImportLabelResp> createImportLabelWithHttpInfo(Long xTenant, CreateImportLabelReq body) throws ApiException {
        com.squareup.okhttp.Call call = createImportLabelValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseCreateImportLabelResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建导入标签 (asynchronously)
     * 创建导入标签
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createImportLabelAsync(Long xTenant, CreateImportLabelReq body, final ApiCallback<CommonResponseCreateImportLabelResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = createImportLabelValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseCreateImportLabelResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for postLabelsByApp
     * @param xTenant 租户id (required)
     * @param appId 产品线id (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLabelsByAppCall(Long xTenant, Integer appId, LabelQueryRequest body, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));
        if (appId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("appId", appId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postLabelsByApp"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-06-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLabelsByAppValidateBeforeCall(Long xTenant, Integer appId, LabelQueryRequest body, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postLabelsByApp(Async)");
        }
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling postLabelsByApp(Async)");
        }

        com.squareup.okhttp.Call call = postLabelsByAppCall(xTenant, appId, body, subjectId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取项目下标签列表
     * 获取项目下标签列表
     * @param xTenant 租户id (required)
     * @param appId 产品线id (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @return CommonResponseListLabelMetaInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseListLabelMetaInfo postLabelsByApp(Long xTenant, Integer appId, LabelQueryRequest body, Integer subjectId) throws ApiException {
        ApiResponse<CommonResponseListLabelMetaInfo> resp = postLabelsByAppWithHttpInfo(xTenant, appId, body, subjectId);
        return resp.getData();
    }


    /**
     * 获取项目下标签列表
     * 获取项目下标签列表
     * @param xTenant 租户id (required)
     * @param appId 产品线id (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @return ApiResponse&lt;CommonResponseListLabelMetaInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseListLabelMetaInfo> postLabelsByAppWithHttpInfo(Long xTenant, Integer appId, LabelQueryRequest body, Integer subjectId) throws ApiException {
        com.squareup.okhttp.Call call = postLabelsByAppValidateBeforeCall(xTenant, appId, body, subjectId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListLabelMetaInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取项目下标签列表 (asynchronously)
     * 获取项目下标签列表
     * @param xTenant 租户id (required)
     * @param appId 产品线id (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLabelsByAppAsync(Long xTenant, Integer appId, LabelQueryRequest body, Integer subjectId, final ApiCallback<CommonResponseListLabelMetaInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = postLabelsByAppValidateBeforeCall(xTenant, appId, body, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListLabelMetaInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for postLabelsByProductApp
     * @param subjectId 主体id (required)
     * @param projectId 租户id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLabelsByProductAppCall(Integer subjectId, Integer projectId, String serviceKey, AppLabelQueryRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));
        if (projectId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("projectId", projectId));
        if (serviceKey != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("serviceKey", serviceKey));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postLabelsByProductApp"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLabelsByProductAppValidateBeforeCall(Integer subjectId, Integer projectId, String serviceKey, AppLabelQueryRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'subjectId' is set
        if (subjectId == null) {
            throw new ApiException("Missing the required parameter 'subjectId' when calling postLabelsByProductApp(Async)");
        }
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling postLabelsByProductApp(Async)");
        }
        // verify the required parameter 'serviceKey' is set
        if (serviceKey == null) {
            throw new ApiException("Missing the required parameter 'serviceKey' when calling postLabelsByProductApp(Async)");
        }

        com.squareup.okhttp.Call call = postLabelsByProductAppCall(subjectId, projectId, serviceKey, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 根据其他产品项目id获取标签列表
     * 根据其他产品项目id获取标签列表
     * @param subjectId 主体id (required)
     * @param projectId 租户id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param body  (optional)
     * @return CommonResponseListLabelMetaInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseListLabelMetaInfo postLabelsByProductApp(Integer subjectId, Integer projectId, String serviceKey, AppLabelQueryRequest body) throws ApiException {
        ApiResponse<CommonResponseListLabelMetaInfo> resp = postLabelsByProductAppWithHttpInfo(subjectId, projectId, serviceKey, body);
        return resp.getData();
    }


    /**
     * 根据其他产品项目id获取标签列表
     * 根据其他产品项目id获取标签列表
     * @param subjectId 主体id (required)
     * @param projectId 租户id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseListLabelMetaInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseListLabelMetaInfo> postLabelsByProductAppWithHttpInfo(Integer subjectId, Integer projectId, String serviceKey, AppLabelQueryRequest body) throws ApiException {
        com.squareup.okhttp.Call call = postLabelsByProductAppValidateBeforeCall(subjectId, projectId, serviceKey, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListLabelMetaInfo>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 根据其他产品项目id获取标签列表 (asynchronously)
     * 根据其他产品项目id获取标签列表
     * @param subjectId 主体id (required)
     * @param projectId 租户id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLabelsByProductAppAsync(Integer subjectId, Integer projectId, String serviceKey, AppLabelQueryRequest body, final ApiCallback<CommonResponseListLabelMetaInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = postLabelsByProductAppValidateBeforeCall(subjectId, projectId, serviceKey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListLabelMetaInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getAppAuthList
     * @param projectId 项目id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param labelId 标签id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppAuthListCall(Long projectId, String serviceKey, Long labelId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (projectId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("projectId", projectId));
        if (serviceKey != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("serviceKey", serviceKey));
        if (labelId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("labelId", labelId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getAppAuthList"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppAuthListValidateBeforeCall(Long projectId, String serviceKey, Long labelId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getAppAuthList(Async)");
        }
        // verify the required parameter 'serviceKey' is set
        if (serviceKey == null) {
            throw new ApiException("Missing the required parameter 'serviceKey' when calling getAppAuthList(Async)");
        }
        // verify the required parameter 'labelId' is set
        if (labelId == null) {
            throw new ApiException("Missing the required parameter 'labelId' when calling getAppAuthList(Async)");
        }

        com.squareup.okhttp.Call call = getAppAuthListCall(projectId, serviceKey, labelId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 根据其他产品项目id返回标签权限
     * 根据其他产品项目id返回标签权限
     * @param projectId 项目id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param labelId 标签id (required)
     * @return CommonResponseLabelAppPermission
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLabelAppPermission getAppAuthList(Long projectId, String serviceKey, Long labelId) throws ApiException {
        ApiResponse<CommonResponseLabelAppPermission> resp = getAppAuthListWithHttpInfo(projectId, serviceKey, labelId);
        return resp.getData();
    }


    /**
     * 根据其他产品项目id返回标签权限
     * 根据其他产品项目id返回标签权限
     * @param projectId 项目id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param labelId 标签id (required)
     * @return ApiResponse&lt;CommonResponseLabelAppPermission&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLabelAppPermission> getAppAuthListWithHttpInfo(Long projectId, String serviceKey, Long labelId) throws ApiException {
        com.squareup.okhttp.Call call = getAppAuthListValidateBeforeCall(projectId, serviceKey, labelId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLabelAppPermission>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 根据其他产品项目id返回标签权限 (asynchronously)
     * 根据其他产品项目id返回标签权限
     * @param projectId 项目id (required)
     * @param serviceKey 其他产品key：Tea, Libra (required)
     * @param labelId 标签id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAppAuthListAsync(Long projectId, String serviceKey, Long labelId, final ApiCallback<CommonResponseLabelAppPermission> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getAppAuthListValidateBeforeCall(projectId, serviceKey, labelId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLabelAppPermission>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for multiMapTableQuery
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call multiMapTableQueryCall(MultiTagMapRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","multiMapTableQuery"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call multiMapTableQueryValidateBeforeCall(MultiTagMapRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling multiMapTableQuery(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling multiMapTableQuery(Async)");
        }

        com.squareup.okhttp.Call call = multiMapTableQueryCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查看标签的expr
     * 查看标签的expr
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return CirceActionResponseMultiTagMapResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseMultiTagMapResp multiMapTableQuery(MultiTagMapRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CirceActionResponseMultiTagMapResp> resp = multiMapTableQueryWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 查看标签的expr
     * 查看标签的expr
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;CirceActionResponseMultiTagMapResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseMultiTagMapResp> multiMapTableQueryWithHttpInfo(MultiTagMapRequest body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = multiMapTableQueryValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseMultiTagMapResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查看标签的expr (asynchronously)
     * 查看标签的expr
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call multiMapTableQueryAsync(MultiTagMapRequest body, Integer xTenant, final ApiCallback<CirceActionResponseMultiTagMapResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = multiMapTableQueryValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseMultiTagMapResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for labelValueForTea
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call labelValueForTeaCall(TagValueRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","labelValueForTea"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call labelValueForTeaValidateBeforeCall(TagValueRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling labelValueForTea(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling labelValueForTea(Async)");
        }

        com.squareup.okhttp.Call call = labelValueForTeaCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查看每个id对应标签的值(tea专用)
     * 查看每个id对应标签的值(tea专用)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return LabelValue
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLabelValue labelValueForTea(TagValueRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseLabelValue> resp = labelValueForTeaWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    /**
     * 查看每个id对应标签的值(tea专用)
     * 查看每个id对应标签的值(tea专用)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;LabelValue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLabelValue> labelValueForTeaWithHttpInfo(TagValueRequest body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = labelValueForTeaValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLabelValue>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查看每个id对应标签的值(tea专用) (asynchronously)
     * 查看每个id对应标签的值(tea专用)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call labelValueForTeaAsync(TagValueRequest body, Integer xTenant, final ApiCallback<CommonResponseLabelValue> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = labelValueForTeaValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLabelValue>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
