/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.ResNodeLineage;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class LineageApi {
    private ApiClient apiClient;

    public LineageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LineageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call queryLineageByNidCall(String bizType, Long nativeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bizType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("bizType", bizType));
        }
        if (nativeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nativeId", nativeId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryLineageByNid"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-06-20"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryLineageByNidValidateBeforeCall(String bizType, Long nativeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (bizType == null) {
            throw new ApiException("Missing the required parameter 'bizType' when calling queryLineageByNid(Async)");
        }
        if (nativeId == null) {
            throw new ApiException("Missing the required parameter 'nativeId' when calling queryLineageByNid(Async)");
        }
        Call call = this.queryLineageByNidCall(bizType, nativeId, progressListener, progressRequestListener);
        return call;
    }

    public ResNodeLineage queryLineageByNid(String bizType, Long nativeId) throws ApiException {
        ApiResponse<ResNodeLineage> resp = this.queryLineageByNidWithHttpInfo(bizType, nativeId);
        return resp.getData();
    }

    public ApiResponse<ResNodeLineage> queryLineageByNidWithHttpInfo(String bizType, Long nativeId) throws ApiException {
        Call call = this.queryLineageByNidValidateBeforeCall(bizType, nativeId, null, null);
        Type localVarReturnType = new TypeToken<ResNodeLineage>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryLineageByNidAsync(String bizType, Long nativeId, final ApiCallback<ResNodeLineage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.queryLineageByNidValidateBeforeCall(bizType, nativeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResNodeLineage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

