/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.DetailAttributesReq;
import code.byted.cdp.model.DetailAttributesResp;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DetailDatasourceApi {
    private ApiClient apiClient;

    public DetailDatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DetailDatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getDetailAttributesCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DetailAttributesReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        if (current != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("current", current));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("attributeId", attributeId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getDetailAttributes"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDetailAttributesValidateBeforeCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getDetailAttributes(Async)");
        }
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getDetailAttributes(Async)");
        }
        if (attributeId == null) {
            throw new ApiException("Missing the required parameter 'attributeId' when calling getDetailAttributes(Async)");
        }
        Call call = this.getDetailAttributesCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        return call;
    }

    public DetailAttributesResp getDetailAttributes(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        ApiResponse<DetailAttributesResp> resp = this.getDetailAttributesWithHttpInfo(body, tenantCode, attributeId, keyword, current, pageSize);
        return resp.getData();
    }

    public ApiResponse<DetailAttributesResp> getDetailAttributesWithHttpInfo(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        Call call = this.getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, null, null);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getDetailAttributesAsync(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ApiCallback<DetailAttributesResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

