/*
 * Decompiled with CFR 0.152.
 */
package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;
import code.byted.cdp.model.CommonListLabelMetaInfo;
import code.byted.cdp.model.CommonListObject;
import code.byted.cdp.model.CommonString;
import code.byted.cdp.model.LabelQueryRequest;
import code.byted.cdp.model.RealtimeTagReq;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class LabelOpenApiApi {
    private ApiClient apiClient;

    public LabelOpenApiApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LabelOpenApiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteRealtimeTagDataCall(Integer baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tagId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tagId", tagId));
        }
        localVarQueryParams.add(new Pair("baseId", baseId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "deleteRealtimeTagData"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-07-03"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteRealtimeTagDataValidateBeforeCall(Integer baseId, Integer tagId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (baseId == null) {
            throw new ApiException("Missing the required parameter 'baseId' when calling deleteRealtimeTagData(Async)");
        }
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling deleteRealtimeTagData(Async)");
        }
        Call call = this.deleteRealtimeTagDataCall(baseId, tagId, progressListener, progressRequestListener);
        return call;
    }

    public CommonString deleteRealtimeTagData(Integer baseId, Integer tagId) throws ApiException {
        ApiResponse<CommonString> resp = this.deleteRealtimeTagDataWithHttpInfo(baseId, tagId);
        return resp.getData();
    }

    public ApiResponse<CommonString> deleteRealtimeTagDataWithHttpInfo(Integer baseId, Integer tagId) throws ApiException {
        Call call = this.deleteRealtimeTagDataValidateBeforeCall(baseId, tagId, null, null);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call deleteRealtimeTagDataAsync(Integer baseId, Integer tagId, final ApiCallback<CommonString> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.deleteRealtimeTagDataValidateBeforeCall(baseId, tagId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getLabelValuesCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (labelId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelId", labelId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getLabelValues"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-07-03"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLabelValuesValidateBeforeCall(Integer labelId, Long xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (labelId == null) {
            throw new ApiException("Missing the required parameter 'labelId' when calling getLabelValues(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelValues(Async)");
        }
        Call call = this.getLabelValuesCall(labelId, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CommonListObject getLabelValues(Integer labelId, Long xTenant) throws ApiException {
        ApiResponse<CommonListObject> resp = this.getLabelValuesWithHttpInfo(labelId, xTenant);
        return resp.getData();
    }

    public ApiResponse<CommonListObject> getLabelValuesWithHttpInfo(Integer labelId, Long xTenant) throws ApiException {
        Call call = this.getLabelValuesValidateBeforeCall(labelId, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonListObject>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getLabelValuesAsync(Integer labelId, Long xTenant, final ApiCallback<CommonListObject> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.getLabelValuesValidateBeforeCall(labelId, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListObject>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call postLabelsCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LabelQueryRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subjectId", subjectId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "postLabels"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-07-03"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postLabelsValidateBeforeCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postLabels(Async)");
        }
        Call call = this.postLabelsCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        return call;
    }

    public CommonListLabelMetaInfo postLabels(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        ApiResponse<CommonListLabelMetaInfo> resp = this.postLabelsWithHttpInfo(xTenant, body, subjectId, type);
        return resp.getData();
    }

    public ApiResponse<CommonListLabelMetaInfo> postLabelsWithHttpInfo(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        Call call = this.postLabelsValidateBeforeCall(xTenant, body, subjectId, type, null, null);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call postLabelsAsync(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ApiCallback<CommonListLabelMetaInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.postLabelsValidateBeforeCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call updateRealtimeTagDataCall(Long xTenant, RealtimeTagReq body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RealtimeTagReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "updateRealtimeTagData"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-07-03"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateRealtimeTagDataValidateBeforeCall(Long xTenant, RealtimeTagReq body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateRealtimeTagData(Async)");
        }
        Call call = this.updateRealtimeTagDataCall(xTenant, body, progressListener, progressRequestListener);
        return call;
    }

    public CommonString updateRealtimeTagData(Long xTenant, RealtimeTagReq body) throws ApiException {
        ApiResponse<CommonString> resp = this.updateRealtimeTagDataWithHttpInfo(xTenant, body);
        return resp.getData();
    }

    public ApiResponse<CommonString> updateRealtimeTagDataWithHttpInfo(Long xTenant, RealtimeTagReq body) throws ApiException {
        Call call = this.updateRealtimeTagDataValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call updateRealtimeTagDataAsync(Long xTenant, RealtimeTagReq body, final ApiCallback<CommonString> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.updateRealtimeTagDataValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

