/*
 * Decompiled with CFR 0.152.
 */
package code.byted.inter.openapi;

import code.byted.inter.ApiCallback;
import code.byted.inter.ApiClient;
import code.byted.inter.ApiException;
import code.byted.inter.ApiResponse;
import code.byted.inter.Configuration;
import code.byted.inter.Pair;
import code.byted.inter.ProgressRequestBody;
import code.byted.inter.ProgressResponseBody;
import code.byted.inter.model.CommonResponseBoolean;
import code.byted.inter.model.CommonResponseListDataSourceMetaVo;
import code.byted.inter.model.CommonResponseLong;
import code.byted.inter.model.CreateDataSourceRequest;
import code.byted.inter.model.DatasetCreateRequest;
import code.byted.inter.model.DatasetUpdateRequest;
import code.byted.inter.model.ListCdpPropertyVo;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DatasourceApi {
    private ApiClient apiClient;

    public DatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call querypropertyListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dataSourceId", dataSourceId));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "querypropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call querypropertyListValidateBeforeCall(Integer dataSourceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyList(Async)");
        }
        Call call = this.querypropertyListCall(dataSourceId, progressListener, progressRequestListener);
        return call;
    }

    public ListCdpPropertyVo querypropertyList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpPropertyVo> resp = this.querypropertyListWithHttpInfo(dataSourceId);
        return resp.getData();
    }

    public ApiResponse<ListCdpPropertyVo> querypropertyListWithHttpInfo(Integer dataSourceId) throws ApiException {
        Call call = this.querypropertyListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call querypropertyListAsync(Integer dataSourceId, final ApiCallback<ListCdpPropertyVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.querypropertyListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call queryByDbTableCall(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subjectId", subjectId));
        }
        if (tableType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tableType", tableType));
        }
        if (cluster != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cluster", cluster));
        }
        if (region != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("region", region));
        }
        if (database != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("database", database));
        }
        if (table != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("table", table));
        }
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "queryByDbTable"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-06-25"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryByDbTableValidateBeforeCall(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryByDbTable(Async)");
        }
        if (subjectId == null) {
            throw new ApiException("Missing the required parameter 'subjectId' when calling queryByDbTable(Async)");
        }
        if (tableType == null) {
            throw new ApiException("Missing the required parameter 'tableType' when calling queryByDbTable(Async)");
        }
        if (database == null) {
            throw new ApiException("Missing the required parameter 'database' when calling queryByDbTable(Async)");
        }
        if (table == null) {
            throw new ApiException("Missing the required parameter 'table' when calling queryByDbTable(Async)");
        }
        Call call = this.queryByDbTableCall(xTenant, subjectId, tableType, database, table, cluster, region, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseListDataSourceMetaVo queryByDbTable(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region) throws ApiException {
        ApiResponse<CommonResponseListDataSourceMetaVo> resp = this.queryByDbTableWithHttpInfo(xTenant, subjectId, tableType, database, table, cluster, region);
        return resp.getData();
    }

    public ApiResponse<CommonResponseListDataSourceMetaVo> queryByDbTableWithHttpInfo(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region) throws ApiException {
        Call call = this.queryByDbTableValidateBeforeCall(xTenant, subjectId, tableType, database, table, cluster, region, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListDataSourceMetaVo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call queryByDbTableAsync(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region, final ApiCallback<CommonResponseListDataSourceMetaVo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.queryByDbTableValidateBeforeCall(xTenant, subjectId, tableType, database, table, cluster, region, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListDataSourceMetaVo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call createDataSourceCall(CreateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateDataSourceRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "createDataSource"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createDataSourceValidateBeforeCall(CreateDataSourceRequest body, Long xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDataSource(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createDataSource(Async)");
        }
        Call call = this.createDataSourceCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseLong createDataSource(CreateDataSourceRequest body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = this.createDataSourceWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    public ApiResponse<CommonResponseLong> createDataSourceWithHttpInfo(CreateDataSourceRequest body, Long xTenant) throws ApiException {
        Call call = this.createDataSourceValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call createDataSourceAsync(CreateDataSourceRequest body, Long xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.createDataSourceValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call createDatasetCall(DatasetCreateRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DatasetCreateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "createDataset"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-10-12"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createDatasetValidateBeforeCall(DatasetCreateRequest body, Integer xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDataset(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createDataset(Async)");
        }
        Call call = this.createDatasetCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseLong createDataset(DatasetCreateRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = this.createDatasetWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    public ApiResponse<CommonResponseLong> createDatasetWithHttpInfo(DatasetCreateRequest body, Integer xTenant) throws ApiException {
        Call call = this.createDatasetValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call createDatasetAsync(DatasetCreateRequest body, Integer xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.createDatasetValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call deleteDatasetCall(Integer id, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("id", id.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "deleteDataset"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-10-12"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteDatasetValidateBeforeCall(Integer id, Integer xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteDataset(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteDataset(Async)");
        }
        Call call = this.deleteDatasetCall(id, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseBoolean deleteDataset(Integer id, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = this.deleteDatasetWithHttpInfo(id, xTenant);
        return resp.getData();
    }

    public ApiResponse<CommonResponseBoolean> deleteDatasetWithHttpInfo(Integer id, Integer xTenant) throws ApiException {
        Call call = this.deleteDatasetValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call deleteDatasetAsync(Integer id, Integer xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.deleteDatasetValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call updateDatasetCall(DatasetUpdateRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DatasetUpdateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "updateDataset"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-10-12"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateDatasetValidateBeforeCall(DatasetUpdateRequest body, Integer xTenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateDataset(Async)");
        }
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateDataset(Async)");
        }
        Call call = this.updateDatasetCall(body, xTenant, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponseLong updateDataset(DatasetUpdateRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = this.updateDatasetWithHttpInfo(body, xTenant);
        return resp.getData();
    }

    public ApiResponse<CommonResponseLong> updateDatasetWithHttpInfo(DatasetUpdateRequest body, Integer xTenant) throws ApiException {
        Call call = this.updateDatasetValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call updateDatasetAsync(DatasetUpdateRequest body, Integer xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.updateDatasetValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

