/*
 * Decompiled with CFR 0.152.
 */
package code.byted.inter.openapi;

import code.byted.inter.ApiCallback;
import code.byted.inter.ApiClient;
import code.byted.inter.ApiException;
import code.byted.inter.ApiResponse;
import code.byted.inter.Configuration;
import code.byted.inter.Pair;
import code.byted.inter.ProgressRequestBody;
import code.byted.inter.ProgressResponseBody;
import code.byted.inter.model.ListTenantsResponse;
import code.byted.inter.model.QueryOnlineResourceV2Request;
import code.byted.inter.model.QueryOnlineResourceV2Response;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class OnlineApi {
    private ApiClient apiClient;

    public OnlineApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OnlineApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getTenantsByAppIdCall(String appId, String account, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("appId", appId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("account", account));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getTenantsByAppId"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTenantsByAppIdValidateBeforeCall(String appId, String account, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getTenantsByAppId(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getTenantsByAppId(Async)");
        }
        Call call = this.getTenantsByAppIdCall(appId, account, progressListener, progressRequestListener);
        return call;
    }

    public ListTenantsResponse getTenantsByAppId(String appId, String account) throws ApiException {
        ApiResponse<ListTenantsResponse> resp = this.getTenantsByAppIdWithHttpInfo(appId, account);
        return resp.getData();
    }

    public ApiResponse<ListTenantsResponse> getTenantsByAppIdWithHttpInfo(String appId, String account) throws ApiException {
        Call call = this.getTenantsByAppIdValidateBeforeCall(appId, account, null, null);
        Type localVarReturnType = new TypeToken<ListTenantsResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getTenantsByAppIdAsync(String appId, String account, final ApiCallback<ListTenantsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.getTenantsByAppIdValidateBeforeCall(appId, account, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListTenantsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call listOnlineResourceWithAuthCall(QueryOnlineResourceV2Request body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        QueryOnlineResourceV2Request localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "listOnlineResourceWithAuth"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listOnlineResourceWithAuthValidateBeforeCall(QueryOnlineResourceV2Request body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling listOnlineResourceWithAuth(Async)");
        }
        Call call = this.listOnlineResourceWithAuthCall(body, progressListener, progressRequestListener);
        return call;
    }

    public QueryOnlineResourceV2Response listOnlineResourceWithAuth(QueryOnlineResourceV2Request body) throws ApiException {
        ApiResponse<QueryOnlineResourceV2Response> resp = this.listOnlineResourceWithAuthWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<QueryOnlineResourceV2Response> listOnlineResourceWithAuthWithHttpInfo(QueryOnlineResourceV2Request body) throws ApiException {
        Call call = this.listOnlineResourceWithAuthValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<QueryOnlineResourceV2Response>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call listOnlineResourceWithAuthAsync(QueryOnlineResourceV2Request body, final ApiCallback<QueryOnlineResourceV2Response> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.listOnlineResourceWithAuthValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryOnlineResourceV2Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

