/*
 * Decompiled with CFR 0.152.
 */
package code.byted.inter.openapi;

import code.byted.inter.ApiCallback;
import code.byted.inter.ApiClient;
import code.byted.inter.ApiException;
import code.byted.inter.ApiResponse;
import code.byted.inter.Configuration;
import code.byted.inter.Pair;
import code.byted.inter.ProgressRequestBody;
import code.byted.inter.ProgressResponseBody;
import code.byted.inter.model.ByteDanceResponsePageResponseSegInnerResponse;
import code.byted.inter.model.ByteDanceResponseRecordSegShardInfoResp;
import code.byted.inter.model.ByteDanceResponseSegFileUploadResponse;
import code.byted.inter.model.LegacyUploadedSegCreateRequest;
import code.byted.inter.model.LoadRemoteSegRequest;
import code.byted.inter.model.SegmentListRequest;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SegmentationApi {
    private ApiClient apiClient;

    public SegmentationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call legacyCreateUploadSegmentCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LegacyUploadedSegCreateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyCreateUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyCreateUploadSegmentValidateBeforeCall(LegacyUploadedSegCreateRequest body, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateUploadSegment(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateUploadSegment(Async)");
        }
        Call call = this.legacyCreateUploadSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseRecordSegShardInfoResp legacyCreateUploadSegment(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseRecordSegShardInfoResp> resp = this.legacyCreateUploadSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseRecordSegShardInfoResp> legacyCreateUploadSegmentWithHttpInfo(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        Call call = this.legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call legacyCreateUploadSegmentAsync(LegacyUploadedSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseRecordSegShardInfoResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getSegmentListV2Call(String xTenant, SegmentListRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SegmentListRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getSegmentListV2"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSegmentListV2ValidateBeforeCall(String xTenant, SegmentListRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getSegmentListV2(Async)");
        }
        Call call = this.getSegmentListV2Call(xTenant, body, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponsePageResponseSegInnerResponse getSegmentListV2(String xTenant, SegmentListRequest body) throws ApiException {
        ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> resp = this.getSegmentListV2WithHttpInfo(xTenant, body);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> getSegmentListV2WithHttpInfo(String xTenant, SegmentListRequest body) throws ApiException {
        Call call = this.getSegmentListV2ValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getSegmentListV2Async(String xTenant, SegmentListRequest body, final ApiCallback<ByteDanceResponsePageResponseSegInnerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.getSegmentListV2ValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call loadRemoteHdfsSegCall(LoadRemoteSegRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LoadRemoteSegRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "loadRemoteHdfsSeg"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadRemoteHdfsSegValidateBeforeCall(LoadRemoteSegRequest body, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling loadRemoteHdfsSeg(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling loadRemoteHdfsSeg(Async)");
        }
        Call call = this.loadRemoteHdfsSegCall(body, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegFileUploadResponse loadRemoteHdfsSeg(LoadRemoteSegRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegFileUploadResponse> resp = this.loadRemoteHdfsSegWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegFileUploadResponse> loadRemoteHdfsSegWithHttpInfo(LoadRemoteSegRequest body, Integer tenantId) throws ApiException {
        Call call = this.loadRemoteHdfsSegValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegFileUploadResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call loadRemoteHdfsSegAsync(LoadRemoteSegRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseSegFileUploadResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.loadRemoteHdfsSegValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegFileUploadResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

