/*
 * Decompiled with CFR 0.152.
 */
package code.byted.inter.openapi;

import code.byted.inter.ApiCallback;
import code.byted.inter.ApiClient;
import code.byted.inter.ApiException;
import code.byted.inter.ApiResponse;
import code.byted.inter.Configuration;
import code.byted.inter.Pair;
import code.byted.inter.ProgressRequestBody;
import code.byted.inter.ProgressResponseBody;
import code.byted.inter.model.ByteDanceResponsePageResponseSegInnerResponse;
import code.byted.inter.model.ByteDanceResponseRecordSegShardInfoResp;
import code.byted.inter.model.ByteDanceResponseSegFileUploadResponse;
import code.byted.inter.model.ByteDanceResponseSegGroupInfo;
import code.byted.inter.model.ByteDanceResponseSegInnerResponse;
import code.byted.inter.model.ByteDanceResponseSegmentationRefreshResp;
import code.byted.inter.model.ByteDanceResponseSegmentationResp;
import code.byted.inter.model.CommonResponse;
import code.byted.inter.model.DslReq;
import code.byted.inter.model.LegacyUploadedSegCreateRequest;
import code.byted.inter.model.LoadRemoteSegRequest;
import code.byted.inter.model.PreviewResp;
import code.byted.inter.model.SegPreviewRequest;
import code.byted.inter.model.SegmentListRequest;
import code.byted.inter.model.ServiceRespBitmapPreviewOpenApiResponse;
import code.byted.inter.model.SimplifiedSegCreateOrUpdateRequest;
import code.byted.inter.model.UploadSegUpdateRequest;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SegmentationApi {
    private ApiClient apiClient;

    public SegmentationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createConditionalSegmentCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SimplifiedSegCreateOrUpdateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "createConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createConditionalSegmentValidateBeforeCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling createConditionalSegment(Async)");
        }
        Call call = this.createConditionalSegmentCall(tenantId, body, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationResp createConditionalSegment(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = this.createConditionalSegmentWithHttpInfo(tenantId, body);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationResp> createConditionalSegmentWithHttpInfo(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        Call call = this.createConditionalSegmentValidateBeforeCall(tenantId, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call createConditionalSegmentAsync(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.createConditionalSegmentValidateBeforeCall(tenantId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getSegGroupListCall(Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getSegGroupList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSegGroupListValidateBeforeCall(Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getSegGroupList(Async)");
        }
        Call call = this.getSegGroupListCall(tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegGroupInfo getSegGroupList(Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegGroupInfo> resp = this.getSegGroupListWithHttpInfo(tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegGroupInfo> getSegGroupListWithHttpInfo(Integer tenantId) throws ApiException {
        Call call = this.getSegGroupListValidateBeforeCall(tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegGroupInfo>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getSegGroupListAsync(Integer tenantId, final ApiCallback<ByteDanceResponseSegGroupInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.getSegGroupListValidateBeforeCall(tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegGroupInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getSegmentCall(String xTenant, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSegmentValidateBeforeCall(String xTenant, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling getSegment(Async)");
        }
        Call call = this.getSegmentCall(xTenant, segId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegInnerResponse getSegment(String xTenant, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegInnerResponse> resp = this.getSegmentWithHttpInfo(xTenant, segId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegInnerResponse> getSegmentWithHttpInfo(String xTenant, Integer segId) throws ApiException {
        Call call = this.getSegmentValidateBeforeCall(xTenant, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegInnerResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getSegmentAsync(String xTenant, Integer segId, final ApiCallback<ByteDanceResponseSegInnerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.getSegmentValidateBeforeCall(xTenant, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegInnerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call getSegmentListV2Call(String xTenant, SegmentListRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SegmentListRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "getSegmentListV2"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-05-22"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", this.apiClient.parameterToString(xTenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSegmentListV2ValidateBeforeCall(String xTenant, SegmentListRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getSegmentListV2(Async)");
        }
        Call call = this.getSegmentListV2Call(xTenant, body, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponsePageResponseSegInnerResponse getSegmentListV2(String xTenant, SegmentListRequest body) throws ApiException {
        ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> resp = this.getSegmentListV2WithHttpInfo(xTenant, body);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> getSegmentListV2WithHttpInfo(String xTenant, SegmentListRequest body) throws ApiException {
        Call call = this.getSegmentListV2ValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call getSegmentListV2Async(String xTenant, SegmentListRequest body, final ApiCallback<ByteDanceResponsePageResponseSegInnerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.getSegmentListV2ValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call legacyCreateUploadSegmentCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LegacyUploadedSegCreateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "legacyCreateUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-02-10"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call legacyCreateUploadSegmentValidateBeforeCall(LegacyUploadedSegCreateRequest body, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateUploadSegment(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateUploadSegment(Async)");
        }
        Call call = this.legacyCreateUploadSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseRecordSegShardInfoResp legacyCreateUploadSegment(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseRecordSegShardInfoResp> resp = this.legacyCreateUploadSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseRecordSegShardInfoResp> legacyCreateUploadSegmentWithHttpInfo(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        Call call = this.legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call legacyCreateUploadSegmentAsync(LegacyUploadedSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseRecordSegShardInfoResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call loadRemoteHdfsSegCall(LoadRemoteSegRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LoadRemoteSegRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "loadRemoteHdfsSeg"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadRemoteHdfsSegValidateBeforeCall(LoadRemoteSegRequest body, Integer tenantId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling loadRemoteHdfsSeg(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling loadRemoteHdfsSeg(Async)");
        }
        Call call = this.loadRemoteHdfsSegCall(body, tenantId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegFileUploadResponse loadRemoteHdfsSeg(LoadRemoteSegRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegFileUploadResponse> resp = this.loadRemoteHdfsSegWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegFileUploadResponse> loadRemoteHdfsSegWithHttpInfo(LoadRemoteSegRequest body, Integer tenantId) throws ApiException {
        Call call = this.loadRemoteHdfsSegValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegFileUploadResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call loadRemoteHdfsSegAsync(LoadRemoteSegRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseSegFileUploadResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.loadRemoteHdfsSegValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegFileUploadResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call modifyConditionalSegmentCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SimplifiedSegCreateOrUpdateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "modifyConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call modifyConditionalSegmentValidateBeforeCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling modifyConditionalSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifyConditionalSegment(Async)");
        }
        Call call = this.modifyConditionalSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponse modifyConditionalSegment(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<CommonResponse> resp = this.modifyConditionalSegmentWithHttpInfo(tenantId, segId, body);
        return resp.getData();
    }

    public ApiResponse<CommonResponse> modifyConditionalSegmentWithHttpInfo(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        Call call = this.modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call modifyConditionalSegmentAsync(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<CommonResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call modifyUploadSegmentCall(UploadSegUpdateRequest body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UploadSegUpdateRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "modifyUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call modifyUploadSegmentValidateBeforeCall(UploadSegUpdateRequest body, Integer tenantId, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling modifyUploadSegment(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling modifyUploadSegment(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifyUploadSegment(Async)");
        }
        Call call = this.modifyUploadSegmentCall(body, tenantId, segId, progressListener, progressRequestListener);
        return call;
    }

    public CommonResponse modifyUploadSegment(UploadSegUpdateRequest body, Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<CommonResponse> resp = this.modifyUploadSegmentWithHttpInfo(body, tenantId, segId);
        return resp.getData();
    }

    public ApiResponse<CommonResponse> modifyUploadSegmentWithHttpInfo(UploadSegUpdateRequest body, Integer tenantId, Integer segId) throws ApiException {
        Call call = this.modifyUploadSegmentValidateBeforeCall(body, tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call modifyUploadSegmentAsync(UploadSegUpdateRequest body, Integer tenantId, Integer segId, final ApiCallback<CommonResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.modifyUploadSegmentValidateBeforeCall(body, tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call previewAssetCall(SegPreviewRequest body, String tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SegPreviewRequest localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenant", tenant.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "previewAsset"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-08-05"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call previewAssetValidateBeforeCall(SegPreviewRequest body, String tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling previewAsset(Async)");
        }
        if (tenant == null) {
            throw new ApiException("Missing the required parameter 'tenant' when calling previewAsset(Async)");
        }
        Call call = this.previewAssetCall(body, tenant, progressListener, progressRequestListener);
        return call;
    }

    public ServiceRespBitmapPreviewOpenApiResponse previewAsset(SegPreviewRequest body, String tenant) throws ApiException {
        ApiResponse<ServiceRespBitmapPreviewOpenApiResponse> resp = this.previewAssetWithHttpInfo(body, tenant);
        return resp.getData();
    }

    public ApiResponse<ServiceRespBitmapPreviewOpenApiResponse> previewAssetWithHttpInfo(SegPreviewRequest body, String tenant) throws ApiException {
        Call call = this.previewAssetValidateBeforeCall(body, tenant, null, null);
        Type localVarReturnType = new TypeToken<ServiceRespBitmapPreviewOpenApiResponse>(){}.getType();
        String[] localVarAccepts = new String[]{"*/*"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call previewAssetAsync(SegPreviewRequest body, String tenant, final ApiCallback<ServiceRespBitmapPreviewOpenApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"*/*"};
        Call call = this.previewAssetValidateBeforeCall(body, tenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceRespBitmapPreviewOpenApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call refreshSegCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "refreshSeg"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-06-20"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call refreshSegValidateBeforeCall(Integer tenantId, Integer segId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling refreshSeg(Async)");
        }
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling refreshSeg(Async)");
        }
        Call call = this.refreshSegCall(tenantId, segId, progressListener, progressRequestListener);
        return call;
    }

    public ByteDanceResponseSegmentationRefreshResp refreshSeg(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationRefreshResp> resp = this.refreshSegWithHttpInfo(tenantId, segId);
        return resp.getData();
    }

    public ApiResponse<ByteDanceResponseSegmentationRefreshResp> refreshSegWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        Call call = this.refreshSegValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call refreshSegAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationRefreshResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json"};
        Call call = this.refreshSegValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    public Call previewDSLCall(DslReq body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DslReq localVarPostBody = body;
        String localVarPath = "";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("Action", "QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version", "2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction", "previewDSL"));
        localVarQueryParams.add(new Pair("ApiVersion", "2023-08-08"));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call previewDSLValidateBeforeCall(DslReq body, String tenantCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling previewDSL(Async)");
        }
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling previewDSL(Async)");
        }
        Call call = this.previewDSLCall(body, tenantCode, progressListener, progressRequestListener);
        return call;
    }

    public PreviewResp previewDSL(DslReq body, String tenantCode) throws ApiException {
        ApiResponse<PreviewResp> resp = this.previewDSLWithHttpInfo(body, tenantCode);
        return resp.getData();
    }

    public ApiResponse<PreviewResp> previewDSLWithHttpInfo(DslReq body, String tenantCode) throws ApiException {
        Call call = this.previewDSLValidateBeforeCall(body, tenantCode, null, null);
        Type localVarReturnType = new TypeToken<PreviewResp>(){}.getType();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        return this.apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    public Call previewDSLAsync(DslReq body, String tenantCode, final ApiCallback<PreviewResp> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        Call call = this.previewDSLValidateBeforeCall(body, tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PreviewResp>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}

