/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.AnalysisAttributionObj;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * BaseDimension
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class BaseDimension {
  /**
   * 分析类型
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    USER_TENDENCY("USER_TENDENCY"),
    TRANS("TRANS"),
    ATTRIBUTION("ATTRIBUTION"),
    ATTRIBUTION_COLUMN("ATTRIBUTION_COLUMN"),
    NORMAL("NORMAL"),
    NORMAL_COLUMN("NORMAL_COLUMN"),
    CROSS_DIMENSION("CROSS_DIMENSION"),
    NORMAL_COLUMN_LINKAGE("NORMAL_COLUMN_LINKAGE"),
    NORMAL_COUNT("NORMAL_COUNT"),
    CROSS_DIMENSION_MERGE("CROSS_DIMENSION_MERGE"),
    EXTRA("EXTRA");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("attributionObj")
  private AnalysisAttributionObj attributionObj = null;

  @SerializedName("attributionEvent")
  private List<AnalysisAttributionObj> attributionEvent = null;

  @SerializedName("dateAggregate")
  private Boolean dateAggregate = null;

  @SerializedName("attributionObjs")
  private List<AnalysisAttributionObj> attributionObjs = null;

  @SerializedName("dimensionFilters")
  private List<List<String>> dimensionFilters = null;

  public BaseDimension type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * 分析类型
   * @return type
  **/
  @Schema(description = "分析类型")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public BaseDimension attributionObj(AnalysisAttributionObj attributionObj) {
    this.attributionObj = attributionObj;
    return this;
  }

   /**
   * Get attributionObj
   * @return attributionObj
  **/
  @Schema(description = "")
  public AnalysisAttributionObj getAttributionObj() {
    return attributionObj;
  }

  public void setAttributionObj(AnalysisAttributionObj attributionObj) {
    this.attributionObj = attributionObj;
  }

  public BaseDimension attributionEvent(List<AnalysisAttributionObj> attributionEvent) {
    this.attributionEvent = attributionEvent;
    return this;
  }

  public BaseDimension addAttributionEventItem(AnalysisAttributionObj attributionEventItem) {
    if (this.attributionEvent == null) {
      this.attributionEvent = new ArrayList<AnalysisAttributionObj>();
    }
    this.attributionEvent.add(attributionEventItem);
    return this;
  }

   /**
   * 归因分析归因目标事件
   * @return attributionEvent
  **/
  @Schema(description = "归因分析归因目标事件")
  public List<AnalysisAttributionObj> getAttributionEvent() {
    return attributionEvent;
  }

  public void setAttributionEvent(List<AnalysisAttributionObj> attributionEvent) {
    this.attributionEvent = attributionEvent;
  }

  public BaseDimension dateAggregate(Boolean dateAggregate) {
    this.dateAggregate = dateAggregate;
    return this;
  }

   /**
   * 是否按日期聚合
   * @return dateAggregate
  **/
  @Schema(description = "是否按日期聚合")
  public Boolean isDateAggregate() {
    return dateAggregate;
  }

  public void setDateAggregate(Boolean dateAggregate) {
    this.dateAggregate = dateAggregate;
  }

  public BaseDimension attributionObjs(List<AnalysisAttributionObj> attributionObjs) {
    this.attributionObjs = attributionObjs;
    return this;
  }

  public BaseDimension addAttributionObjsItem(AnalysisAttributionObj attributionObjsItem) {
    if (this.attributionObjs == null) {
      this.attributionObjs = new ArrayList<AnalysisAttributionObj>();
    }
    this.attributionObjs.add(attributionObjsItem);
    return this;
  }

   /**
   * 交叉维度
   * @return attributionObjs
  **/
  @Schema(description = "交叉维度")
  public List<AnalysisAttributionObj> getAttributionObjs() {
    return attributionObjs;
  }

  public void setAttributionObjs(List<AnalysisAttributionObj> attributionObjs) {
    this.attributionObjs = attributionObjs;
  }

  public BaseDimension dimensionFilters(List<List<String>> dimensionFilters) {
    this.dimensionFilters = dimensionFilters;
    return this;
  }

  public BaseDimension addDimensionFiltersItem(List<String> dimensionFiltersItem) {
    if (this.dimensionFilters == null) {
      this.dimensionFilters = new ArrayList<List<String>>();
    }
    this.dimensionFilters.add(dimensionFiltersItem);
    return this;
  }

   /**
   * 用于过滤需要使用的维度，主要用于交叉维度场景，二维数组，子数组顺序表示了需要保留的交叉维度
   * @return dimensionFilters
  **/
  @Schema(description = "用于过滤需要使用的维度，主要用于交叉维度场景，二维数组，子数组顺序表示了需要保留的交叉维度")
  public List<List<String>> getDimensionFilters() {
    return dimensionFilters;
  }

  public void setDimensionFilters(List<List<String>> dimensionFilters) {
    this.dimensionFilters = dimensionFilters;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseDimension baseDimension = (BaseDimension) o;
    return Objects.equals(this.type, baseDimension.type) &&
        Objects.equals(this.attributionObj, baseDimension.attributionObj) &&
        Objects.equals(this.attributionEvent, baseDimension.attributionEvent) &&
        Objects.equals(this.dateAggregate, baseDimension.dateAggregate) &&
        Objects.equals(this.attributionObjs, baseDimension.attributionObjs) &&
        Objects.equals(this.dimensionFilters, baseDimension.dimensionFilters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, attributionObj, attributionEvent, dateAggregate, attributionObjs, dimensionFilters);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseDimension {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    attributionObj: ").append(toIndentedString(attributionObj)).append("\n");
    sb.append("    attributionEvent: ").append(toIndentedString(attributionEvent)).append("\n");
    sb.append("    dateAggregate: ").append(toIndentedString(dateAggregate)).append("\n");
    sb.append("    attributionObjs: ").append(toIndentedString(attributionObjs)).append("\n");
    sb.append("    dimensionFilters: ").append(toIndentedString(dimensionFilters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
