/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * BasePeriod
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class BasePeriod {
  @SerializedName("startTime")
  private String startTime = null;

  @SerializedName("endTime")
  private String endTime = null;

  /**
   * 时间单位
   */
  @JsonAdapter(PeriodRangeEnum.Adapter.class)
  public enum PeriodRangeEnum {
    UNKNOWN("Unknown"),
    YEAR("YEAR"),
    MONTH("MONTH"),
    WEEK("WEEK"),
    DAY("DAY"),
    HOUR("HOUR"),
    MINUTE("MINUTE");

    private String value;

    PeriodRangeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static PeriodRangeEnum fromValue(String input) {
      for (PeriodRangeEnum b : PeriodRangeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<PeriodRangeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PeriodRangeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public PeriodRangeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return PeriodRangeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("periodRange")
  private PeriodRangeEnum periodRange = null;

  @SerializedName("num")
  private Integer num = null;

  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    DATE("DATE"),
    RANGE("RANGE"),
    ZONE("ZONE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("baseTime")
  private String baseTime = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("offset")
  private Integer offset = null;

  public BasePeriod startTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

   /**
   * 开始时间
   * @return startTime
  **/
  @Schema(description = "开始时间")
  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public BasePeriod endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

   /**
   * 结束时间
   * @return endTime
  **/
  @Schema(description = "结束时间")
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public BasePeriod periodRange(PeriodRangeEnum periodRange) {
    this.periodRange = periodRange;
    return this;
  }

   /**
   * 时间单位
   * @return periodRange
  **/
  @Schema(description = "时间单位")
  public PeriodRangeEnum getPeriodRange() {
    return periodRange;
  }

  public void setPeriodRange(PeriodRangeEnum periodRange) {
    this.periodRange = periodRange;
  }

  public BasePeriod num(Integer num) {
    this.num = num;
    return this;
  }

   /**
   * 时间单位量
   * @return num
  **/
  @Schema(description = "时间单位量")
  public Integer getNum() {
    return num;
  }

  public void setNum(Integer num) {
    this.num = num;
  }

  public BasePeriod type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public BasePeriod baseTime(String baseTime) {
    this.baseTime = baseTime;
    return this;
  }

   /**
   * 基准时间
   * @return baseTime
  **/
  @Schema(description = "基准时间")
  public String getBaseTime() {
    return baseTime;
  }

  public void setBaseTime(String baseTime) {
    this.baseTime = baseTime;
  }

  public BasePeriod name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 时间周期名称
   * @return name
  **/
  @Schema(description = "时间周期名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public BasePeriod offset(Integer offset) {
    this.offset = offset;
    return this;
  }

   /**
   * 日期偏移
   * @return offset
  **/
  @Schema(description = "日期偏移")
  public Integer getOffset() {
    return offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BasePeriod basePeriod = (BasePeriod) o;
    return Objects.equals(this.startTime, basePeriod.startTime) &&
        Objects.equals(this.endTime, basePeriod.endTime) &&
        Objects.equals(this.periodRange, basePeriod.periodRange) &&
        Objects.equals(this.num, basePeriod.num) &&
        Objects.equals(this.type, basePeriod.type) &&
        Objects.equals(this.baseTime, basePeriod.baseTime) &&
        Objects.equals(this.name, basePeriod.name) &&
        Objects.equals(this.offset, basePeriod.offset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startTime, endTime, periodRange, num, type, baseTime, name, offset);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BasePeriod {\n");
    
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    periodRange: ").append(toIndentedString(periodRange)).append("\n");
    sb.append("    num: ").append(toIndentedString(num)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    baseTime: ").append(toIndentedString(baseTime)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
