package code.byted.cdp.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Data;

@Data
public class GetBusinessIdentityReq {
    //集团id
    //当project_id > 0时，为可选参数；否则，为必填参数（会做强制校验）
    @SerializedName("org_id")
    private Integer orgId;
    //项目id
    //当project_id = -1时，认为是集团资源，此时必传org_id
    @SerializedName("project_id")
    private Integer projectId;
    //权限类型
    //read_role/write_role/admin
    @SerializedName("action")
    private String action;
    //用户名
    @SerializedName("account")
    private String account;
    //资源范围
    //资源类型为cdp，项目/模块为cdp_module
    @SerializedName("service")
    private String service;
    //资源类型
    //资源线下注册的key，项目为app
    @SerializedName("resource_type")
    private String resourceType;
    //批量查询的资源id
    //在此范围内查询，不传查全量
    @SerializedName("filter_business_ids")
    private List<String> filterBusinessIds;

}
