/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.IdTypeMapping;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * IdType
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class IdType {
  @SerializedName("availableMappingIds")
  private List<IdTypeMapping> availableMappingIds = null;

  @SerializedName("code")
  private String code = null;

  @SerializedName("dataType")
  private String dataType = null;

  /**
   * Gets or Sets entityType
   */
  @JsonAdapter(EntityTypeEnum.Adapter.class)
  public enum EntityTypeEnum {
    UNKNOWN("Unknown"),
    BASEID("BaseId"),
    PHONE("Phone"),
    PHONE_SHA256("Phone_SHA256"),
    IDFA("IDFA"),
    IDFA_MD5("IDFA_MD5"),
    IMEI("IMEI"),
    IMEI_MD5("IMEI_MD5"),
    OAID("OAID"),
    OAID_MD5("OAID_MD5"),
    DEVICEID("DeviceID"),
    PRIVATEID("PrivateID"),
    BYTEID("ByteId"),
    DY_MPID_OPENID("DY_MpID_OpenID"),
    DY_MPID_OPENID_MD5("DY_MpID_OpenID_MD5");

    private String value;

    EntityTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static EntityTypeEnum fromValue(String input) {
      for (EntityTypeEnum b : EntityTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<EntityTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EntityTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public EntityTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return EntityTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("entityType")
  private EntityTypeEnum entityType = null;

  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("needEncrypt")
  private Boolean needEncrypt = null;

  @SerializedName("orgId")
  private Integer orgId = null;

  @SerializedName("parentId")
  private Integer parentId = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("subjectName")
  private String subjectName = null;

  @SerializedName("subjectType")
  private String subjectType = null;

  public IdType availableMappingIds(List<IdTypeMapping> availableMappingIds) {
    this.availableMappingIds = availableMappingIds;
    return this;
  }

  public IdType addAvailableMappingIdsItem(IdTypeMapping availableMappingIdsItem) {
    if (this.availableMappingIds == null) {
      this.availableMappingIds = new ArrayList<IdTypeMapping>();
    }
    this.availableMappingIds.add(availableMappingIdsItem);
    return this;
  }

   /**
   * Get availableMappingIds
   * @return availableMappingIds
  **/
  @Schema(description = "")
  public List<IdTypeMapping> getAvailableMappingIds() {
    return availableMappingIds;
  }

  public void setAvailableMappingIds(List<IdTypeMapping> availableMappingIds) {
    this.availableMappingIds = availableMappingIds;
  }

  public IdType code(String code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @Schema(required = true, description = "")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public IdType dataType(String dataType) {
    this.dataType = dataType;
    return this;
  }

   /**
   * Get dataType
   * @return dataType
  **/
  @Schema(required = true, description = "")
  public String getDataType() {
    return dataType;
  }

  public void setDataType(String dataType) {
    this.dataType = dataType;
  }

  public IdType entityType(EntityTypeEnum entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * Get entityType
   * @return entityType
  **/
  @Schema(description = "")
  public EntityTypeEnum getEntityType() {
    return entityType;
  }

  public void setEntityType(EntityTypeEnum entityType) {
    this.entityType = entityType;
  }

  public IdType id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(required = true, description = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public IdType name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public IdType needEncrypt(Boolean needEncrypt) {
    this.needEncrypt = needEncrypt;
    return this;
  }

   /**
   * Get needEncrypt
   * @return needEncrypt
  **/
  @Schema(required = true, description = "")
  public Boolean isNeedEncrypt() {
    return needEncrypt;
  }

  public void setNeedEncrypt(Boolean needEncrypt) {
    this.needEncrypt = needEncrypt;
  }

  public IdType orgId(Integer orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * Get orgId
   * @return orgId
  **/
  @Schema(required = true, description = "")
  public Integer getOrgId() {
    return orgId;
  }

  public void setOrgId(Integer orgId) {
    this.orgId = orgId;
  }

  public IdType parentId(Integer parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * Get parentId
   * @return parentId
  **/
  @Schema(description = "")
  public Integer getParentId() {
    return parentId;
  }

  public void setParentId(Integer parentId) {
    this.parentId = parentId;
  }

  public IdType subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * Get subjectId
   * @return subjectId
  **/
  @Schema(required = true, description = "")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public IdType subjectName(String subjectName) {
    this.subjectName = subjectName;
    return this;
  }

   /**
   * Get subjectName
   * @return subjectName
  **/
  @Schema(required = true, description = "")
  public String getSubjectName() {
    return subjectName;
  }

  public void setSubjectName(String subjectName) {
    this.subjectName = subjectName;
  }

  public IdType subjectType(String subjectType) {
    this.subjectType = subjectType;
    return this;
  }

   /**
   * Get subjectType
   * @return subjectType
  **/
  @Schema(required = true, description = "")
  public String getSubjectType() {
    return subjectType;
  }

  public void setSubjectType(String subjectType) {
    this.subjectType = subjectType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IdType idType = (IdType) o;
    return Objects.equals(this.availableMappingIds, idType.availableMappingIds) &&
        Objects.equals(this.code, idType.code) &&
        Objects.equals(this.dataType, idType.dataType) &&
        Objects.equals(this.entityType, idType.entityType) &&
        Objects.equals(this.id, idType.id) &&
        Objects.equals(this.name, idType.name) &&
        Objects.equals(this.needEncrypt, idType.needEncrypt) &&
        Objects.equals(this.orgId, idType.orgId) &&
        Objects.equals(this.parentId, idType.parentId) &&
        Objects.equals(this.subjectId, idType.subjectId) &&
        Objects.equals(this.subjectName, idType.subjectName) &&
        Objects.equals(this.subjectType, idType.subjectType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(availableMappingIds, code, dataType, entityType, id, name, needEncrypt, orgId, parentId, subjectId, subjectName, subjectType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IdType {\n");
    
    sb.append("    availableMappingIds: ").append(toIndentedString(availableMappingIds)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    needEncrypt: ").append(toIndentedString(needEncrypt)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    subjectName: ").append(toIndentedString(subjectName)).append("\n");
    sb.append("    subjectType: ").append(toIndentedString(subjectType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
